/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors;

import java.util.Map;
import net.serenitybdd.core.collect.NewMap;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.reports.adaptors.TestOutcomeAdaptor;
import net.thucydides.core.reports.adaptors.UnknownAdaptor;
import net.thucydides.core.reports.adaptors.lettuce.LettuceXUnitAdaptor;
import net.thucydides.core.reports.adaptors.specflow.SpecflowAdaptor;
import net.thucydides.core.reports.adaptors.xunit.DefaultXUnitAdaptor;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class AdaptorService {
    private static final Map<String, ? extends TestOutcomeAdaptor> BUILT_IN_ADAPTORS = NewMap.of("xunit", new DefaultXUnitAdaptor(), "specflow", new SpecflowAdaptor(), "lettuce", new LettuceXUnitAdaptor());
    private final EnvironmentVariables environmentVariables;

    public AdaptorService(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public AdaptorService() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public TestOutcomeAdaptor getAdaptor(String name) {
        if (BUILT_IN_ADAPTORS.containsKey(name)) {
            return BUILT_IN_ADAPTORS.get(name);
        }
        String customAdaptor = EnvironmentSpecificConfiguration.from(this.environmentVariables).getOptionalProperty("serenity.adaptors." + name).orElse(EnvironmentSpecificConfiguration.from(this.environmentVariables).getOptionalProperty("thucydides.adaptors." + name).orElse(null));
        if (StringUtils.isNotEmpty((CharSequence)customAdaptor)) {
            return this.newAdaptor(customAdaptor);
        }
        throw new UnknownAdaptor("Unknown test outcome adaptor: " + name);
    }

    private TestOutcomeAdaptor newAdaptor(String customAdaptor) {
        try {
            return (TestOutcomeAdaptor)Class.forName(customAdaptor).newInstance();
        }
        catch (Exception e) {
            throw new UnknownAdaptor("Test outcome adaptor could not be instanciated: " + customAdaptor, e);
        }
    }
}

