/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reflection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackTraceAnalyser {
    private final StackTraceElement stackTraceElement;
    private final Logger logger = LoggerFactory.getLogger(StackTraceAnalyser.class);
    private static final List<String> HIDDEN_PACKAGES = NewList.of("sun.", "java", "org.gradle");

    private StackTraceAnalyser(StackTraceElement stackTraceElement) {
        this.stackTraceElement = stackTraceElement;
    }

    public static StackTraceAnalyser forStackTraceElement(StackTraceElement stackTraceElement) {
        return new StackTraceAnalyser(stackTraceElement);
    }

    public Method getMethod() {
        try {
            if (this.allowedClassName(this.stackTraceElement.getClassName()) && !this.lambda(this.stackTraceElement.getClassName())) {
                Class<?> callingClass = Class.forName(this.stackTraceElement.getClassName());
                if (this.stackTraceElement.getClassName().contains("$") && (callingClass = callingClass.getSuperclass()) == null) {
                    this.logger.trace("Ignored class without superclass: " + this.stackTraceElement.getClassName());
                    return null;
                }
                return StackTraceAnalyser.extractMethod(this.stackTraceElement, callingClass);
            }
        }
        catch (ClassNotFoundException classNotFoundIgnored) {
            this.logger.trace("Couldn't find class during Stack analysis: " + classNotFoundIgnored.getLocalizedMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundErrorIgnored) {
            this.logger.trace("Couldn't find class definition during Stack analysis: " + noClassDefFoundErrorIgnored.getLocalizedMessage());
        }
        return null;
    }

    public Method getUnfilteredMethod() {
        try {
            Class<?> callingClass = Class.forName(this.stackTraceElement.getClassName());
            Method matchingMethod = StackTraceAnalyser.extractMethod(this.stackTraceElement, callingClass);
            if (matchingMethod != null) {
                return matchingMethod;
            }
        }
        catch (ClassNotFoundException classNotFoundIgnored) {
            this.logger.debug("Couldn't find class during Stack analysis: " + classNotFoundIgnored.getLocalizedMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundErrorIgnored) {
            this.logger.debug("Couldn't find class definition during Stack analysis: " + noClassDefFoundErrorIgnored.getLocalizedMessage());
        }
        return null;
    }

    private boolean lambda(String className) {
        return className.contains("$$Lambda$");
    }

    public static Method extractMethod(StackTraceElement stackTraceElement, Class callingClass) {
        Class targetClass = StackTraceAnalyser.isInstrumentedMethod(stackTraceElement) ? callingClass.getSuperclass() : callingClass;
        try {
            Method methodFound = targetClass.getMethod(stackTraceElement.getMethodName(), new Class[0]);
            if (methodFound == null) {
                methodFound = targetClass.getDeclaredMethod(stackTraceElement.getMethodName(), new Class[0]);
            }
            return methodFound;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static boolean isInstrumentedMethod(StackTraceElement stackTraceElement) {
        return StringUtils.isNotEmpty((CharSequence)stackTraceElement.getFileName()) && stackTraceElement.getFileName().equals("<generated>");
    }

    private boolean allowedClassName(String className) {
        if (className.contains("$$")) {
            return false;
        }
        return !this.inHiddenPackage(className);
    }

    private boolean inHiddenPackage(String className) {
        for (String hiddenPackage : HIDDEN_PACKAGES) {
            if (!className.startsWith(hiddenPackage)) continue;
            return true;
        }
        return false;
    }

    public static List<Method> inscopeMethodsIn(StackTraceElement[] stackTrace) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (StackTraceElement stackTraceElement : stackTrace) {
            Method method = StackTraceAnalyser.forStackTraceElement(stackTraceElement).getMethod();
            if (method == null) continue;
            methods.add(method);
        }
        return methods;
    }

    public static List<Method> performAsMethodsIn(StackTraceElement[] stackTrace) {
        return Arrays.stream(stackTrace).filter(stackTraceElement -> stackTraceElement.getMethodName().equals("performAs")).map(StackTraceElement::getClassName).map(StackTraceAnalyser::uninstrumentedTaskClass).filter(Optional::isPresent).map(StackTraceAnalyser::performAsMethod).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Optional<Method> performAsMethod(Optional<Class<?>> taskClass) {
        return Arrays.stream(taskClass.get().getMethods()).filter(method -> method.getName().equals("performAs")).findFirst();
    }

    private static Optional<Class<?>> uninstrumentedTaskClass(String taskClassName) {
        try {
            Class<?> performingClass = Thread.currentThread().getContextClassLoader().loadClass(taskClassName);
            while (StackTraceAnalyser.isInstrumented(performingClass)) {
                performingClass = performingClass.getSuperclass();
            }
            return Optional.of(performingClass);
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private static boolean isInstrumented(Class<?> performingClass) {
        return performingClass.getName().contains("$");
    }
}

