/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.Objects;
import net.serenitybdd.core.strings.FirstLine;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.Feature;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.model.AnnotatedStoryTitle;
import net.thucydides.core.model.LastElement;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Stories;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.RootDirectory;
import net.thucydides.core.requirements.model.FeatureType;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class Story {
    private String id;
    private String storyName;
    private String displayName;
    private String storyClassName;
    private String path;
    private String narrative;
    private ApplicationFeature feature;
    private String type;

    protected Story(Class<?> userStoryClass) {
        this.id = userStoryClass.getCanonicalName();
        this.storyClassName = userStoryClass.getName();
        this.storyName = NameConverter.humanize(userStoryClass.getSimpleName());
        this.displayName = AnnotatedStoryTitle.forClass(userStoryClass).orElse(NameConverter.humanize(userStoryClass.getSimpleName()));
        this.feature = this.findFeatureFrom(userStoryClass);
        this.path = this.pathOf(userStoryClass);
        this.type = FeatureType.STORY.toString();
    }

    private String pathOf(Class<?> userStoryClass) {
        String canonicalName = userStoryClass.getCanonicalName();
        String localPath = this.stripRootPathFrom(canonicalName);
        int lastDot = localPath.lastIndexOf(".");
        if (lastDot > 0) {
            return localPath.substring(0, lastDot);
        }
        return "";
    }

    private String stripRootPathFrom(String testOutcomePath) {
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        if (testOutcomePath == null) {
            return "";
        }
        String rootPath = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)rootPath) && testOutcomePath.startsWith(rootPath) && !testOutcomePath.equals(rootPath)) {
            return testOutcomePath.substring(rootPath.length() + 1);
        }
        return testOutcomePath;
    }

    private ApplicationFeature findFeatureFrom(Class<?> userStoryClass) {
        if (Story.getFeatureClass(userStoryClass) != null) {
            return ApplicationFeature.from(Story.getFeatureClass(userStoryClass));
        }
        return null;
    }

    public Story(String id, String storyName, String storyClassName, String displayName, String path, ApplicationFeature feature) {
        this.id = id;
        this.storyName = storyName;
        this.storyClassName = storyClassName;
        this.displayName = displayName;
        this.feature = feature;
        this.path = path;
        this.narrative = null;
        this.type = FeatureType.STORY.toString();
    }

    public Story(String id, String storyName, String storyClassName, String displayName, String path, ApplicationFeature feature, String narrative) {
        this(id, storyName, storyClassName, displayName, path, feature, narrative, FeatureType.STORY.toString());
    }

    public Story(String id, String storyName, String storyClassName, String displayName, String path, ApplicationFeature feature, String narrative, String type) {
        this.id = id;
        this.storyName = storyName;
        this.storyClassName = storyClassName;
        this.displayName = displayName;
        this.feature = feature;
        this.path = path;
        this.narrative = narrative;
        this.type = type;
    }

    protected Story(String id, String storyName, String displayName, ApplicationFeature feature, String path) {
        this.id = id;
        this.storyName = storyName;
        this.displayName = displayName;
        this.storyClassName = null;
        this.feature = feature;
        this.path = path;
        this.type = FeatureType.STORY.toString();
    }

    public String getId() {
        return this.id;
    }

    public static Story from(Class<?> userStoryClass) {
        return new Story(userStoryClass);
    }

    public static Story withId(String storyId, String storyName) {
        return new Story(storyId, storyName, null, null, null);
    }

    public Story withNarrative(String narrative) {
        return new Story(this.id, this.storyName, this.storyClassName, this.displayName, this.path, this.feature, narrative, this.type);
    }

    public Story withType(String type) {
        return new Story(this.id, this.storyName, this.storyClassName, this.displayName, this.path, this.feature, this.narrative, type);
    }

    public static Story withIdAndPath(String storyId, String storyName, String storyPath) {
        return new Story(storyId, storyName, null, storyName, storyPath, null);
    }

    public static Story called(String storyName) {
        return new Story(storyName, storyName, null, null, null);
    }

    public static Story withId(String storyId, String storyName, String featureClassName, String featureName) {
        return new Story(storyId, storyName, storyName, new ApplicationFeature(featureClassName, featureName), null);
    }

    public static Story withIdAndPathAndFeature(String storyId, String storyName, String storyPath, String featureClassName, String featureName) {
        return new Story(storyId, storyName, storyName, new ApplicationFeature(featureClassName, featureName), storyPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Story)) {
            return false;
        }
        Story story = (Story)o;
        if (!this.id.equals(story.id)) {
            return false;
        }
        return Objects.equals(this.path, story.path);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public static Class<?> getFeatureClass(Class<?> userStoryClass) {
        Class<?> enclosingClass;
        if (userStoryClass != null && Story.isAFeature(enclosingClass = userStoryClass.getEnclosingClass())) {
            return enclosingClass;
        }
        return null;
    }

    private static boolean isAFeature(Class<?> enclosingClass) {
        return enclosingClass != null && enclosingClass.getAnnotation(Feature.class) != null;
    }

    public static Class<?> testedInTestCase(Class<?> testClass) {
        net.thucydides.core.annotations.Story story = testClass.getAnnotation(net.thucydides.core.annotations.Story.class);
        if (story != null) {
            return story.value();
        }
        return null;
    }

    public String getName() {
        return this.storyName;
    }

    public String getDisplayName() {
        return StringUtils.isNotEmpty((CharSequence)this.displayName) ? this.displayName : this.storyName;
    }

    public String getStoryClassName() {
        return this.storyClassName;
    }

    public String getReportName(ReportType type) {
        return Stories.reportFor(this, type);
    }

    public String getReportName() {
        return new ReportNameProvider().forRequirement(this.asTag());
    }

    public ApplicationFeature getFeature() {
        return this.feature;
    }

    public String getPath() {
        return this.path;
    }

    public String getStoryName() {
        return this.storyName;
    }

    public String getNarrative() {
        return this.narrative;
    }

    public String getNarrativeSummary() {
        return FirstLine.of(this.narrative);
    }

    public String getType() {
        return this.type;
    }

    public Story withPath(String path) {
        return new Story(this.id, this.storyName, this.storyClassName, this.displayName, path, this.feature, this.narrative, FeatureType.forFilename(path).toString());
    }

    public Story asFeature() {
        return new Story(this.id, this.storyName, this.storyClassName, this.displayName, this.path, this.feature, this.narrative, FeatureType.FEATURE.toString());
    }

    public TestTag asTag() {
        return this.asQualifiedTag();
    }

    public TestTag asQualifiedTag() {
        String parentName;
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        String featureDirectoryName = RootDirectory.definedIn(environmentVariables).featureDirectoryName();
        String lastElementOfPath = LastElement.of(this.getPath());
        String string = parentName = this.getPath() != null ? NameConverter.humanize(lastElementOfPath) : null;
        if (featureDirectoryName.equalsIgnoreCase(lastElementOfPath)) {
            parentName = null;
        }
        return StringUtils.isNotEmpty((CharSequence)parentName) ? TestTag.withName(parentName + "/" + this.storyName).andType(this.type) : TestTag.withName(this.storyName).andType(this.type);
    }
}

