/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;

public class AnnotatedStoryTitle {
    public static Optional<String> forClass(Class<?> userStoryClass) {
        Optional<Annotation> displayNameAnnotation = Arrays.stream(userStoryClass.getAnnotations()).filter(AnnotatedStoryTitle.isCalledDisplayName()).findFirst();
        if (displayNameAnnotation.isPresent()) {
            try {
                String annotatedName = displayNameAnnotation.get().annotationType().getMethods()[0].invoke((Object)displayNameAnnotation.get(), new Object[0]).toString();
                return Optional.ofNullable(annotatedName);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static Predicate<Annotation> isCalledDisplayName() {
        return annotation -> annotation.annotationType().getSimpleName().equals("DisplayName");
    }
}

