/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.logging;

import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;

public class ConsoleColors {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[91m";
    private static final String ANSI_GREEN = "\u001b[92m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_PURPLE = "\u001b[95m";
    private static final String ANSI_CYAN = "\u001b[96m";
    public static final String HIGH_INTENSITY = "\u001b[1m";
    public static final String LOW_INTENSITY = "\u001b[2m";
    private final EnvironmentVariables environmentVariables;

    public ConsoleColors(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    private boolean showColoredOutput() {
        return ThucydidesSystemProperty.SERENITY_CONSOLE_COLORS.booleanFrom(this.environmentVariables, false);
    }

    public String red(String text) {
        return this.showColoredOutput() ? ANSI_RED + text + ANSI_RESET : text;
    }

    public String grey(String text) {
        return this.showColoredOutput() ? ANSI_RED + text + ANSI_RESET : text;
    }

    public String green(String text) {
        return this.showColoredOutput() ? ANSI_GREEN + text + ANSI_RESET : text;
    }

    public String yellow(String text) {
        return this.showColoredOutput() ? ANSI_YELLOW + text + ANSI_RESET : text;
    }

    public String cyan(String text) {
        return this.showColoredOutput() ? ANSI_CYAN + text + ANSI_RESET : text;
    }

    public String purple(String text) {
        return this.showColoredOutput() ? ANSI_PURPLE + text + ANSI_RESET : text;
    }

    public String white(String text) {
        return text;
    }

    public String bold(String text) {
        return this.showColoredOutput() ? HIGH_INTENSITY + text + ANSI_RESET : text;
    }
}

