/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.json;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.serenitybdd.reports.io.ReportIOKt;
import net.serenitybdd.reports.json.Formatted;
import net.serenitybdd.reports.json.JsonSummaryReport;
import net.serenitybdd.reports.json.JsonSummaryReporterKt;
import net.serenitybdd.reports.model.CustomReportFields;
import net.serenitybdd.reports.model.DurationsKt;
import net.serenitybdd.reports.model.FailuresByFeature;
import net.serenitybdd.reports.model.FrequentFailures;
import net.serenitybdd.reports.model.ReportInfo;
import net.serenitybdd.reports.model.ResultsCountKt;
import net.serenitybdd.reports.model.TagCoverage;
import net.serenitybdd.reports.model.TagResults;
import net.serenitybdd.reports.model.TestResultSummary;
import net.serenitybdd.reports.model.TestResultsByFeature;
import net.serenitybdd.reports.model.UnstableFeatures;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.ExtendedReport;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.Merger;
import net.thucydides.core.util.EnvironmentVariables;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/serenitybdd/reports/json/JsonSummaryReporter;", "Lnet/thucydides/core/reports/ExtendedReport;", "()V", "environmentVariables", "Lnet/thucydides/core/util/EnvironmentVariables;", "sourceDirectory", "Ljava/nio/file/Path;", "outputDirectory", "(Lnet/thucydides/core/util/EnvironmentVariables;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getEnvironmentVariables", "()Lnet/thucydides/core/util/EnvironmentVariables;", "generateReport", "getDescription", "", "getName", "mergeTemplate", "Lnet/thucydides/core/reports/html/Merger;", "templateFile", "newOutputFileIn", "Ljava/io/File;", "outputFileIn", "setOutputDirectory", "", "setSourceDirectory", "templateFields", "", "", "testOutcomes", "Lnet/thucydides/core/reports/TestOutcomes;", "writeJsonReportTo", "fields", "serenity-json-summary-report"})
public final class JsonSummaryReporter
implements ExtendedReport {
    @NotNull
    private final EnvironmentVariables environmentVariables;
    @NotNull
    private Path sourceDirectory;
    @NotNull
    private Path outputDirectory;

    public JsonSummaryReporter(@NotNull EnvironmentVariables environmentVariables, @NotNull Path sourceDirectory, @NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)environmentVariables, (String)"environmentVariables");
        Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        this.environmentVariables = environmentVariables;
        this.sourceDirectory = sourceDirectory;
        this.outputDirectory = outputDirectory;
    }

    public /* synthetic */ JsonSummaryReporter(EnvironmentVariables environmentVariables, Path path, Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = JsonSummaryReporterKt.sourceDirectoryDefinedIn(environmentVariables);
        }
        if ((n & 4) != 0) {
            path2 = JsonSummaryReporterKt.outputDirectoryDefinedIn(environmentVariables);
        }
        this(environmentVariables, path, path2);
    }

    @NotNull
    public final EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @NotNull
    public String getName() {
        return "json-summary";
    }

    @NotNull
    public String getDescription() {
        return "JSON Summary";
    }

    public void setSourceDirectory(@NotNull Path sourceDirectory) {
        Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
        this.sourceDirectory = sourceDirectory;
    }

    public void setOutputDirectory(@NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        this.outputDirectory = outputDirectory;
    }

    public JsonSummaryReporter() {
        Object object = Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInjector().getProvider<EnvironmentVariables>(EnvironmentVariables::class.java).get()");
        this((EnvironmentVariables)object, null, null, 6, null);
    }

    @NotNull
    public Path generateReport() {
        TestOutcomes testOutcomes = ReportIOKt.testOutcomesIn((Path)this.sourceDirectory).filteredByEnvironmentTags();
        Intrinsics.checkNotNullExpressionValue((Object)testOutcomes, (String)"testOutcomes");
        Map<String, Object> fields = this.templateFields(this.environmentVariables, testOutcomes);
        Path path = this.writeJsonReportTo(this.outputDirectory, fields).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"writeJsonReportTo(outputDirectory, fields).toPath()");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File writeJsonReportTo(Path outputDirectory, Map<String, ? extends Object> fields) {
        File outputFile = this.newOutputFileIn(outputDirectory);
        Object object = outputFile;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileOutputStream((File)object3);
        bl3 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl2 = false;
        BufferedWriter writer = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        object = writer;
        boolean bl4 = false;
        n = 0;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl5 = false;
            String template = (String)JsonSummaryReport.Companion.template().configuredIn(this.getEnvironmentVariables());
            this.mergeTemplate(template).withContext(fields).to((Writer)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return outputFile;
    }

    private final Merger mergeTemplate(String templateFile) {
        return new Merger(templateFile);
    }

    private final Map<String, Object> templateFields(EnvironmentVariables environmentVariables, TestOutcomes testOutcomes) {
        String reportTitle = (String)JsonSummaryReport.Companion.reportTitle().configuredIn(environmentVariables);
        String reportLink = (String)JsonSummaryReport.Companion.reportLink().configuredIn(environmentVariables);
        int scoreboardSize = ((Number)JsonSummaryReport.Companion.scoreboardSize().configuredIn(environmentVariables)).intValue();
        CustomReportFields customReportFields = new CustomReportFields(environmentVariables);
        List tagTypes = (List)JsonSummaryReport.Companion.tagTypes().configuredIn(environmentVariables);
        String tagCategoryTitle = (String)JsonSummaryReport.Companion.tagCategoryTitle().configuredIn(environmentVariables);
        boolean showFullTestResults = (Boolean)JsonSummaryReport.Companion.showFullTestResults().configuredIn(environmentVariables);
        Pair[] pairArray = new Pair[13];
        pairArray[0] = TuplesKt.to((Object)"testOutcomes", (Object)testOutcomes);
        pairArray[1] = TuplesKt.to((Object)"showFullTestResults", (Object)showFullTestResults);
        Object object = environmentVariables.getProperty("project.version", "");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"environmentVariables.getProperty(\"project.version\", \"\")");
        String string = object;
        object = testOutcomes.getStartTime().orElse(ZonedDateTime.now()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testOutcomes.startTime.orElse(ZonedDateTime.now()).toLocalDateTime()");
        pairArray[2] = TuplesKt.to((Object)"report", (Object)new ReportInfo(reportTitle, reportLink, tagCategoryTitle, string, (LocalDateTime)object));
        int n = testOutcomes.getTotal();
        Map map = ResultsCountKt.countByResultLabelFrom((TestOutcomes)testOutcomes);
        Map map2 = ResultsCountKt.percentageByResultLabelFrom((TestOutcomes)testOutcomes);
        String string2 = String.valueOf(testOutcomes.getDuration());
        object = testOutcomes.getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testOutcomes.outcomes");
        String string3 = String.valueOf(DurationsKt.clockDurationOf((List)object).toMillis());
        object = testOutcomes.getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testOutcomes.outcomes");
        String string4 = String.valueOf(DurationsKt.averageDurationOf((List)object).toMillis());
        object = testOutcomes.getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testOutcomes.outcomes");
        String string5 = String.valueOf(DurationsKt.maxDurationOf((List)object).toMillis());
        object = testOutcomes.getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testOutcomes.outcomes");
        pairArray[3] = TuplesKt.to((Object)"results", (Object)new TestResultSummary(n, map, map2, string2, string3, string4, string5, String.valueOf(DurationsKt.minDurationOf((List)object).toMillis())));
        pairArray[4] = TuplesKt.to((Object)"failuresByFeature", (Object)FailuresByFeature.Companion.from(testOutcomes));
        pairArray[5] = TuplesKt.to((Object)"resultsByFeature", (Object)TestResultsByFeature.Companion.from(testOutcomes));
        pairArray[6] = TuplesKt.to((Object)"frequentFailures", (Object)FrequentFailures.Companion.from(testOutcomes).withMaxOf(scoreboardSize));
        pairArray[7] = TuplesKt.to((Object)"unstableFeatures", (Object)UnstableFeatures.Companion.from(testOutcomes).withMaxOf(scoreboardSize));
        pairArray[8] = TuplesKt.to((Object)"coverage", (Object)TagCoverage.Companion.from(testOutcomes).forTagTypes(tagTypes));
        pairArray[9] = TuplesKt.to((Object)"customFields", (Object)customReportFields.getFieldNames());
        pairArray[10] = TuplesKt.to((Object)"customFieldValues", (Object)customReportFields.getValues());
        pairArray[11] = TuplesKt.to((Object)"formatted", (Object)new Formatted());
        pairArray[12] = TuplesKt.to((Object)"tagResults", (Object)TagResults.Companion.from(testOutcomes).groupedByType());
        HashMap fields = MapsKt.hashMapOf((Pair[])pairArray);
        return fields;
    }

    @NotNull
    public final File outputFileIn(@NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        File file = outputDirectory.resolve("serenity-summary.json").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDirectory.resolve(\"serenity-summary.json\").toFile()");
        return file;
    }

    @NotNull
    public final File newOutputFileIn(@NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        outputDirectory.toFile().mkdirs();
        File outputFile = this.outputFileIn(outputDirectory);
        outputFile.createNewFile();
        return outputFile;
    }
}

