/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.browserstack;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.OverrideDriverCapabilities;
import net.serenitybdd.core.webdriver.enhancers.BeforeAWebdriverScenario;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.SupportedWebDriver;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BeforeABrowserStackScenario
implements BeforeAWebdriverScenario {
    private static final String BROWSERSTACK = "browserstack.";
    private static final Map<String, String> LEGACY_TO_W3C = new HashMap<String, String>();
    private static final List<String> UNOVERRIDABLE_FIELDS = Arrays.asList("user", "key", "server");
    private static List<String> NON_BSTACK_PROPERTIES;

    public DesiredCapabilities apply(EnvironmentVariables environmentVariables, SupportedWebDriver driver, TestOutcome testOutcome, DesiredCapabilities capabilities) {
        if (driver != SupportedWebDriver.REMOTE) {
            return capabilities;
        }
        String remotePlatform = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"remote.platform"}).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)remotePlatform)) {
            capabilities.setPlatform(Platform.valueOf((String)remotePlatform));
        }
        Properties browserStackProperties = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getPropertiesWithPrefix(BROWSERSTACK);
        Properties browserStackPropertiesWithOverrides = this.caterForOverridesIn(browserStackProperties);
        OverrideDriverCapabilities.getProperties().forEach((key, value) -> browserStackPropertiesWithOverrides.setProperty((String)key, value.toString()));
        this.setNonW3CCapabilities(capabilities, browserStackPropertiesWithOverrides);
        Map<String, Object> browserstackOptions = this.w3CPropertyMapFrom(browserStackPropertiesWithOverrides);
        String testName = testOutcome.getStoryTitle() + " - " + testOutcome.getTitle();
        browserstackOptions.put("sessionName", testName);
        capabilities.setCapability("bstack:options", browserstackOptions);
        return capabilities;
    }

    private Properties caterForOverridesIn(Properties browserStackProperties) {
        Properties propertiesWithOverrides = new Properties();
        browserStackProperties.stringPropertyNames().stream().filter(this::shouldNotOveride).forEach(name -> propertiesWithOverrides.put(name, browserStackProperties.getProperty((String)name)));
        return propertiesWithOverrides;
    }

    private void setNonW3CCapabilities(DesiredCapabilities capabilities, Properties browserStackProperties) {
        browserStackProperties.stringPropertyNames().stream().filter(this::isNonW3CProperty).forEach(key -> capabilities.setCapability(this.w3cKey((String)key), browserStackProperties.getProperty((String)key)));
    }

    private boolean shouldNotOveride(String propertyName) {
        return !OverrideDriverCapabilities.shouldOverrideDefaults() || UNOVERRIDABLE_FIELDS.contains(propertyName) || UNOVERRIDABLE_FIELDS.contains(this.unprefixed(propertyName));
    }

    private Map<String, Object> w3CPropertyMapFrom(Properties properties) {
        HashMap<String, Object> w3cOptions = new HashMap<String, Object>();
        HashMap nestedOptions = new HashMap();
        properties.stringPropertyNames().stream().filter(this::isW3CProperty).forEach(key -> {
            String unprefixedKey = this.unprefixed((String)key);
            String w3cKey = LEGACY_TO_W3C.getOrDefault(unprefixedKey, unprefixedKey);
            if (w3cKey.contains(".")) {
                String parentKey = StringUtils.split((String)w3cKey, (String)".")[0];
                String childKey = StringUtils.split((String)w3cKey, (String)".")[1];
                Map nestedProperties = nestedOptions.getOrDefault(parentKey, new HashMap());
                nestedProperties.put(childKey, properties.getProperty((String)key));
                nestedOptions.put(parentKey, nestedProperties);
            } else {
                w3cOptions.put(w3cKey, properties.getProperty((String)key));
            }
        });
        w3cOptions.putAll(nestedOptions);
        return w3cOptions;
    }

    private boolean isNonW3CProperty(String key) {
        return NON_BSTACK_PROPERTIES.contains(this.w3cKey(this.unprefixed(key))) || NON_BSTACK_PROPERTIES.contains(this.w3cKey(key));
    }

    private boolean isW3CProperty(String key) {
        return !this.isNonW3CProperty(key);
    }

    private String w3cKey(String key) {
        return LEGACY_TO_W3C.getOrDefault(this.unprefixed(key), this.unprefixed(key));
    }

    private String unprefixed(String propertyName) {
        return propertyName.replace(BROWSERSTACK, "");
    }

    static {
        LEGACY_TO_W3C.put("os_version", "osVersion");
        LEGACY_TO_W3C.put("browser", "browserName");
        LEGACY_TO_W3C.put("browser_version", "browserVersion");
        LEGACY_TO_W3C.put("build", "buildName");
        LEGACY_TO_W3C.put("device", "deviceName");
        LEGACY_TO_W3C.put("appium_version", "appiumVersion");
        NON_BSTACK_PROPERTIES = Arrays.asList("browserName", "browserVersion", "server", "user", "key");
    }
}

