/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.browsermob.fixtureservices;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.client.ClientUtil;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.browsermob.fixtureservices.BrowserMobSystemProperties;
import net.thucydides.browsermob.fixtureservices.Ports;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureException;
import net.thucydides.core.fixtureservices.FixtureService;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;

public class BrowserMobFixtureService
implements FixtureService {
    public static final int DEFAULT_PORT = 5555;
    private static final int MIN_AVAILABLE_PORT = 49152;
    private final EnvironmentVariables environmentVariables;
    private Ports ports;
    private ThreadLocal<BrowserMobProxy> threadLocalproxyServer = new ThreadLocal();

    public BrowserMobFixtureService() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public BrowserMobFixtureService(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.ports = new Ports(this.defaultPortDefinedIn(environmentVariables));
    }

    public BrowserMobFixtureService(EnvironmentVariables environmentVariables, Ports ports) {
        this.environmentVariables = environmentVariables;
        this.ports = ports;
    }

    public void setup() throws FixtureException {
        if (this.useBrowserMobProxyManager()) {
            try {
                this.initializeProxy(this.getAvailablePort());
            }
            catch (Exception e) {
                throw new FixtureException("Failed to initialize proxy", (Throwable)e);
            }
        }
    }

    public BrowserMobProxy getProxyServer() {
        return this.getBrowserMobProxy();
    }

    private void initializeProxy(int port) throws Exception {
        boolean refuseUntrustedCertificates = ThucydidesSystemProperty.REFUSE_UNTRUSTED_CERTIFICATES.booleanFrom(this.environmentVariables, Boolean.valueOf(false));
        this.threadLocalproxyServer.set((BrowserMobProxy)new BrowserMobProxyServer());
        this.getBrowserMobProxy().setTrustAllServers(!refuseUntrustedCertificates);
        this.getBrowserMobProxy().start(port);
    }

    private BrowserMobProxy getBrowserMobProxy() {
        return this.threadLocalproxyServer.get();
    }

    public void shutdown() {
        if (this.getBrowserMobProxy() != null) {
            try {
                this.getBrowserMobProxy().stop();
            }
            catch (Exception e) {
                throw new FixtureException("Could not shut down BrowserMob proxy", (Throwable)e);
            }
            this.threadLocalproxyServer.remove();
        }
    }

    public void addCapabilitiesTo(MutableCapabilities capabilities) {
        if (!this.proxyServerRunning()) {
            this.setup();
        }
        Proxy seleniumProxy = ClientUtil.createSeleniumProxy((BrowserMobProxy)this.getBrowserMobProxy());
        capabilities.setCapability("proxy", (Object)seleniumProxy);
    }

    private boolean proxyServerRunning() {
        return this.getBrowserMobProxy() != null;
    }

    private boolean useBrowserMobProxyManager() {
        String browserMobFilter = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(new String[]{BrowserMobSystemProperties.BROWSER_MOB_FILTER.toString()}).orElse(null);
        return StringUtils.isEmpty((CharSequence)browserMobFilter) || this.shouldActivateBrowserMobWithDriver(browserMobFilter, this.environmentVariables);
    }

    private boolean shouldActivateBrowserMobWithDriver(String filter, EnvironmentVariables environmentVariables) {
        String currentDriver = WebDriverFactory.getDriverFrom((EnvironmentVariables)environmentVariables);
        List allowedBrowsers = Splitter.on((String)",").trimResults().splitToList((CharSequence)filter.toLowerCase());
        return StringUtils.isEmpty((CharSequence)currentDriver) || allowedBrowsers.contains(currentDriver.toLowerCase());
    }

    public int getPort() {
        return this.threadLocalproxyServer.get() != null ? this.threadLocalproxyServer.get().getPort() : 0;
    }

    protected int getAvailablePort() {
        int defaultPort = this.portDefinedIn(this.environmentVariables, BrowserMobSystemProperties.BROWSER_MOB_PROXY);
        if (this.ports.isAvailable(defaultPort)) {
            return defaultPort;
        }
        return this.ports.nextAvailablePort(49152);
    }

    private int defaultPortDefinedIn(EnvironmentVariables environmentVariables) {
        return this.portDefinedIn(environmentVariables, BrowserMobSystemProperties.BROWSER_MOB_PROXY);
    }

    private Integer portDefinedIn(EnvironmentVariables environmentVariables, BrowserMobSystemProperties propertyName) {
        Optional definedPort = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{propertyName.toString()});
        return definedPort.map(Integer::parseInt).orElse(5555);
    }
}

