/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.browsermob.fixtureservices;

import java.io.IOException;
import java.net.ServerSocket;

public class Ports {
    private static final int PORT_RANGE = 1000;
    private static final int MIN_AVAILABLE_PORT = 49152;
    private static final int MAX_AVAILABLE_PORT = 50152;
    private final int defaultPort;

    public Ports(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public int nextAvailablePort(int portNumber) {
        if (portNumber > 50152) {
            throw new IllegalStateException("No available ports found");
        }
        if (this.isAvailable(portNumber)) {
            return portNumber;
        }
        return this.nextAvailablePort(portNumber + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(int portNumber) {
        ServerSocket socket = null;
        boolean available = false;
        try {
            socket = new ServerSocket(portNumber);
            available = true;
        }
        catch (IOException e) {
            available = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return available;
    }
}

