/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class HeatChart {
    public static final double SCALE_LOGARITHMIC = 0.3;
    public static final double SCALE_LINEAR = 1.0;
    public static final double SCALE_EXPONENTIAL = 3.0;
    private double[][] zValues;
    private Object[] xValues;
    private Object[] yValues;
    private boolean xValuesHorizontal;
    private boolean yValuesHorizontal;
    private Dimension cellSize;
    private Dimension chartSize;
    private int margin;
    private Color backgroundColour;
    private String title;
    private Font titleFont;
    private Color titleColour;
    private Dimension titleSize;
    private int titleAscent;
    private int axisThickness;
    private Color axisColour;
    private Font axisLabelsFont;
    private Color axisLabelColour;
    private String xAxisLabel;
    private String yAxisLabel;
    private Color axisValuesColour;
    private Font axisValuesFont;
    private int xAxisValuesFrequency;
    private int yAxisValuesFrequency;
    private boolean showXAxisValues;
    private boolean showYAxisValues;
    private int xAxisValuesHeight;
    private int xAxisValuesWidthMax;
    private int yAxisValuesHeight;
    private int yAxisValuesAscent;
    private int yAxisValuesWidthMax;
    private Dimension xAxisLabelSize;
    private int xAxisLabelDescent;
    private Dimension yAxisLabelSize;
    private int yAxisLabelAscent;
    private Color highValueColour;
    private Color lowValueColour;
    private double lowValue;
    private double highValue;
    private Point heatMapTL;
    private Point heatMapBR;
    private Point heatMapC;
    private Dimension heatMapSize;
    private double colourScale;

    public HeatChart(double[][] zValues) {
        this(zValues, HeatChart.min(zValues), HeatChart.max(zValues));
    }

    public HeatChart(double[][] zValues, double low, double high) {
        this.zValues = zValues;
        this.lowValue = low;
        this.highValue = high;
        this.setXValues(0.0, 1.0);
        this.setYValues(0.0, 1.0);
        this.cellSize = new Dimension(20, 20);
        this.margin = 10;
        this.backgroundColour = Color.WHITE;
        this.title = null;
        this.titleFont = new Font("Sans-Serif", 1, 12);
        this.titleColour = Color.BLACK;
        this.xAxisLabel = null;
        this.yAxisLabel = null;
        this.axisThickness = 2;
        this.axisColour = Color.BLACK;
        this.axisLabelsFont = new Font("Sans-Serif", 0, 10);
        this.axisLabelColour = Color.BLACK;
        this.axisValuesColour = Color.BLACK;
        this.axisValuesFont = new Font("Sans-Serif", 0, 8);
        this.xAxisValuesFrequency = 1;
        this.xAxisValuesHeight = 0;
        this.xValuesHorizontal = false;
        this.showXAxisValues = false;
        this.showYAxisValues = false;
        this.yAxisValuesFrequency = 1;
        this.yAxisValuesHeight = 0;
        this.yValuesHorizontal = true;
        this.highValueColour = Color.BLACK;
        this.lowValueColour = Color.WHITE;
        this.colourScale = 1.0;
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public double getHighValue() {
        return this.highValue;
    }

    public double[][] getZValues() {
        return this.zValues;
    }

    public void setZValues(double[][] zValues) {
        this.setZValues(zValues, HeatChart.min(zValues), HeatChart.max(zValues));
    }

    public void setZValues(double[][] zValues, double low, double high) {
        this.zValues = zValues;
        this.lowValue = low;
        this.highValue = high;
    }

    public void setXValues(double xOffset, double xInterval) {
        this.xValues = new Object[this.zValues[0].length];
        for (int i = 0; i < this.zValues[0].length; ++i) {
            this.xValues[i] = xOffset + (double)i * xInterval;
        }
    }

    public void setXValues(Object[] xValues) {
        this.xValues = xValues;
    }

    public void setYValues(double yOffset, double yInterval) {
        this.yValues = new Object[this.zValues.length];
        for (int i = 0; i < this.zValues.length; ++i) {
            this.yValues[i] = yOffset + (double)i * yInterval;
        }
    }

    public void setYValues(Object[] yValues) {
        this.yValues = yValues;
    }

    public Object[] getXValues() {
        return this.xValues;
    }

    public Object[] getYValues() {
        return this.yValues;
    }

    public void setXValuesHorizontal(boolean xValuesHorizontal) {
        this.xValuesHorizontal = xValuesHorizontal;
    }

    public boolean isXValuesHorizontal() {
        return this.xValuesHorizontal;
    }

    public void setYValuesHorizontal(boolean yValuesHorizontal) {
        this.yValuesHorizontal = yValuesHorizontal;
    }

    public boolean isYValuesHorizontal() {
        return this.yValuesHorizontal;
    }

    @Deprecated
    public void setCellWidth(int cellWidth) {
        this.setCellSize(new Dimension(cellWidth, this.cellSize.height));
    }

    @Deprecated
    public int getCellWidth() {
        return this.cellSize.width;
    }

    @Deprecated
    public void setCellHeight(int cellHeight) {
        this.setCellSize(new Dimension(this.cellSize.width, cellHeight));
    }

    @Deprecated
    public int getCellHeight() {
        return this.cellSize.height;
    }

    public void setCellSize(Dimension cellSize) {
        this.cellSize = cellSize;
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    @Deprecated
    public int getChartWidth() {
        return this.chartSize.width;
    }

    @Deprecated
    public int getChartHeight() {
        return this.chartSize.height;
    }

    public Dimension getChartSize() {
        return this.chartSize;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public int getChartMargin() {
        return this.margin;
    }

    public void setChartMargin(int margin) {
        this.margin = margin;
    }

    public Color getBackgroundColour() {
        return this.backgroundColour;
    }

    public void setBackgroundColour(Color backgroundColour) {
        if (backgroundColour == null) {
            backgroundColour = Color.WHITE;
        }
        this.backgroundColour = backgroundColour;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public Color getTitleColour() {
        return this.titleColour;
    }

    public void setTitleColour(Color titleColour) {
        this.titleColour = titleColour;
    }

    public int getAxisThickness() {
        return this.axisThickness;
    }

    public void setAxisThickness(int axisThickness) {
        this.axisThickness = axisThickness;
    }

    public Color getAxisColour() {
        return this.axisColour;
    }

    public void setAxisColour(Color axisColour) {
        this.axisColour = axisColour;
    }

    public Font getAxisLabelsFont() {
        return this.axisLabelsFont;
    }

    public void setAxisLabelsFont(Font axisLabelsFont) {
        this.axisLabelsFont = axisLabelsFont;
    }

    public Color getAxisLabelColour() {
        return this.axisLabelColour;
    }

    public void setAxisLabelColour(Color axisLabelColour) {
        this.axisLabelColour = axisLabelColour;
    }

    public Font getAxisValuesFont() {
        return this.axisValuesFont;
    }

    public void setAxisValuesFont(Font axisValuesFont) {
        this.axisValuesFont = axisValuesFont;
    }

    public Color getAxisValuesColour() {
        return this.axisValuesColour;
    }

    public void setAxisValuesColour(Color axisValuesColour) {
        this.axisValuesColour = axisValuesColour;
    }

    public int getXAxisValuesFrequency() {
        return this.xAxisValuesFrequency;
    }

    public void setXAxisValuesFrequency(int axisValuesFrequency) {
        this.xAxisValuesFrequency = axisValuesFrequency;
    }

    public int getYAxisValuesFrequency() {
        return this.yAxisValuesFrequency;
    }

    public void setYAxisValuesFrequency(int axisValuesFrequency) {
        this.yAxisValuesFrequency = axisValuesFrequency;
    }

    public boolean isShowXAxisValues() {
        return this.showXAxisValues;
    }

    public void setShowXAxisValues(boolean showXAxisValues) {
        this.showXAxisValues = showXAxisValues;
    }

    public boolean isShowYAxisValues() {
        return this.showYAxisValues;
    }

    public void setShowYAxisValues(boolean showYAxisValues) {
        this.showYAxisValues = showYAxisValues;
    }

    public Color getHighValueColour() {
        return this.highValueColour;
    }

    public void setHighValueColour(Color highValueColour) {
        this.highValueColour = highValueColour;
    }

    public Color getLowValueColour() {
        return this.lowValueColour;
    }

    public void setLowValueColour(Color lowValueColour) {
        this.lowValueColour = lowValueColour;
    }

    public double getColourScale() {
        return this.colourScale;
    }

    public void setColourScale(double colourScale) {
        this.colourScale = colourScale;
    }

    public void saveToFile(File outputFile) throws IOException {
        String filename = outputFile.getName();
        int extPoint = filename.lastIndexOf(46);
        if (extPoint < 0) {
            throw new IOException("Illegal filename, no extension used.");
        }
        String ext = filename.substring(extPoint + 1);
        if (ext.toLowerCase().equals("jpg") || ext.toLowerCase().equals("jpeg")) {
            BufferedImage chart = (BufferedImage)this.getChartImage(false);
            this.saveGraphicJpeg(chart, outputFile, 1.0f);
        } else {
            BufferedImage chart = (BufferedImage)this.getChartImage(true);
            ImageIO.write((RenderedImage)chart, ext, outputFile);
        }
    }

    private void saveGraphicJpeg(BufferedImage chart, File outputFile, float quality) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(quality);
        FileImageOutputStream output = new FileImageOutputStream(outputFile);
        writer.setOutput(output);
        IIOImage image = new IIOImage(chart, null, null);
        writer.write(null, image, iwp);
        writer.dispose();
    }

    public Image getChartImage(boolean alpha) {
        this.measureComponents();
        this.updateCoordinates();
        int imageType = alpha ? 6 : 5;
        BufferedImage chartImage = new BufferedImage(this.chartSize.width, this.chartSize.height, imageType);
        Graphics2D chartGraphics = chartImage.createGraphics();
        chartGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        chartGraphics.setColor(this.backgroundColour);
        chartGraphics.fillRect(0, 0, this.chartSize.width, this.chartSize.height);
        this.drawTitle(chartGraphics);
        this.drawHeatMap(chartGraphics, this.zValues);
        this.drawXLabel(chartGraphics);
        this.drawYLabel(chartGraphics);
        this.drawAxisBars(chartGraphics);
        this.drawXValues(chartGraphics);
        this.drawYValues(chartGraphics);
        return chartImage;
    }

    public Image getChartImage() {
        return this.getChartImage(false);
    }

    private void measureComponents() {
        int w;
        FontMetrics metrics;
        BufferedImage chartImage = new BufferedImage(1, 1, 2);
        Graphics2D tempGraphics = chartImage.createGraphics();
        if (this.title != null) {
            tempGraphics.setFont(this.titleFont);
            metrics = tempGraphics.getFontMetrics();
            this.titleSize = new Dimension(metrics.stringWidth(this.title), metrics.getHeight());
            this.titleAscent = metrics.getAscent();
        } else {
            this.titleSize = new Dimension(0, 0);
        }
        if (this.xAxisLabel != null) {
            tempGraphics.setFont(this.axisLabelsFont);
            metrics = tempGraphics.getFontMetrics();
            this.xAxisLabelSize = new Dimension(metrics.stringWidth(this.xAxisLabel), metrics.getHeight());
            this.xAxisLabelDescent = metrics.getDescent();
        } else {
            this.xAxisLabelSize = new Dimension(0, 0);
        }
        if (this.yAxisLabel != null) {
            tempGraphics.setFont(this.axisLabelsFont);
            metrics = tempGraphics.getFontMetrics();
            this.yAxisLabelSize = new Dimension(metrics.stringWidth(this.yAxisLabel), metrics.getHeight());
            this.yAxisLabelAscent = metrics.getAscent();
        } else {
            this.yAxisLabelSize = new Dimension(0, 0);
        }
        if (this.showXAxisValues) {
            tempGraphics.setFont(this.axisValuesFont);
            metrics = tempGraphics.getFontMetrics();
            this.xAxisValuesHeight = metrics.getHeight();
            this.xAxisValuesWidthMax = 0;
            for (Object o : this.xValues) {
                w = metrics.stringWidth(o.toString());
                if (w <= this.xAxisValuesWidthMax) continue;
                this.xAxisValuesWidthMax = w;
            }
        } else {
            this.xAxisValuesHeight = 0;
        }
        if (this.showYAxisValues) {
            tempGraphics.setFont(this.axisValuesFont);
            metrics = tempGraphics.getFontMetrics();
            this.yAxisValuesHeight = metrics.getHeight();
            this.yAxisValuesAscent = metrics.getAscent();
            this.yAxisValuesWidthMax = 0;
            for (Object o : this.yValues) {
                w = metrics.stringWidth(o.toString());
                if (w <= this.yAxisValuesWidthMax) continue;
                this.yAxisValuesWidthMax = w;
            }
        } else {
            this.yAxisValuesHeight = 0;
        }
        int heatMapWidth = this.zValues[0].length * this.cellSize.width;
        int heatMapHeight = this.zValues.length * this.cellSize.height;
        this.heatMapSize = new Dimension(heatMapWidth, heatMapHeight);
        int yValuesHorizontalSize = 0;
        yValuesHorizontalSize = this.yValuesHorizontal ? this.yAxisValuesWidthMax : this.yAxisValuesHeight;
        int xValuesVerticalSize = 0;
        xValuesVerticalSize = this.xValuesHorizontal ? this.xAxisValuesHeight : this.xAxisValuesWidthMax;
        int chartWidth = heatMapWidth + 2 * this.margin + this.yAxisLabelSize.height + yValuesHorizontalSize + this.axisThickness;
        int chartHeight = heatMapHeight + 2 * this.margin + this.xAxisLabelSize.height + xValuesVerticalSize + this.titleSize.height + this.axisThickness;
        this.chartSize = new Dimension(chartWidth, chartHeight);
    }

    private void updateCoordinates() {
        int x = this.margin + this.axisThickness + this.yAxisLabelSize.height;
        int n = this.yValuesHorizontal ? this.yAxisValuesWidthMax : this.yAxisValuesHeight;
        int y = this.titleSize.height + this.margin;
        this.heatMapTL = new Point(x += n, y);
        x = this.heatMapTL.x + this.heatMapSize.width;
        y = this.heatMapTL.y + this.heatMapSize.height;
        this.heatMapBR = new Point(x, y);
        x = this.heatMapTL.x + this.heatMapSize.width / 2;
        y = this.heatMapTL.y + this.heatMapSize.height / 2;
        this.heatMapC = new Point(x, y);
    }

    private void drawTitle(Graphics2D chartGraphics) {
        if (this.title != null) {
            int yTitle = this.margin / 2 + this.titleAscent;
            int xTitle = this.chartSize.width / 2 - this.titleSize.width / 2;
            chartGraphics.setFont(this.titleFont);
            chartGraphics.setColor(this.titleColour);
            chartGraphics.drawString(this.title, xTitle, yTitle);
        }
    }

    private void drawHeatMap(Graphics2D chartGraphics, double[][] data) {
        int noYCells = data.length;
        int noXCells = data[0].length;
        BufferedImage heatMapImage = new BufferedImage(this.heatMapSize.width, this.heatMapSize.height, 2);
        Graphics2D heatMapGraphics = heatMapImage.createGraphics();
        for (int x = 0; x < noXCells; ++x) {
            for (int y = 0; y < noYCells; ++y) {
                heatMapGraphics.setColor(this.getCellColour(data[y][x], this.lowValue, this.highValue));
                int cellX = x * this.cellSize.width;
                int cellY = y * this.cellSize.height;
                heatMapGraphics.fillRect(cellX, cellY, this.cellSize.width, this.cellSize.height);
            }
        }
        chartGraphics.drawImage(heatMapImage, this.heatMapTL.x, this.heatMapTL.y, this.heatMapSize.width, this.heatMapSize.height, null);
    }

    private void drawXLabel(Graphics2D chartGraphics) {
        if (this.xAxisLabel != null) {
            int yPosXAxisLabel = this.chartSize.height - this.margin / 2 - this.xAxisLabelDescent;
            int xPosXAxisLabel = this.heatMapC.x - this.xAxisLabelSize.width / 2;
            chartGraphics.setFont(this.axisLabelsFont);
            chartGraphics.setColor(this.axisLabelColour);
            chartGraphics.drawString(this.xAxisLabel, xPosXAxisLabel, yPosXAxisLabel);
        }
    }

    private void drawYLabel(Graphics2D chartGraphics) {
        if (this.yAxisLabel != null) {
            int yPosYAxisLabel = this.heatMapC.y + this.yAxisLabelSize.width / 2;
            int xPosYAxisLabel = this.margin / 2 + this.yAxisLabelAscent;
            chartGraphics.setFont(this.axisLabelsFont);
            chartGraphics.setColor(this.axisLabelColour);
            AffineTransform transform = chartGraphics.getTransform();
            AffineTransform originalTransform = (AffineTransform)transform.clone();
            transform.rotate(Math.toRadians(270.0), xPosYAxisLabel, yPosYAxisLabel);
            chartGraphics.setTransform(transform);
            chartGraphics.drawString(this.yAxisLabel, xPosYAxisLabel, yPosYAxisLabel);
            chartGraphics.setTransform(originalTransform);
        }
    }

    private void drawAxisBars(Graphics2D chartGraphics) {
        if (this.axisThickness > 0) {
            chartGraphics.setColor(this.axisColour);
            int x = this.heatMapTL.x - this.axisThickness;
            int y = this.heatMapBR.y;
            int width = this.heatMapSize.width + this.axisThickness;
            int height = this.axisThickness;
            chartGraphics.fillRect(x, y, width, height);
            x = this.heatMapTL.x - this.axisThickness;
            y = this.heatMapTL.y;
            width = this.axisThickness;
            height = this.heatMapSize.height;
            chartGraphics.fillRect(x, y, width, height);
        }
    }

    private void drawXValues(Graphics2D chartGraphics) {
        if (!this.showXAxisValues) {
            return;
        }
        chartGraphics.setColor(this.axisValuesColour);
        for (int i = 0; i < this.xValues.length; ++i) {
            int valueYPos;
            int valueXPos;
            if (i % this.xAxisValuesFrequency != 0) continue;
            String xValueStr = this.xValues[i].toString();
            chartGraphics.setFont(this.axisValuesFont);
            FontMetrics metrics = chartGraphics.getFontMetrics();
            int valueWidth = metrics.stringWidth(xValueStr);
            if (this.xValuesHorizontal) {
                valueXPos = i * this.cellSize.width + (this.cellSize.width / 2 - valueWidth / 2);
                valueYPos = this.heatMapBR.y + metrics.getAscent() + 1;
                chartGraphics.drawString(xValueStr, valueXPos += this.heatMapTL.x, valueYPos);
                continue;
            }
            valueXPos = this.heatMapTL.x + i * this.cellSize.width + (this.cellSize.width / 2 + this.xAxisValuesHeight / 2);
            valueYPos = this.heatMapBR.y + this.axisThickness + valueWidth;
            AffineTransform transform = chartGraphics.getTransform();
            AffineTransform originalTransform = (AffineTransform)transform.clone();
            transform.rotate(Math.toRadians(270.0), valueXPos, valueYPos);
            chartGraphics.setTransform(transform);
            chartGraphics.drawString(xValueStr, valueXPos, valueYPos);
            chartGraphics.setTransform(originalTransform);
        }
    }

    private void drawYValues(Graphics2D chartGraphics) {
        if (!this.showYAxisValues) {
            return;
        }
        chartGraphics.setColor(this.axisValuesColour);
        for (int i = 0; i < this.yValues.length; ++i) {
            int valueYPos;
            int valueXPos;
            if (i % this.yAxisValuesFrequency != 0) continue;
            String yValueStr = this.yValues[i].toString();
            chartGraphics.setFont(this.axisValuesFont);
            FontMetrics metrics = chartGraphics.getFontMetrics();
            int valueWidth = metrics.stringWidth(yValueStr);
            if (this.yValuesHorizontal) {
                valueXPos = this.margin + this.yAxisLabelSize.height + (this.yAxisValuesWidthMax - valueWidth);
                valueYPos = this.heatMapTL.y + i * this.cellSize.height + this.cellSize.height / 2 + this.yAxisValuesAscent / 2;
                chartGraphics.drawString(yValueStr, valueXPos, valueYPos);
                continue;
            }
            valueXPos = this.margin + this.yAxisLabelSize.height + this.yAxisValuesAscent;
            valueYPos = this.heatMapTL.y + i * this.cellSize.height + this.cellSize.height / 2 + valueWidth / 2;
            AffineTransform transform = chartGraphics.getTransform();
            AffineTransform originalTransform = (AffineTransform)transform.clone();
            transform.rotate(Math.toRadians(270.0), valueXPos, valueYPos);
            chartGraphics.setTransform(transform);
            chartGraphics.drawString(yValueStr, valueXPos, valueYPos);
            chartGraphics.setTransform(originalTransform);
        }
    }

    private Color getCellColour(double data, double min, double max) {
        double range = max - min;
        double position = data - min;
        double percentPosition = position / range;
        int r = (int)(255.0 * this.red(percentPosition * 2.0 - 1.0));
        int g = (int)(255.0 * this.green(percentPosition * 2.0 - 1.0));
        int b = (int)(255.0 * this.blue(percentPosition * 2.0 - 1.0));
        return new Color(r, g, b);
    }

    public static double max(double[][] values) {
        double max = 0.0;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                max = values[i][j] > max ? values[i][j] : max;
            }
        }
        return max;
    }

    public static double min(double[][] values) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                min = values[i][j] < min ? values[i][j] : min;
            }
        }
        return min;
    }

    double interpolate(double val, double y0, double x0, double y1, double x1) {
        return (val - x0) * (y1 - y0) / (x1 - x0) + y0;
    }

    double base(double val) {
        if (val <= -0.75) {
            return 0.0;
        }
        if (val <= -0.25) {
            return this.interpolate(val, 0.0, -0.75, 1.0, -0.25);
        }
        if (val <= 0.25) {
            return 1.0;
        }
        if (val <= 0.75) {
            return this.interpolate(val, 1.0, 0.25, 0.0, 0.75);
        }
        return 0.0;
    }

    double red(double gray) {
        return this.base(gray - 0.5);
    }

    double green(double gray) {
        return this.base(gray);
    }

    double blue(double gray) {
        return this.base(gray + 0.5);
    }
}

