/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.tinker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import net.seninp.jmotif.distance.EuclideanDistance;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.util.HeatChart;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoviePrinter {
    private static final DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.US);
    private static DecimalFormat df = new DecimalFormat("0.00000", otherSymbols);
    private static EuclideanDistance ed = new EuclideanDistance();
    private static final String DAT_FNAME = "src/resources/dataset/depth/0890031.dat";
    private static final int SAX_WINDOW_SIZE = 10;
    private static int cPoint = 10;
    private static final int SAX_PAA_SIZE = 10;
    private static final int SAX_ALPHABET_SIZE = 4;
    private static final double SAX_NORM_THRESHOLD = 0.001;
    private static final NumerosityReductionStrategy SAX_NR_STRATEGY = NumerosityReductionStrategy.NONE;
    private static final int SHINGLE_SIZE = 3;
    private static Logger LOGGER = LoggerFactory.getLogger(MoviePrinter.class);

    public static void main(String[] args) throws Exception {
        SAXProcessor sp = new SAXProcessor();
        double[] dat = TSProcessor.readFileColumn(DAT_FNAME, 1, 0);
        LOGGER.info("read {} points from {}", (Object)dat.length, (Object)DAT_FNAME);
        String str = "win_width: " + cPoint + "; SAX: W " + 10 + ", P " + 10 + ", A " + 4 + ", STR " + SAX_NR_STRATEGY.toString();
        int frameCounter = 0;
        int startOffset = cPoint;
        while (cPoint < dat.length - startOffset - 1) {
            if (0 == cPoint % 2) {
                BufferedImage tsChart = MoviePrinter.getChart(dat, cPoint);
                double[] win1 = Arrays.copyOfRange(dat, cPoint - startOffset, cPoint);
                Map<String, Integer> shingledData1 = sp.ts2Shingles(win1, 10, 10, 4, SAX_NR_STRATEGY, 0.001, 3);
                BufferedImage pam1 = MoviePrinter.getHeatMap(shingledData1, "pre-window");
                double[] win2 = Arrays.copyOfRange(dat, cPoint, cPoint + startOffset);
                Map<String, Integer> shingledData2 = sp.ts2Shingles(win2, 10, 10, 4, SAX_NR_STRATEGY, 0.001, 3);
                BufferedImage pam2 = MoviePrinter.getHeatMap(shingledData2, "post-window");
                BufferedImage target = new BufferedImage(800, 530, 2);
                Graphics targetGraphics = target.getGraphics();
                targetGraphics.setColor(Color.WHITE);
                targetGraphics.fillRect(0, 0, 799, 529);
                targetGraphics.drawImage(tsChart, 0, 0, null);
                targetGraphics.drawImage(pam1, 10, 410, null);
                targetGraphics.drawImage(pam2, 120, 410, null);
                targetGraphics.setColor(Color.RED);
                targetGraphics.setFont(new Font("monospaced", 0, 16));
                targetGraphics.drawString(str, 300, 420);
                targetGraphics.setColor(Color.BLUE);
                targetGraphics.setFont(new Font("monospaced", 0, 24));
                double dist = ed.distance(MoviePrinter.toVector(shingledData1), MoviePrinter.toVector(shingledData2));
                targetGraphics.drawString("ED=" + df.format(dist), 300, 480);
                File outputfile = new File("dframe" + String.format("%04d", frameCounter) + ".png");
                ImageIO.write((RenderedImage)target, "png", outputfile);
                ++frameCounter;
            }
            ++cPoint;
        }
    }

    private static double[] toVector(Map<String, Integer> shingledData1) {
        TreeSet<String> keys = new TreeSet<String>(shingledData1.keySet());
        double[] res = new double[shingledData1.size()];
        int counter = 0;
        for (String shingle : keys) {
            Integer value = shingledData1.get(shingle);
            res[counter] = value.intValue();
            ++counter;
        }
        return res;
    }

    private static BufferedImage getHeatMap(Map<String, Integer> shingledData1, String title) {
        TreeSet<String> keys = new TreeSet<String>(shingledData1.keySet());
        double[][] heatmapData = new double[8][8];
        int counter = 0;
        for (String shingle : keys) {
            Integer value = shingledData1.get(shingle);
            heatmapData[counter / 8][counter % 8] = value.intValue();
            ++counter;
        }
        HeatChart chart = new HeatChart(heatmapData);
        chart.setAxisThickness(0);
        chart.setTitle(title);
        chart.setCellSize(new Dimension(10, 10));
        return (BufferedImage)chart.getChartImage();
    }

    private static BufferedImage getChart(double[] tsData, double redDot) {
        try {
            XYSeries dataset = new XYSeries((Comparable)((Object)"Series"));
            for (int i = 0; i < tsData.length; ++i) {
                dataset.add((double)i, (double)((float)tsData[i]));
            }
            XYSeriesCollection chartXYSeriesCollection = new XYSeriesCollection(dataset);
            XYSeries dot = new XYSeries((Comparable)((Object)"Dot"));
            dot.add((double)((float)redDot), 0.0);
            chartXYSeriesCollection.addSeries(dot);
            XYLineAndShapeRenderer xyRenderer = new XYLineAndShapeRenderer(true, false);
            xyRenderer.setBaseStroke((Stroke)new BasicStroke(3.0f));
            xyRenderer.setSeriesPaint(0, (Paint)new Color(0, 0, 0));
            xyRenderer.setSeriesLinesVisible(0, true);
            xyRenderer.setSeriesShapesVisible(0, false);
            xyRenderer.setSeriesPaint(1, (Paint)Color.RED);
            xyRenderer.setSeriesLinesVisible(1, false);
            xyRenderer.setSeriesShapesVisible(1, true);
            NumberAxis timeAxis = new NumberAxis();
            timeAxis.setLabel("Time");
            NumberAxis valueAxis = new NumberAxis("Values");
            valueAxis.setAutoRangeIncludesZero(false);
            valueAxis.setLabel("Values");
            XYPlot timeseriesPlot = new XYPlot((XYDataset)chartXYSeriesCollection, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)xyRenderer);
            JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)timeseriesPlot, false);
            BufferedImage objBufferedImage = chart.createBufferedImage(800, 400);
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)objBufferedImage, "png", bas);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] byteArray = bas.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(byteArray);
            BufferedImage image = ImageIO.read(in);
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

