/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class VisitRegistry
implements Cloneable {
    private static final byte ZERO = 0;
    private static final byte ONE = 1;
    protected byte[] registry;
    private int unvisitedCount;
    private final Random randomizer = new Random(System.currentTimeMillis());

    public VisitRegistry(int capacity) {
        this.registry = new byte[capacity];
        this.unvisitedCount = capacity;
    }

    private VisitRegistry() {
    }

    public void markVisited(int loc) {
        if (this.checkBounds(loc)) {
            if (0 == this.registry[loc]) {
                --this.unvisitedCount;
            }
        } else {
            throw new RuntimeException("The location " + loc + " out of bounds [0," + (this.registry.length - 1) + "]");
        }
        this.registry[loc] = 1;
    }

    public void markVisited(int from, int upTo) {
        if (this.checkBounds(from) && this.checkBounds(upTo - 1)) {
            for (int i = from; i < upTo; ++i) {
                this.markVisited(i);
            }
        } else {
            throw new RuntimeException("The location " + from + "," + upTo + " out of bounds [0," + (this.registry.length - 1) + "]");
        }
    }

    public int getNextRandomUnvisitedPosition() {
        if (0 == this.unvisitedCount) {
            return -1;
        }
        int i = this.randomizer.nextInt(this.registry.length);
        while (1 == this.registry[i]) {
            i = this.randomizer.nextInt(this.registry.length);
        }
        return i;
    }

    public boolean isNotVisited(int loc) {
        if (this.checkBounds(loc)) {
            return 0 == this.registry[loc];
        }
        throw new RuntimeException("The location " + loc + " out of bounds [0," + (this.registry.length - 1) + "]");
    }

    public boolean isVisited(int from, int upTo) {
        if (this.checkBounds(from) && this.checkBounds(upTo - 1)) {
            for (int i = from; i < upTo; ++i) {
                if (1 != this.registry[i]) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("The location " + from + "," + upTo + " out of bounds [0," + (this.registry.length - 1) + "]");
    }

    public boolean isVisited(int loc) {
        if (this.checkBounds(loc)) {
            return 1 == this.registry[loc];
        }
        throw new RuntimeException("The location " + loc + " out of bounds [0," + (this.registry.length - 1) + "]");
    }

    public ArrayList<Integer> getUnvisited() {
        if (0 == this.unvisitedCount) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> res = new ArrayList<Integer>(this.unvisitedCount);
        for (int i = 0; i < this.registry.length; ++i) {
            if (0 != this.registry[i]) continue;
            res.add(i);
        }
        return res;
    }

    public ArrayList<Integer> getVisited() {
        if (0 == this.registry.length - this.unvisitedCount) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> res = new ArrayList<Integer>(this.registry.length - this.unvisitedCount);
        for (int i = 0; i < this.registry.length; ++i) {
            if (1 != this.registry[i]) continue;
            res.add(i);
        }
        return res;
    }

    public void transferVisited(VisitRegistry discordRegistry) {
        for (int v : discordRegistry.getVisited()) {
            this.markVisited(v);
        }
    }

    public VisitRegistry clone() throws CloneNotSupportedException {
        VisitRegistry res = (VisitRegistry)super.clone();
        res.unvisitedCount = this.unvisitedCount;
        res.registry = Arrays.copyOfRange(this.registry, 0, this.registry.length);
        return res;
    }

    public int size() {
        return this.registry.length;
    }

    private boolean checkBounds(int pos) {
        return pos >= 0 && pos < this.registry.length;
    }

    public int getUnvisitedCount() {
        return this.unvisitedCount;
    }
}

