/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.discord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.seninp.jmotif.distance.EuclideanDistance;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.datastructure.FrequencyTableEntry;
import net.seninp.jmotif.sax.datastructure.SAXRecord;
import net.seninp.jmotif.sax.datastructure.SAXRecords;
import net.seninp.jmotif.sax.discord.DiscordRecord;
import net.seninp.jmotif.sax.discord.DiscordRecords;
import net.seninp.jmotif.sax.registry.MagicArrayEntry;
import net.seninp.jmotif.sax.registry.SlidingWindowMarkerAlgorithm;
import net.seninp.jmotif.sax.registry.VisitRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HOTSAXImplementation {
    private static TSProcessor tp = new TSProcessor();
    private static SAXProcessor sp = new SAXProcessor();
    private static EuclideanDistance ed = new EuclideanDistance();
    private static final Logger LOGGER = LoggerFactory.getLogger(HOTSAXImplementation.class);

    public static DiscordRecords series2Discords(double[] series, int discordsNumToReport, int windowSize, int paaSize, int alphabetSize, NumerosityReductionStrategy strategy, double nThreshold) throws Exception {
        Date start = new Date();
        NormalAlphabet normalA = new NormalAlphabet();
        SAXRecords sax = sp.ts2saxViaWindow(series, windowSize, alphabetSize, normalA.getCuts(alphabetSize), strategy, nThreshold);
        Date saxEnd = new Date();
        LOGGER.debug("discretized in {}, words: {}, indexes: {}", new Object[]{SAXProcessor.timeToString(start.getTime(), saxEnd.getTime()), sax.getRecords().size(), sax.getIndexes().size()});
        ArrayList<MagicArrayEntry> magicArray = new ArrayList<MagicArrayEntry>(sax.getRecords().size());
        for (SAXRecord sr : sax.getRecords()) {
            magicArray.add(new MagicArrayEntry(String.valueOf(sr.getPayload()), sr.getIndexes().size()));
        }
        Date hashEnd = new Date();
        LOGGER.debug("Magic array filled in : {}", (Object)SAXProcessor.timeToString(saxEnd.getTime(), hashEnd.getTime()));
        DiscordRecords discords = HOTSAXImplementation.getDiscordsWithMagic(series, sax, windowSize, magicArray, discordsNumToReport);
        Date end = new Date();
        LOGGER.debug("{} discords found in {}", (Object)discords.getSize(), (Object)SAXProcessor.timeToString(start.getTime(), end.getTime()));
        return discords;
    }

    private static DiscordRecords getDiscordsWithMagic(double[] series, SAXRecords sax, int windowSize, ArrayList<MagicArrayEntry> magicArray, int discordCollectionSize) throws Exception {
        Collections.sort(magicArray);
        DiscordRecords discords = new DiscordRecords();
        HashSet<Integer> visitRegistry = new HashSet<Integer>(windowSize * discordCollectionSize);
        while (discords.getSize() < discordCollectionSize) {
            LOGGER.trace("currently known discords: {} out of {}", (Object)discords.getSize(), (Object)discordCollectionSize);
            Date start = new Date();
            DiscordRecord bestDiscord = HOTSAXImplementation.findBestDiscordWithMagic(series, windowSize, sax, magicArray, visitRegistry);
            Date end = new Date();
            if (bestDiscord.getNNDistance() == 0.0 || bestDiscord.getPosition() == -1) {
                LOGGER.trace("breaking the outer search loop, discords found: {} last seen discord: {}", (Object)discords.getSize(), (Object)bestDiscord);
                break;
            }
            bestDiscord.setInfo("position " + bestDiscord.getPosition() + ", NN distance " + bestDiscord.getNNDistance() + ", elapsed time: " + SAXProcessor.timeToString(start.getTime(), end.getTime()) + ", " + bestDiscord.getInfo());
            LOGGER.debug("{}", (Object)bestDiscord.getInfo());
            discords.add(bestDiscord);
            int markStart = bestDiscord.getPosition() - windowSize;
            int markEnd = bestDiscord.getPosition() + windowSize;
            LOGGER.debug("marking as globally visited [{}, {}]", (Object)markStart, (Object)markEnd);
            for (int i = markStart; i < markEnd; ++i) {
                visitRegistry.add(i);
            }
        }
        return discords;
    }

    private static DiscordRecord findBestDiscordWithMagic(double[] series, int windowSize, SAXRecords sax, ArrayList<MagicArrayEntry> allWords, HashSet<Integer> discordRegistry) throws Exception {
        int[] visitArray = new int[series.length];
        int bestSoFarPosition = -1;
        double bestSoFarDistance = 0.0;
        String bestSoFarWord = "";
        int iterationCounter = 0;
        int distanceCalls = 0;
        LOGGER.debug("iterating over {} entries", (Object)allWords.size());
        for (MagicArrayEntry currentEntry : allWords) {
            String currentWord = currentEntry.getStr();
            Set<Integer> occurrences = sax.getByWord(currentWord).getIndexes();
            for (int currentPos : occurrences) {
                ++iterationCounter;
                if (discordRegistry.contains(currentPos)) continue;
                LOGGER.trace("conducting search for {} at {}, iteration {}", new Object[]{currentWord, currentPos, iterationCounter});
                int markStart = currentPos - windowSize;
                int markEnd = currentPos + windowSize;
                HashSet<Integer> alreadyVisited = new HashSet<Integer>(occurrences.size() + (markEnd - markStart));
                for (int i = markStart; i < markEnd; ++i) {
                    alreadyVisited.add(i);
                }
                double[] currentCandidateSeq = tp.subseriesByCopy(series, currentPos, currentPos + windowSize);
                double nearestNeighborDist = Double.MAX_VALUE;
                boolean doRandomSearch = true;
                for (Integer nextOccurrence : occurrences) {
                    if (alreadyVisited.contains(nextOccurrence)) continue;
                    alreadyVisited.add(nextOccurrence);
                    double dist = HOTSAXImplementation.distance(currentCandidateSeq, series, nextOccurrence, nextOccurrence + windowSize);
                    ++distanceCalls;
                    if (dist < nearestNeighborDist) {
                        nearestNeighborDist = dist;
                        LOGGER.trace(" ** current NN at {}, distance: {}, pos {}", new Object[]{nextOccurrence, nearestNeighborDist, currentPos});
                    }
                    if (!(dist < bestSoFarDistance)) continue;
                    LOGGER.trace(" ** abandoning the occurrences loop, distance {} is less than the best so far {}", (Object)dist, (Object)bestSoFarDistance);
                    doRandomSearch = false;
                    break;
                }
                if (doRandomSearch) {
                    LOGGER.trace("starting random search");
                    int visitCounter = 0;
                    int cIndex = 0;
                    for (int i = 0; i < series.length - windowSize; ++i) {
                        if (alreadyVisited.contains(i)) continue;
                        visitArray[cIndex] = i;
                        ++cIndex;
                    }
                    Random rnd = new Random();
                    for (int i = --cIndex; i > 0; --i) {
                        int index = rnd.nextInt(i + 1);
                        int a = visitArray[index];
                        visitArray[index] = visitArray[i];
                        visitArray[i] = a;
                    }
                    while (cIndex >= 0) {
                        int randomPos = visitArray[cIndex];
                        --cIndex;
                        double dist = HOTSAXImplementation.distance(currentCandidateSeq, series, randomPos, randomPos + windowSize);
                        ++distanceCalls;
                        if (dist < nearestNeighborDist) {
                            LOGGER.trace(" ** current NN at {}, distance: {}", (Object)randomPos, (Object)dist);
                            nearestNeighborDist = dist;
                        }
                        if (dist < bestSoFarDistance) {
                            nearestNeighborDist = dist;
                            LOGGER.trace(" ** abandoning random visits loop, seen distance {} at iteration {}", (Object)nearestNeighborDist, (Object)visitCounter);
                            break;
                        }
                        ++visitCounter;
                    }
                }
                if (nearestNeighborDist > bestSoFarDistance && nearestNeighborDist < Double.MAX_VALUE) {
                    LOGGER.debug("discord updated: pos {}, dist {}", (Object)currentPos, (Object)bestSoFarDistance);
                    bestSoFarDistance = nearestNeighborDist;
                    bestSoFarPosition = currentPos;
                    bestSoFarWord = currentWord;
                }
                LOGGER.trace(" . . iterated {} times, best distance:  {} for a string {} at {}", new Object[]{iterationCounter, bestSoFarDistance, bestSoFarWord, bestSoFarPosition});
            }
        }
        LOGGER.trace("Distance calls: {}", (Object)distanceCalls);
        DiscordRecord res = new DiscordRecord(bestSoFarPosition, bestSoFarDistance, bestSoFarWord);
        res.setInfo("distance calls: " + distanceCalls);
        return res;
    }

    @Deprecated
    public static DiscordRecords series2DiscordsDeprecated(double[] series, int discordsNumToReport, int windowSize, int paaSize, int alphabetSize, SlidingWindowMarkerAlgorithm markerAlgorithm, NumerosityReductionStrategy strategy, double nThreshold) throws Exception {
        Date start = new Date();
        NormalAlphabet normalA = new NormalAlphabet();
        SAXRecords sax = sp.ts2saxViaWindow(series, windowSize, alphabetSize, normalA.getCuts(alphabetSize), strategy, nThreshold);
        Date saxEnd = new Date();
        LOGGER.debug("discretized in {}, words: {}, indexes: {}", new Object[]{SAXProcessor.timeToString(start.getTime(), saxEnd.getTime()), sax.getRecords().size(), sax.getIndexes().size()});
        HashMap<String, ArrayList<Integer>> hash = new HashMap<String, ArrayList<Integer>>();
        for (SAXRecord sr : sax.getRecords()) {
            for (Integer pos : sr.getIndexes()) {
                String word = String.valueOf(sr.getPayload());
                if (!hash.containsKey(word)) {
                    hash.put(word, new ArrayList());
                }
                hash.get(String.valueOf(word)).add(pos);
            }
        }
        Date hashEnd = new Date();
        LOGGER.debug("Hash filled in : {}", (Object)SAXProcessor.timeToString(saxEnd.getTime(), hashEnd.getTime()));
        DiscordRecords discords = HOTSAXImplementation.getDiscordsWithHash(series, windowSize, hash, discordsNumToReport, markerAlgorithm);
        Date end = new Date();
        LOGGER.info("{} discords found in {}", (Object)discords.getSize(), (Object)SAXProcessor.timeToString(start.getTime(), end.getTime()));
        return discords;
    }

    @Deprecated
    private static DiscordRecords getDiscordsWithHash(double[] series, int windowSize, HashMap<String, ArrayList<Integer>> hash, int discordCollectionSize, SlidingWindowMarkerAlgorithm markerAlgorithm) throws Exception {
        DiscordRecords discords = new DiscordRecords();
        VisitRegistry globalTrackVisitRegistry = new VisitRegistry(series.length);
        globalTrackVisitRegistry.markVisited(series.length - windowSize, windowSize);
        while (discords.getSize() < discordCollectionSize) {
            LOGGER.trace("currently known discords: {} out of {}", (Object)discords.getSize(), (Object)discordCollectionSize);
            Date start = new Date();
            DiscordRecord bestDiscord = HOTSAXImplementation.findBestDiscordWithHash(series, windowSize, hash, globalTrackVisitRegistry);
            Date end = new Date();
            if (bestDiscord.getNNDistance() == 0.0 || bestDiscord.getPosition() == -1) {
                LOGGER.trace("breaking the outer search loop, discords found: {} last seen discord: {}", (Object)discords.getSize(), (Object)bestDiscord.toString());
                break;
            }
            bestDiscord.setInfo("position " + bestDiscord.getPosition() + ", NN distance " + bestDiscord.getNNDistance() + ", elapsed time: " + SAXProcessor.timeToString(start.getTime(), end.getTime()) + ", " + bestDiscord.getInfo());
            LOGGER.debug(bestDiscord.getInfo());
            discords.add(bestDiscord);
            markerAlgorithm.markVisited(globalTrackVisitRegistry, bestDiscord.getPosition(), windowSize);
        }
        return discords;
    }

    @Deprecated
    private static DiscordRecord findBestDiscordWithHash(double[] series, int windowSize, HashMap<String, ArrayList<Integer>> hash, VisitRegistry globalRegistry) throws Exception {
        ArrayList<FrequencyTableEntry> frequencies = HOTSAXImplementation.hashToFreqEntries(hash);
        Collections.sort(frequencies);
        int bestSoFarPosition = -1;
        double bestSoFarDistance = 0.0;
        String bestSoFarWord = "";
        int iterationCounter = 0;
        int distanceCalls = 0;
        while (!frequencies.isEmpty()) {
            double dist;
            int markEnd;
            ++iterationCounter;
            FrequencyTableEntry currentEntry = frequencies.remove(0);
            String currentWord = String.valueOf(currentEntry.getStr());
            int currentPos = currentEntry.getPosition();
            if (globalRegistry.isVisited(currentPos)) continue;
            VisitRegistry randomRegistry = new VisitRegistry(series.length);
            randomRegistry.markVisited(series.length - windowSize, series.length);
            int markStart = currentPos - windowSize;
            if (markStart < 0) {
                markStart = 0;
            }
            if ((markEnd = currentPos + windowSize) > series.length) {
                markEnd = series.length;
            }
            randomRegistry.markVisited(markStart, markEnd);
            LOGGER.trace("conducting search for {} at {}, iteration {}, to go: {}", new Object[]{currentWord, currentPos, iterationCounter, frequencies.size()});
            double[] currentCandidateSeq = tp.subseriesByCopy(series, currentPos, currentPos + windowSize);
            double nearestNeighborDist = Double.MAX_VALUE;
            boolean doRandomSearch = true;
            List currentWordOccurrences = hash.get(currentWord);
            for (Integer nextOccurrence : currentWordOccurrences) {
                if (randomRegistry.isVisited(nextOccurrence)) continue;
                randomRegistry.markVisited(nextOccurrence);
                double[] occurrenceSubsequence = tp.subseriesByCopy(series, nextOccurrence, nextOccurrence + windowSize);
                dist = ed.distance(currentCandidateSeq, occurrenceSubsequence);
                ++distanceCalls;
                if (dist < nearestNeighborDist) {
                    nearestNeighborDist = dist;
                    LOGGER.trace(" ** current NN at {}, distance: {}, pos {}" + nextOccurrence, (Object)nearestNeighborDist, (Object)currentPos);
                }
                if (!(dist < bestSoFarDistance)) continue;
                LOGGER.trace(" ** abandoning random visits loop, seen distance {} at iteration {}", (Object)dist, (Object)bestSoFarDistance);
                doRandomSearch = false;
                break;
            }
            if (doRandomSearch) {
                LOGGER.trace("starting random search");
                int visitCounter = 0;
                int randomPos = -1;
                while (-1 != (randomPos = randomRegistry.getNextRandomUnvisitedPosition())) {
                    randomRegistry.markVisited(randomPos);
                    double[] randomSubsequence = tp.subseriesByCopy(series, randomPos, randomPos + windowSize);
                    dist = ed.distance(currentCandidateSeq, randomSubsequence);
                    ++distanceCalls;
                    if (dist < bestSoFarDistance) {
                        nearestNeighborDist = dist;
                        LOGGER.trace(" ** abandoning random visits loop, seen distance {} at iteration {}", (Object)nearestNeighborDist, (Object)visitCounter);
                        break;
                    }
                    if (dist < nearestNeighborDist) {
                        LOGGER.trace(" ** current NN at {}, distance: {}, pos {}" + randomPos, (Object)dist, (Object)currentPos);
                        nearestNeighborDist = dist;
                    }
                    ++visitCounter;
                }
            }
            if (nearestNeighborDist > bestSoFarDistance) {
                LOGGER.debug("discord updated: pos {}, dist {}", (Object)currentPos, (Object)bestSoFarDistance);
                bestSoFarDistance = nearestNeighborDist;
                bestSoFarPosition = currentPos;
                bestSoFarWord = currentWord;
            }
            LOGGER.trace(" . . iterated {} times, best distance: {} for a string {} at {}", new Object[]{iterationCounter, bestSoFarDistance, bestSoFarWord, bestSoFarPosition});
        }
        LOGGER.trace("Distance calls: {}", (Object)distanceCalls);
        DiscordRecord res = new DiscordRecord(bestSoFarPosition, bestSoFarDistance, bestSoFarWord);
        res.setInfo("distance calls: " + distanceCalls);
        return res;
    }

    @Deprecated
    private static ArrayList<FrequencyTableEntry> hashToFreqEntries(HashMap<String, ArrayList<Integer>> hash) {
        ArrayList<FrequencyTableEntry> res = new ArrayList<FrequencyTableEntry>();
        for (Map.Entry<String, ArrayList<Integer>> e : hash.entrySet()) {
            char[] payload = e.getKey().toCharArray();
            int frequency = e.getValue().size();
            for (Integer i : e.getValue()) {
                res.add(new FrequencyTableEntry(i, (char[])payload.clone(), frequency));
            }
        }
        return res;
    }

    private static double distance(double[] subseries, double[] series, int from, int to) throws Exception {
        Double sum = 0.0;
        for (int i = from; i < to; ++i) {
            double tmp = subseries[i - from] - series[i];
            sum = sum + tmp * tmp;
        }
        return Math.sqrt(sum);
    }
}

