/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.discord;

import java.util.Iterator;
import java.util.List;
import net.seninp.jmotif.sax.discord.DiscordRecord;
import net.seninp.util.SortedArrayList;

public class DiscordRecords
implements Iterable<DiscordRecord> {
    private final SortedArrayList<DiscordRecord> discords = new SortedArrayList();

    public void add(DiscordRecord discord) {
        this.discords.insertSorted(discord);
    }

    public List<DiscordRecord> getTopHits(Integer num) {
        if (num >= this.discords.size()) {
            return this.discords;
        }
        List<DiscordRecord> res = this.discords.subList(this.discords.size() - num, this.discords.size());
        return res;
    }

    public double getMinDistance() {
        if (this.discords.size() > 0) {
            return ((DiscordRecord)this.discords.get(0)).getNNDistance();
        }
        return -1.0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        for (int i = 0; i < this.discords.size(); ++i) {
            DiscordRecord record = (DiscordRecord)this.discords.get(i);
            if (record.getPayload().isEmpty()) {
                sb.append("discord #" + i + " \"\", at " + record.getPosition() + " distance to closest neighbor: " + record.getNNDistance() + "\"\n");
                continue;
            }
            sb.append("discord #" + i + " \"" + record.getPayload() + "\", at " + record.getPosition() + " distance to closest neighbor: " + record.getNNDistance() + ", info string: \"" + record.getInfo() + "\"\n");
        }
        return sb.toString();
    }

    @Override
    public Iterator<DiscordRecord> iterator() {
        return this.discords.iterator();
    }

    public int getSize() {
        return this.discords.size();
    }

    public DiscordRecord get(int i) {
        return (DiscordRecord)this.discords.get(i);
    }
}

