/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.discord;

public class DiscordRecord
implements Comparable<DiscordRecord> {
    private int ruleId;
    private int position;
    private int length;
    private double nnDistance;
    private String payload;
    private String info;

    public DiscordRecord() {
        this.position = -1;
        this.length = -1;
        this.nnDistance = -1.0;
    }

    public DiscordRecord(int index, double dist) {
        this.position = index;
        this.nnDistance = dist;
        this.payload = "";
    }

    public DiscordRecord(int index, double dist, String payload) {
        this.position = index;
        this.nnDistance = dist;
        this.payload = payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setNNDistance(double distance) {
        this.nnDistance = distance;
    }

    public double getNNDistance() {
        return this.nnDistance;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Integer getLength() {
        return this.length;
    }

    @Override
    public int compareTo(DiscordRecord other) {
        if (null == other) {
            throw new NullPointerException("Unable compare to null!");
        }
        return Double.compare(other.getNNDistance(), this.nnDistance);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.nnDistance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.position;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscordRecord other = (DiscordRecord)obj;
        if (Double.doubleToLongBits(this.nnDistance) != Double.doubleToLongBits(other.nnDistance)) {
            return false;
        }
        return this.position == other.position;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(int ruleId) {
        this.ruleId = ruleId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("'").append(this.payload).append("'");
        sb.append(", distance: ");
        sb.append(this.nnDistance).append(", position: ").append(this.position);
        if (null != this.info && !this.info.isEmpty()) {
            sb.append(", info: ").append(this.info);
        }
        return sb.toString();
    }
}

