/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.datastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.seninp.jmotif.sax.datastructure.DoublyLinkedSortedList;
import net.seninp.jmotif.sax.datastructure.SAXRecord;

public class SAXRecords
implements Iterable<SAXRecord> {
    private final long id;
    private final HashMap<String, SAXRecord> records;
    private final HashMap<Integer, SAXRecord> realTSindex;
    private HashMap<Integer, Integer> stringPosToRealPos;

    public SAXRecords() {
        this.id = System.currentTimeMillis();
        this.records = new HashMap();
        this.realTSindex = new HashMap();
    }

    public SAXRecords(long id) {
        this.id = id;
        this.records = new HashMap();
        this.realTSindex = new HashMap();
    }

    public long getId() {
        return this.id;
    }

    @Override
    public Iterator<SAXRecord> iterator() {
        return this.records.values().iterator();
    }

    public SAXRecord getByIndex(int idx) {
        return this.realTSindex.get(idx);
    }

    public SAXRecord getByWord(String str) {
        return this.records.get(str);
    }

    public void dropByIndex(int idx) {
        SAXRecord entry = this.realTSindex.get(idx);
        if (null != entry) {
            this.realTSindex.remove(idx);
            entry.removeIndex(idx);
            if (entry.getIndexes().isEmpty()) {
                this.records.remove(String.valueOf(entry.getPayload()));
            }
        }
    }

    public void add(char[] str, int idx) {
        SAXRecord rr = this.records.get(String.valueOf(str));
        if (null == rr) {
            rr = new SAXRecord(str, idx);
            this.records.put(String.valueOf(str), rr);
        } else {
            rr.addIndex(idx);
        }
        this.realTSindex.put(idx, rr);
    }

    public void addAll(SAXRecords records) {
        for (SAXRecord record : records) {
            char[] payload = record.getPayload();
            for (Integer i : record.getIndexes()) {
                this.add(payload, i);
            }
        }
    }

    public void addAll(HashMap<Integer, char[]> records) {
        for (Map.Entry<Integer, char[]> e : records.entrySet()) {
            this.add(e.getValue(), e.getKey());
        }
    }

    public int getMinIndex() {
        return Collections.min(this.realTSindex.keySet());
    }

    public int getMaxIndex() {
        return Collections.max(this.realTSindex.keySet());
    }

    public int size() {
        return this.realTSindex.size();
    }

    public Set<Integer> getIndexes() {
        return this.realTSindex.keySet();
    }

    public String getSAXString(String separatorToken) {
        StringBuffer sb = new StringBuffer();
        ArrayList<Integer> index = new ArrayList<Integer>();
        index.addAll(this.realTSindex.keySet());
        Collections.sort(index, new Comparator<Integer>(){

            @Override
            public int compare(Integer int1, Integer int2) {
                return int1.compareTo(int2);
            }
        });
        Iterator iterator = index.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            sb.append(this.realTSindex.get(i).getPayload()).append(separatorToken);
        }
        return sb.toString();
    }

    public ArrayList<Integer> getAllIndices() {
        ArrayList<Integer> res = new ArrayList<Integer>(this.realTSindex.size());
        res.addAll(this.realTSindex.keySet());
        Collections.sort(res);
        return res;
    }

    public void buildIndex() {
        this.stringPosToRealPos = new HashMap();
        int counter = 0;
        for (Integer idx : this.getAllIndices()) {
            this.stringPosToRealPos.put(counter, idx);
            ++counter;
        }
    }

    public Integer mapStringIndexToTSPosition(int idx) {
        return this.stringPosToRealPos.get(idx);
    }

    public void excludePositions(ArrayList<Integer> positions) {
        for (Integer p : positions) {
            if (!this.realTSindex.containsKey(p)) continue;
            SAXRecord rec = this.realTSindex.get(p);
            rec.removeIndex(p);
            if (rec.getIndexes().isEmpty()) {
                this.records.remove(String.valueOf(rec.getPayload()));
            }
            this.realTSindex.remove(p);
        }
    }

    public ArrayList<SAXRecord> getMotifs(int num) {
        ArrayList<SAXRecord> res = new ArrayList<SAXRecord>(num);
        DoublyLinkedSortedList<Map.Entry<String, SAXRecord>> list = new DoublyLinkedSortedList<Map.Entry<String, SAXRecord>>(num, new Comparator<Map.Entry<String, SAXRecord>>(){

            @Override
            public int compare(Map.Entry<String, SAXRecord> o1, Map.Entry<String, SAXRecord> o2) {
                int f1 = o1.getValue().getIndexes().size();
                int f2 = o2.getValue().getIndexes().size();
                return Integer.compare(f1, f2);
            }
        });
        for (Map.Entry<String, SAXRecord> e : this.records.entrySet()) {
            list.addElement(e);
        }
        Iterator<Map.Entry<String, SAXRecord>> i = list.iterator();
        while (i.hasNext()) {
            res.add(i.next().getValue());
        }
        return res;
    }

    public Collection<SAXRecord> getRecords() {
        return this.records.values();
    }
}

