/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.datastructure;

import java.util.Arrays;
import java.util.TreeSet;

public class FrequencyTableEntry
implements Comparable<FrequencyTableEntry> {
    private int position;
    private char[] payload;
    private int frequency;

    public FrequencyTableEntry(int len, int pos) {
        this.payload = new char[len];
        this.frequency = -1;
        this.position = pos;
    }

    public FrequencyTableEntry(Integer position, char[] payload, int frequency) {
        this.position = position;
        this.payload = payload;
        this.frequency = frequency;
    }

    public char[] getStr() {
        char[] res = new char[this.payload.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.payload[i];
        }
        return res;
    }

    public void setStr(char[] str) {
        this.payload = Arrays.copyOf(str, str.length);
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isTrivial(Integer complexity) {
        int len = this.payload.length;
        if (null == complexity || len < 2) {
            return true;
        }
        if (complexity > 0 && len > 2) {
            TreeSet<Character> seen = new TreeSet<Character>();
            for (int i = 0; i < len; ++i) {
                Character c = Character.valueOf(this.payload[i]);
                if (seen.contains(c)) continue;
                seen.add(c);
            }
            if (complexity <= seen.size()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(FrequencyTableEntry arg0) {
        if (null == arg0) {
            throw new NullPointerException("Unable to compare with a null object.");
        }
        if (this.frequency > arg0.getFrequency()) {
            return 1;
        }
        if (this.frequency < arg0.getFrequency()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.frequency;
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrequencyTableEntry other = (FrequencyTableEntry)obj;
        if (this.frequency != other.frequency) {
            return false;
        }
        return Arrays.equals(this.payload, other.payload);
    }

    public String toString() {
        return "payload: " + String.valueOf(this.payload) + ", frequency: " + this.frequency + ", location: " + this.position;
    }

    public FrequencyTableEntry copy() {
        FrequencyTableEntry res = new FrequencyTableEntry(this.position, this.payload, this.frequency);
        return res;
    }
}

