/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.bitmap;

import com.beust.jcommander.JCommander;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeSet;
import net.seninp.jmotif.sax.SAXException;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.bitmap.BitmapParameters;
import net.seninp.util.HeatChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSBitmapPrinter {
    private static final String QUOTE = "'";
    private static final String COMMA = ",";
    private static final String CR = "\n";
    private static final TSProcessor tsp = new TSProcessor();
    private static final SAXProcessor sp = new SAXProcessor();
    private static final Logger LOGGER = LoggerFactory.getLogger(TSBitmapPrinter.class);

    public static void main(String[] args) throws SAXException, IOException {
        BitmapParameters params = new BitmapParameters();
        JCommander jct = new JCommander((Object)params, args);
        if (0 == args.length) {
            jct.usage();
        } else {
            double[][] heatmapData;
            StringBuffer sb = new StringBuffer(1024);
            sb.append("SAXBitmap CLI converter v.0.1").append(CR);
            sb.append("parameters:").append(CR);
            sb.append("  input file:                  ").append(BitmapParameters.IN_FILE).append(CR);
            sb.append("  output file:                 ").append(BitmapParameters.OUT_FILE).append(CR);
            sb.append("  SAX sliding window size:     ").append(BitmapParameters.SAX_WINDOW_SIZE).append(CR);
            sb.append("  SAX PAA size:                ").append(BitmapParameters.SAX_PAA_SIZE).append(CR);
            sb.append("  SAX alphabet size:           ").append(BitmapParameters.SAX_ALPHABET_SIZE).append(CR);
            sb.append("  SAX numerosity reduction:    ").append((Object)BitmapParameters.SAX_NR_STRATEGY).append(CR);
            sb.append("  SAX normalization threshold: ").append(BitmapParameters.SAX_NORM_THRESHOLD).append(CR);
            sb.append("  Bitmap shingle size:         ").append(BitmapParameters.SHINGLE_SIZE).append(CR);
            if (null == BitmapParameters.BITMAP_FILE) {
                sb.append("  No bitmap will be produced").append(BitmapParameters.SHINGLE_SIZE).append(CR);
            } else {
                sb.append("  Bitmap filename specified: ").append(BitmapParameters.BITMAP_FILE).append(CR);
            }
            sb.append(CR);
            LOGGER.info("{}", (Object)sb.toString());
            double[] data = tsp.readTS(BitmapParameters.IN_FILE, 0);
            LOGGER.info("read {} points from {}", (Object)data.length, (Object)BitmapParameters.IN_FILE);
            Map<String, Integer> shingledData = sp.ts2Shingles(data, BitmapParameters.SAX_WINDOW_SIZE, BitmapParameters.SAX_PAA_SIZE, BitmapParameters.SAX_ALPHABET_SIZE, BitmapParameters.SAX_NR_STRATEGY, BitmapParameters.SAX_NORM_THRESHOLD, BitmapParameters.SHINGLE_SIZE);
            LOGGER.info("writing output...");
            StringBuilder shingles = new StringBuilder(BitmapParameters.SHINGLE_SIZE * (shingledData.size() + 2));
            StringBuilder freqs = new StringBuilder(BitmapParameters.SHINGLE_SIZE * (shingledData.size() + 2));
            TreeSet<String> keys = new TreeSet<String>(shingledData.keySet());
            for (String shingle : keys) {
                shingles.append(QUOTE).append(shingle).append(QUOTE).append(COMMA);
                freqs.append(shingledData.get(shingle)).append(COMMA);
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(BitmapParameters.OUT_FILE)));
            bw.write(shingles.delete(shingles.length() - 1, shingles.length()).toString());
            bw.write(CR);
            bw.write(freqs.delete(freqs.length() - 1, freqs.length()).toString());
            bw.write(CR);
            bw.close();
            if (null == BitmapParameters.BITMAP_FILE) {
                System.exit(10);
            }
            if (16 == shingledData.size()) {
                heatmapData = new double[4][4];
                int counter = 0;
                for (String shingle : keys) {
                    Integer value = shingledData.get(shingle);
                    heatmapData[counter / 4][counter % 4] = value.intValue();
                    ++counter;
                }
                HeatChart chart = new HeatChart(heatmapData);
                chart.setAxisThickness(0);
                chart.setTitle(BitmapParameters.IN_FILE);
                chart.setCellSize(new Dimension(64, 64));
                chart.saveToFile(new File("my-chart.png"));
            } else if (64 == shingledData.size()) {
                heatmapData = new double[8][8];
                int counter = 0;
                for (String shingle : keys) {
                    Integer value = shingledData.get(shingle);
                    heatmapData[counter / 8][counter % 8] = value.intValue();
                    ++counter;
                }
                HeatChart chart = new HeatChart(heatmapData);
                chart.setAxisThickness(0);
                chart.setTitle(BitmapParameters.IN_FILE);
                chart.setCellSize(new Dimension(32, 32));
                chart.saveToFile(new File(BitmapParameters.BITMAP_FILE));
            } else {
                LOGGER.error("Bitmap is produced for 16 or 64 shingles only.");
            }
            LOGGER.info("done!");
        }
    }
}

