/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.bitmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;

public class Shingles {
    private Map<String, List<int[]>> shingles = new HashMap<String, List<int[]>>();
    private HashMap<String, Integer> indexTable = new HashMap();

    public Shingles(int alphabetSize, int shingleSize) {
        String[] alphabet = new String[alphabetSize];
        for (int i = 0; i < alphabetSize; ++i) {
            alphabet[i] = String.valueOf(TSProcessor.ALPHABET[i]);
        }
        String[] allStrings = SAXProcessor.getAllPermutations(alphabet, shingleSize);
        for (int i = 0; i < allStrings.length; ++i) {
            this.indexTable.put(allStrings[i], i);
        }
    }

    public HashMap<String, Integer> getIndex() {
        return this.indexTable;
    }

    public void addShingledSeries(String key, int[] counts) {
        if (null == this.shingles.get(key)) {
            this.shingles.put(key, new ArrayList());
        }
        this.shingles.get(key).add(counts);
    }

    public List<int[]> get(String key) {
        return this.shingles.get(key);
    }

    public int indexForShingle(String shingle) {
        return this.indexTable.get(shingle);
    }
}

