/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import net.seninp.jmotif.sax.SAXException;
import net.seninp.jmotif.sax.alphabet.Alphabet;

public class TSProcessor {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final char[] ALPHABET = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static double[] readFileColumn(String filename, int columnIdx, int sizeLimit) throws IOException, SAXException {
        Path path = Paths.get(filename, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new SAXException("unable to load data - data source not found.");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
        return TSProcessor.readTS(br, columnIdx, sizeLimit);
    }

    public static double[] readTS(BufferedReader br, int columnIdx, int sizeLimit) throws IOException, SAXException {
        ArrayList<Double> preRes = new ArrayList<Double>();
        int lineCounter = 0;
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] split = line.trim().split("\\s+");
            if (split.length < columnIdx) {
                String message = "Unable to read data from column " + columnIdx;
                br.close();
                throw new SAXException(message);
            }
            String str = split[columnIdx];
            double num = Double.NaN;
            try {
                num = Double.valueOf(str);
            }
            catch (NumberFormatException e) {
                continue;
            }
            preRes.add(num);
            if (0 == sizeLimit || ++lineCounter < sizeLimit) continue;
            break;
        }
        br.close();
        double[] res = new double[preRes.size()];
        for (int i = 0; i < preRes.size(); ++i) {
            res[i] = (Double)preRes.get(i);
        }
        return res;
    }

    public double[] readTS(String dataFileName, int loadLimit) throws SAXException, IOException {
        Path path = Paths.get(dataFileName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new SAXException("unable to load data - data source not found.");
        }
        BufferedReader reader = Files.newBufferedReader(path, DEFAULT_CHARSET);
        return TSProcessor.readTS(reader, 0, loadLimit);
    }

    public double max(double[] series) {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < series.length; ++i) {
            if (!(max < series[i])) continue;
            max = series[i];
        }
        return max;
    }

    public double min(double[] series) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < series.length; ++i) {
            if (!(min > series[i])) continue;
            min = series[i];
        }
        return min;
    }

    public double mean(double[] series) {
        double res = 0.0;
        int count = 0;
        for (double tp : series) {
            res += tp;
            ++count;
        }
        if (count > 0) {
            return res / Integer.valueOf(count).doubleValue();
        }
        return Double.NaN;
    }

    public double mean(int[] series) {
        double res = 0.0;
        int count = 0;
        for (int tp : series) {
            res += (double)tp;
            ++count;
        }
        if (count > 0) {
            return res / Integer.valueOf(count).doubleValue();
        }
        return Double.NaN;
    }

    public double median(double[] series) {
        double[] clonedSeries = (double[])series.clone();
        Arrays.sort(clonedSeries);
        double median = clonedSeries.length % 2 == 0 ? (clonedSeries[clonedSeries.length / 2] + clonedSeries[clonedSeries.length / 2 - 1]) / 2.0 : clonedSeries[clonedSeries.length / 2];
        return median;
    }

    public double var(double[] series) {
        double res = 0.0;
        double mean = this.mean(series);
        int count = 0;
        for (double tp : series) {
            res += (tp - mean) * (tp - mean);
            ++count;
        }
        if (count > 0) {
            return res / Integer.valueOf(count - 1).doubleValue();
        }
        return Double.NaN;
    }

    public double stDev(double[] series) {
        double num0 = 0.0;
        double sum = 0.0;
        int count = 0;
        for (double tp : series) {
            num0 += tp * tp;
            sum += tp;
            ++count;
        }
        double len = Integer.valueOf(count).doubleValue();
        return Math.sqrt((len * num0 - sum * sum) / (len * (len - 1.0)));
    }

    public double[] znorm(double[] series, double normalizationThreshold) {
        double[] res = new double[series.length];
        double mean = this.mean(series);
        double sd = this.stDev(series);
        if (sd < normalizationThreshold) {
            return (double[])series.clone();
        }
        for (int i = 0; i < res.length; ++i) {
            res[i] = (series[i] - mean) / sd;
        }
        return res;
    }

    public double[] paa(double[] ts, int paaSize) throws SAXException {
        int i;
        int len = ts.length;
        if (len < paaSize) {
            throw new SAXException("PAA size can't be greater than the timeseries size.");
        }
        if (len == paaSize) {
            return Arrays.copyOf(ts, ts.length);
        }
        double[] paa = new double[paaSize];
        double pointsPerSegment = (double)len / (double)paaSize;
        double[] breaks = new double[paaSize + 1];
        for (i = 0; i < paaSize + 1; ++i) {
            breaks[i] = (double)i * pointsPerSegment;
        }
        for (i = 0; i < paaSize; ++i) {
            double segStart = breaks[i];
            double segEnd = breaks[i + 1];
            double fractionStart = Math.ceil(segStart) - segStart;
            double fractionEnd = segEnd - Math.floor(segEnd);
            int fullStart = Double.valueOf(Math.floor(segStart)).intValue();
            int fullEnd = Double.valueOf(Math.ceil(segEnd)).intValue();
            double[] segment = Arrays.copyOfRange(ts, fullStart, fullEnd);
            if (fractionStart > 0.0) {
                segment[0] = segment[0] * fractionStart;
            }
            if (fractionEnd > 0.0) {
                segment[segment.length - 1] = segment[segment.length - 1] * fractionEnd;
            }
            double elementsSum = 0.0;
            for (double e : segment) {
                elementsSum += e;
            }
            paa[i] = elementsSum / pointsPerSegment;
        }
        return paa;
    }

    @Deprecated
    public double[] paa_old(double[] ts, int paaSize) {
        int i;
        int len = ts.length;
        if (len == paaSize) {
            return Arrays.copyOf(ts, ts.length);
        }
        if (len % paaSize == 0) {
            int i2;
            double[] paa = new double[paaSize];
            int inc = len / paaSize;
            for (i2 = 0; i2 < len; ++i2) {
                int idx;
                int n = idx = i2 / inc;
                paa[n] = paa[n] + ts[i2];
            }
            for (i2 = 0; i2 < paaSize; ++i2) {
                paa[i2] = paa[i2] / (double)inc;
            }
            return paa;
        }
        double[] paa = new double[paaSize];
        for (i = 0; i < len * paaSize; ++i) {
            int idx = i / len;
            int pos = i / paaSize;
            paa[idx] = paa[idx] + ts[pos];
        }
        for (i = 0; i < paaSize; ++i) {
            paa[i] = paa[i] / (double)len;
        }
        return paa;
    }

    @Deprecated
    public double[] paa_oldest(double[] ts, int paaSize) {
        int i;
        int len = ts.length;
        if (len == paaSize) {
            return Arrays.copyOf(ts, ts.length);
        }
        if (len % paaSize == 0) {
            return this.colMeans(this.reshape(this.asMatrix(ts), len / paaSize, paaSize));
        }
        double[] paa = new double[paaSize];
        for (i = 0; i < len * paaSize; ++i) {
            int idx = i / len;
            int pos = i / paaSize;
            paa[idx] = paa[idx] + ts[pos];
        }
        for (i = 0; i < paaSize; ++i) {
            paa[i] = paa[i] / (double)len;
        }
        return paa;
    }

    public char[] ts2String(double[] vals, double[] cuts) {
        char[] res = new char[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            res[i] = this.num2char(vals[i], cuts);
        }
        return res;
    }

    public int[] ts2Index(double[] series, Alphabet alphabet, int alphabetSize) throws Exception {
        double[] cuts = alphabet.getCuts(alphabetSize);
        int[] res = new int[series.length];
        for (int i = 0; i < series.length; ++i) {
            res[i] = this.num2index(series[i], cuts);
        }
        return res;
    }

    public char num2char(double value, double[] cuts) {
        int count;
        for (count = 0; count < cuts.length && cuts[count] <= value; ++count) {
        }
        return ALPHABET[count];
    }

    public char num2char(int idx) {
        return ALPHABET[idx];
    }

    public int num2index(double value, double[] cuts) {
        int count;
        for (count = 0; count < cuts.length && cuts[count] <= value; ++count) {
        }
        return count;
    }

    public double[] subseriesByCopy(double[] series, int start, int end) throws IndexOutOfBoundsException {
        if (start > end || start < 0 || end > series.length) {
            throw new IndexOutOfBoundsException("Unable to extract subseries, series length: " + series.length + ", start: " + start + ", end: " + String.valueOf(end - start));
        }
        return Arrays.copyOfRange(series, start, end);
    }

    public String seriesToString(double[] series, NumberFormat df) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (double d : series) {
            sb.append(df.format(d)).append(',');
        }
        sb.delete(sb.length() - 2, sb.length() - 1).append("]");
        return sb.toString();
    }

    public double[][] reshape(double[][] a, int n, int m) {
        int currentElement = 0;
        int aRows = a.length;
        double[][] res = new double[n][m];
        for (int j = 0; j < m; ++j) {
            for (int i = 0; i < n; ++i) {
                res[i][j] = a[currentElement % aRows][currentElement / aRows];
                ++currentElement;
            }
        }
        return res;
    }

    public double[][] asMatrix(double[] vector) {
        double[][] res = new double[1][vector.length];
        for (int i = 0; i < vector.length; ++i) {
            res[0][i] = vector[i];
        }
        return res;
    }

    public double[] colMeans(double[][] a) {
        double[] res = new double[a[0].length];
        for (int j = 0; j < a[0].length; ++j) {
            double sum = 0.0;
            int counter = 0;
            for (int i = 0; i < a.length; ++i) {
                if (Double.isNaN(a[i][j]) || Double.isInfinite(a[i][j])) continue;
                sum += a[i][j];
                ++counter;
            }
            res[j] = counter == 0 ? Double.NaN : sum / Integer.valueOf(counter).doubleValue();
        }
        return res;
    }

    public double[] normOne(double[] data) {
        double[] res = new double[data.length];
        double max = this.max(data);
        for (int i = 0; i < data.length; ++i) {
            res[i] = data[i] / max;
        }
        return res;
    }
}

