package net.seninp.jmotif.sax.alphabet;

import net.seninp.jmotif.sax.SAXException;

/**
 * Implements alphabet component for SAX.
 * 
 * @author Pavel Senin
 * 
 */
public final class NormalAlphabet extends Alphabet {

  /** The latin alphabet, lower case letters a-z. */
  public static final char[] ALPHABET = { 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k',
      'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z' };
  
  /** Maximal possible alphabet size. */
  private static final int MAX_SIZE = 20;

  // cut intervals
  //
  private static final double[] case2 = { 0 };
  private static final double[] case3 = { -0.4307273, 0.4307273 };
  private static final double[] case4 = { -0.6744898, 0, 0.6744898 };
  private static final double[] case5 = { -0.841621233572914, -0.2533471031358, 0.2533471031358,
      0.841621233572914 };
  private static final double[] case6 = { -0.967421566101701, -0.430727299295457, 0,
      0.430727299295457, 0.967421566101701 };
  private static final double[] case7 = { -1.06757052387814, -0.565948821932863,
      -0.180012369792705, 0.180012369792705, 0.565948821932863, 1.06757052387814 };
  private static final double[] case8 = { -1.15034938037601, -0.674489750196082,
      -0.318639363964375, 0, 0.318639363964375, 0.674489750196082, 1.15034938037601 };
  private static final double[] case9 = { -1.22064034884735, -0.764709673786387,
      -0.430727299295457, -0.139710298881862, 0.139710298881862, 0.430727299295457,
      0.764709673786387, 1.22064034884735 };
  private static final double[] case10 = { -1.2815515655446, -0.841621233572914,
      -0.524400512708041, -0.2533471031358, 0, 0.2533471031358, 0.524400512708041,
      0.841621233572914, 1.2815515655446 };
  private static final double[] case11 = { -1.33517773611894, -0.908457868537385,
      -0.604585346583237, -0.348755695517045, -0.114185294321428, 0.114185294321428,
      0.348755695517045, 0.604585346583237, 0.908457868537385, 1.33517773611894 };
  private static final double[] case12 = { -1.38299412710064, -0.967421566101701,
      -0.674489750196082, -0.430727299295457, -0.210428394247925, 0, 0.210428394247925,
      0.430727299295457, 0.674489750196082, 0.967421566101701, 1.38299412710064 };
  private static final double[] case13 = { -1.42607687227285, -1.0200762327862, -0.736315917376129,
      -0.502402223373355, -0.293381232121193, -0.0965586152896391, 0.0965586152896394,
      0.293381232121194, 0.502402223373355, 0.73631591737613, 1.0200762327862, 1.42607687227285 };
  private static final double[] case14 = { -1.46523379268552, -1.06757052387814,
      -0.791638607743375, -0.565948821932863, -0.36610635680057, -0.180012369792705, 0,
      0.180012369792705, 0.36610635680057, 0.565948821932863, 0.791638607743375, 1.06757052387814,
      1.46523379268552 };
  private static final double[] case15 = { -1.50108594604402, -1.11077161663679,
      -0.841621233572914, -0.622925723210088, -0.430727299295457, -0.2533471031358,
      -0.0836517339071291, 0.0836517339071291, 0.2533471031358, 0.430727299295457,
      0.622925723210088, 0.841621233572914, 1.11077161663679, 1.50108594604402 };
  private static final double[] case16 = { -1.53412054435255, -1.15034938037601,
      -0.887146559018876, -0.674489750196082, -0.488776411114669, -0.318639363964375,
      -0.157310684610171, 0, 0.157310684610171, 0.318639363964375, 0.488776411114669,
      0.674489750196082, 0.887146559018876, 1.15034938037601, 1.53412054435255 };
  private static final double[] case17 = { -1.5647264713618, -1.18683143275582, -0.928899491647271,
      -0.721522283982343, -0.541395085129088, -0.377391943828554, -0.223007830940367,
      -0.0737912738082727, 0.0737912738082727, 0.223007830940367, 0.377391943828554,
      0.541395085129088, 0.721522283982343, 0.928899491647271, 1.18683143275582, 1.5647264713618 };
  private static final double[] case18 = { -1.59321881802305, -1.22064034884735,
      -0.967421566101701, -0.764709673786387, -0.589455797849779, -0.430727299295457,
      -0.282216147062508, -0.139710298881862, 0, 0.139710298881862, 0.282216147062508,
      0.430727299295457, 0.589455797849779, 0.764709673786387, 0.967421566101701, 1.22064034884735,
      1.59321881802305 };
  private static final double[] case19 = { -1.61985625863827, -1.25211952026522, -1.00314796766253,
      -0.8045963803603, -0.633640000779701, -0.47950565333095, -0.336038140371823,
      -0.199201324789267, -0.0660118123758407, 0.0660118123758406, 0.199201324789267,
      0.336038140371823, 0.47950565333095, 0.633640000779701, 0.8045963803603, 1.00314796766253,
      1.25211952026522, 1.61985625863827 };
  private static final double[] case20 = { -1.64485362695147, -1.2815515655446, -1.03643338949379,
      -0.841621233572914, -0.674489750196082, -0.524400512708041, -0.385320466407568,
      -0.2533471031358, -0.125661346855074, 0, 0.125661346855074, 0.2533471031358,
      0.385320466407568, 0.524400512708041, 0.674489750196082, 0.841621233572914, 1.03643338949379,
      1.2815515655446, 1.64485362695147 };

  private static final double[][] distance_case2 = { { 0.000000, 0.000000 }, { 0.000000, 0.000000 } };

  private static final double[][] distance_case3 = { { 0.000000, 0.000000, 0.861455 },
      { 0.000000, 0.000000, 0.000000 }, { 0.861455, 0.000000, 0.000000 } };

  private static final double[][] distance_case4 =

  { { 0.000000, 0.000000, 0.674490, 1.348980 }, { 0.000000, 0.000000, 0.000000, 0.674490 },
      { 0.674490, 0.000000, 0.000000, 0.000000 }, { 1.348980, 0.674490, 0.000000, 0.000000 } };

  private static final double[][] distance_case5 = {
      { 0.000000, 0.000000, 0.588274, 1.094968, 1.683242 },
      { 0.000000, 0.000000, 0.000000, 0.506694, 1.094968 },
      { 0.588274, 0.000000, 0.000000, 0.000000, 0.588274 },
      { 1.094968, 0.506694, 0.000000, 0.000000, 0.000000 },
      { 1.683242, 1.094968, 0.588274, 0.000000, 0.000000 } };

  private static final double[][] distance_case6 = {
      { 0.000000, 0.000000, 0.536694, 0.967422, 1.398149, 1.934843 },
      { 0.000000, 0.000000, 0.000000, 0.430727, 0.861455, 1.398149 },
      { 0.536694, 0.000000, 0.000000, 0.000000, 0.430727, 0.967422 },
      { 0.967422, 0.430727, 0.000000, 0.000000, 0.000000, 0.536694 },
      { 1.398149, 0.861455, 0.430727, 0.000000, 0.000000, 0.000000 },
      { 1.934843, 1.398149, 0.967422, 0.536694, 0.000000, 0.000000 } };

  private static final double[][] distance_case7 = {
      { 0.000000, 0.000000, 0.501622, 0.887558, 1.247583, 1.633519, 2.135141 },
      { 0.000000, 0.000000, 0.000000, 0.385936, 0.745961, 1.131898, 1.633519 },
      { 0.501622, 0.000000, 0.000000, 0.000000, 0.360025, 0.745961, 1.247583 },
      { 0.887558, 0.385936, 0.000000, 0.000000, 0.000000, 0.385936, 0.887558 },
      { 1.247583, 0.745961, 0.360025, 0.000000, 0.000000, 0.000000, 0.501622 },
      { 1.633519, 1.131898, 0.745961, 0.385936, 0.000000, 0.000000, 0.000000 },
      { 2.135141, 1.633519, 1.247583, 0.887558, 0.501622, 0.000000, 0.000000 } };

  private static final double[][] distance_case8 = {
      { 0.000000, 0.000000, 0.475860, 0.831710, 1.150349, 1.468989, 1.824839, 2.300699 },
      { 0.000000, 0.000000, 0.000000, 0.355850, 0.674490, 0.993129, 1.348980, 1.824839 },
      { 0.475860, 0.000000, 0.000000, 0.000000, 0.318639, 0.637279, 0.993129, 1.468989 },
      { 0.831710, 0.355850, 0.000000, 0.000000, 0.000000, 0.318639, 0.674490, 1.150349 },
      { 1.150349, 0.674490, 0.318639, 0.000000, 0.000000, 0.000000, 0.355850, 0.831710 },
      { 1.468989, 0.993129, 0.637279, 0.318639, 0.000000, 0.000000, 0.000000, 0.475860 },
      { 1.824839, 1.348980, 0.993129, 0.674490, 0.355850, 0.000000, 0.000000, 0.000000 },
      { 2.300699, 1.824839, 1.468989, 1.150349, 0.831710, 0.475860, 0.000000, 0.000000 } };

  private static final double[][] distance_case9 = {
      { 0.000000, 0.000000, 0.455931, 0.789913, 1.080930, 1.360351, 1.651368, 1.985350, 2.441281 },
      { 0.000000, 0.000000, 0.000000, 0.333982, 0.624999, 0.904420, 1.195437, 1.529419, 1.985350 },
      { 0.455931, 0.000000, 0.000000, 0.000000, 0.291017, 0.570438, 0.861455, 1.195437, 1.651368 },
      { 0.789913, 0.333982, 0.000000, 0.000000, 0.000000, 0.279421, 0.570438, 0.904420, 1.360351 },
      { 1.080930, 0.624999, 0.291017, 0.000000, 0.000000, 0.000000, 0.291017, 0.624999, 1.080930 },
      { 1.360351, 0.904420, 0.570438, 0.279421, 0.000000, 0.000000, 0.000000, 0.333982, 0.789913 },
      { 1.651368, 1.195437, 0.861455, 0.570438, 0.291017, 0.000000, 0.000000, 0.000000, 0.455931 },
      { 1.985350, 1.529419, 1.195437, 0.904420, 0.624999, 0.333982, 0.000000, 0.000000, 0.000000 },
      { 2.441281, 1.985350, 1.651368, 1.360351, 1.080930, 0.789913, 0.455931, 0.000000, 0.000000 } };

  private static final double[][] distance_case10 = {
      { 0.000000, 0.000000, 0.439930, 0.757151, 1.028204, 1.281552, 1.534899, 1.805952, 2.123173,
          2.563103 },
      { 0.000000, 0.000000, 0.000000, 0.317221, 0.588274, 0.841621, 1.094968, 1.366022, 1.683242,
          2.123173 },
      { 0.439930, 0.000000, 0.000000, 0.000000, 0.271053, 0.524401, 0.777748, 1.048801, 1.366022,
          1.805952 },
      { 0.757151, 0.317221, 0.000000, 0.000000, 0.000000, 0.253347, 0.506694, 0.777748, 1.094968,
          1.534899 },
      { 1.028204, 0.588274, 0.271053, 0.000000, 0.000000, 0.000000, 0.253347, 0.524401, 0.841621,
          1.281552 },
      { 1.281552, 0.841621, 0.524401, 0.253347, 0.000000, 0.000000, 0.000000, 0.271053, 0.588274,
          1.028204 },
      { 1.534899, 1.094968, 0.777748, 0.506694, 0.253347, 0.000000, 0.000000, 0.000000, 0.317221,
          0.757151 },
      { 1.805952, 1.366022, 1.048801, 0.777748, 0.524401, 0.271053, 0.000000, 0.000000, 0.000000,
          0.439930 },
      { 2.123173, 1.683242, 1.366022, 1.094968, 0.841621, 0.588274, 0.317221, 0.000000, 0.000000,
          0.000000 },
      { 2.563103, 2.123173, 1.805952, 1.534899, 1.281552, 1.028204, 0.757151, 0.439930, 0.000000,
          0.000000 } };

  private static final double[][] distance_case11 = {
      { 0.000000, 0.000000, 0.426720, 0.730592, 0.986422, 1.220992, 1.449363, 1.683933, 1.939763,
          2.243636, 2.670355 },
      { 0.000000, 0.000000, 0.000000, 0.303873, 0.559702, 0.794273, 1.022643, 1.257214, 1.513043,
          1.816916, 2.243636 },
      { 0.426720, 0.000000, 0.000000, 0.000000, 0.255830, 0.490400, 0.718771, 0.953341, 1.209171,
          1.513043, 1.939763 },
      { 0.730592, 0.303873, 0.000000, 0.000000, 0.000000, 0.234570, 0.462941, 0.697511, 0.953341,
          1.257214, 1.683933 },
      { 0.986422, 0.559702, 0.255830, 0.000000, 0.000000, 0.000000, 0.228371, 0.462941, 0.718771,
          1.022643, 1.449363 },
      { 1.220992, 0.794273, 0.490400, 0.234570, 0.000000, 0.000000, 0.000000, 0.234570, 0.490400,
          0.794273, 1.220992 },
      { 1.449363, 1.022643, 0.718771, 0.462941, 0.228371, 0.000000, 0.000000, 0.000000, 0.255830,
          0.559702, 0.986422 },
      { 1.683933, 1.257214, 0.953341, 0.697511, 0.462941, 0.234570, 0.000000, 0.000000, 0.000000,
          0.303873, 0.730592 },
      { 1.939763, 1.513043, 1.209171, 0.953341, 0.718771, 0.490400, 0.255830, 0.000000, 0.000000,
          0.000000, 0.426720 },
      { 2.243636, 1.816916, 1.513043, 1.257214, 1.022643, 0.794273, 0.559702, 0.303873, 0.000000,
          0.000000, 0.000000 },
      { 2.670355, 2.243636, 1.939763, 1.683933, 1.449363, 1.220992, 0.986422, 0.730592, 0.426720,
          0.000000, 0.000000 } };

  private static final double[][] distance_case12 = {
      { 0.000000, 0.000000, 0.415573, 0.708504, 0.952267, 1.172566, 1.382994, 1.593423, 1.813721,
          2.057484, 2.350416, 2.765988 },
      { 0.000000, 0.000000, 0.000000, 0.292932, 0.536694, 0.756993, 0.967422, 1.177850, 1.398149,
          1.641911, 1.934843, 2.350416 },
      { 0.415573, 0.000000, 0.000000, 0.000000, 0.243762, 0.464061, 0.674490, 0.884918, 1.105217,
          1.348980, 1.641911, 2.057484 },
      { 0.708504, 0.292932, 0.000000, 0.000000, 0.000000, 0.220299, 0.430727, 0.641156, 0.861455,
          1.105217, 1.398149, 1.813721 },
      { 0.952267, 0.536694, 0.243762, 0.000000, 0.000000, 0.000000, 0.210428, 0.420857, 0.641156,
          0.884918, 1.177850, 1.593423 },
      { 1.172566, 0.756993, 0.464061, 0.220299, 0.000000, 0.000000, 0.000000, 0.210428, 0.430727,
          0.674490, 0.967422, 1.382994 },
      { 1.382994, 0.967422, 0.674490, 0.430727, 0.210428, 0.000000, 0.000000, 0.000000, 0.220299,
          0.464061, 0.756993, 1.172566 },
      { 1.593423, 1.177850, 0.884918, 0.641156, 0.420857, 0.210428, 0.000000, 0.000000, 0.000000,
          0.243762, 0.536694, 0.952267 },
      { 1.813721, 1.398149, 1.105217, 0.861455, 0.641156, 0.430727, 0.220299, 0.000000, 0.000000,
          0.000000, 0.292932, 0.708504 },
      { 2.057484, 1.641911, 1.348980, 1.105217, 0.884918, 0.674490, 0.464061, 0.243762, 0.000000,
          0.000000, 0.000000, 0.415573 },
      { 2.350416, 1.934843, 1.641911, 1.398149, 1.177850, 0.967422, 0.756993, 0.536694, 0.292932,
          0.000000, 0.000000, 0.000000 },
      { 2.765988, 2.350416, 2.057484, 1.813721, 1.593423, 1.382994, 1.172566, 0.952267, 0.708504,
          0.415573, 0.000000, 0.000000 } };

  private static final double[][] distance_case13 = {
      { 0.000000, 0.000000, 0.406001, 0.689761, 0.923675, 1.132696, 1.329518, 1.522635, 1.719458,
          1.928479, 2.162393, 2.446153, 2.852154 },
      { 0.000000, 0.000000, 0.000000, 0.283760, 0.517674, 0.726695, 0.923518, 1.116635, 1.313457,
          1.522478, 1.756392, 2.040152, 2.446153 },
      { 0.406001, 0.000000, 0.000000, 0.000000, 0.233914, 0.442935, 0.639757, 0.832875, 1.029697,
          1.238718, 1.472632, 1.756392, 2.162393 },
      { 0.689761, 0.283760, 0.000000, 0.000000, 0.000000, 0.209021, 0.405844, 0.598961, 0.795783,
          1.004804, 1.238718, 1.522478, 1.928479 },
      { 0.923675, 0.517674, 0.233914, 0.000000, 0.000000, 0.000000, 0.196823, 0.389940, 0.586762,
          0.795783, 1.029697, 1.313457, 1.719458 },
      { 1.132696, 0.726695, 0.442935, 0.209021, 0.000000, 0.000000, 0.000000, 0.193117, 0.389940,
          0.598961, 0.832875, 1.116635, 1.522635 },
      { 1.329518, 0.923518, 0.639757, 0.405844, 0.196823, 0.000000, 0.000000, 0.000000, 0.196823,
          0.405844, 0.639757, 0.923518, 1.329518 },
      { 1.522635, 1.116635, 0.832875, 0.598961, 0.389940, 0.193117, 0.000000, 0.000000, 0.000000,
          0.209021, 0.442935, 0.726695, 1.132696 },
      { 1.719458, 1.313457, 1.029697, 0.795783, 0.586762, 0.389940, 0.196823, 0.000000, 0.000000,
          0.000000, 0.233914, 0.517674, 0.923675 },
      { 1.928479, 1.522478, 1.238718, 1.004804, 0.795783, 0.598961, 0.405844, 0.209021, 0.000000,
          0.000000, 0.000000, 0.283760, 0.689761 },
      { 2.162393, 1.756392, 1.472632, 1.238718, 1.029697, 0.832875, 0.639757, 0.442935, 0.233914,
          0.000000, 0.000000, 0.000000, 0.406001 },
      { 2.446153, 2.040152, 1.756392, 1.522478, 1.313457, 1.116635, 0.923518, 0.726695, 0.517674,
          0.283760, 0.000000, 0.000000, 0.000000 },
      { 2.852154, 2.446153, 2.162393, 1.928479, 1.719458, 1.522635, 1.329518, 1.132696, 0.923675,
          0.689761, 0.406001, 0.000000, 0.000000 } };

  private static final double[][] distance_case14 = {
      { 0.000000, 0.000000, 0.397663, 0.673595, 0.899285, 1.099127, 1.285221, 1.465234, 1.645246,
          1.831340, 2.031183, 2.256872, 2.532804, 2.930468 },
      { 0.000000, 0.000000, 0.000000, 0.275932, 0.501622, 0.701464, 0.887558, 1.067571, 1.247583,
          1.433677, 1.633519, 1.859209, 2.135141, 2.532804 },
      { 0.397663, 0.000000, 0.000000, 0.000000, 0.225690, 0.425532, 0.611626, 0.791639, 0.971651,
          1.157745, 1.357587, 1.583277, 1.859209, 2.256872 },
      { 0.673595, 0.275932, 0.000000, 0.000000, 0.000000, 0.199842, 0.385936, 0.565949, 0.745961,
          0.932055, 1.131898, 1.357587, 1.633519, 2.031183 },
      { 0.899285, 0.501622, 0.225690, 0.000000, 0.000000, 0.000000, 0.186094, 0.366106, 0.546119,
          0.732213, 0.932055, 1.157745, 1.433677, 1.831340 },
      { 1.099127, 0.701464, 0.425532, 0.199842, 0.000000, 0.000000, 0.000000, 0.180012, 0.360025,
          0.546119, 0.745961, 0.971651, 1.247583, 1.645246 },
      { 1.285221, 0.887558, 0.611626, 0.385936, 0.186094, 0.000000, 0.000000, 0.000000, 0.180012,
          0.366106, 0.565949, 0.791639, 1.067571, 1.465234 },
      { 1.465234, 1.067571, 0.791639, 0.565949, 0.366106, 0.180012, 0.000000, 0.000000, 0.000000,
          0.186094, 0.385936, 0.611626, 0.887558, 1.285221 },
      { 1.645246, 1.247583, 0.971651, 0.745961, 0.546119, 0.360025, 0.180012, 0.000000, 0.000000,
          0.000000, 0.199842, 0.425532, 0.701464, 1.099127 },
      { 1.831340, 1.433677, 1.157745, 0.932055, 0.732213, 0.546119, 0.366106, 0.186094, 0.000000,
          0.000000, 0.000000, 0.225690, 0.501622, 0.899285 },
      { 2.031183, 1.633519, 1.357587, 1.131898, 0.932055, 0.745961, 0.565949, 0.385936, 0.199842,
          0.000000, 0.000000, 0.000000, 0.275932, 0.673595 },
      { 2.256872, 1.859209, 1.583277, 1.357587, 1.157745, 0.971651, 0.791639, 0.611626, 0.425532,
          0.225690, 0.000000, 0.000000, 0.000000, 0.397663 },
      { 2.532804, 2.135141, 1.859209, 1.633519, 1.433677, 1.247583, 1.067571, 0.887558, 0.701464,
          0.501622, 0.275932, 0.000000, 0.000000, 0.000000 },
      { 2.930468, 2.532804, 2.256872, 2.031183, 1.831340, 1.645246, 1.465234, 1.285221, 1.099127,
          0.899285, 0.673595, 0.397663, 0.000000, 0.000000 } };

  private static final double[][] distance_case15 = {
      { 0.000000, 0.000000, 0.390314, 0.659465, 0.878160, 1.070359, 1.247739, 1.417434, 1.584738,
          1.754433, 1.931813, 2.124012, 2.342707, 2.611858, 3.002172 },
      { 0.000000, 0.000000, 0.000000, 0.269150, 0.487846, 0.680044, 0.857425, 1.027120, 1.194423,
          1.364119, 1.541499, 1.733697, 1.952393, 2.221543, 2.611858 },
      { 0.390314, 0.000000, 0.000000, 0.000000, 0.218696, 0.410894, 0.588274, 0.757969, 0.925273,
          1.094968, 1.272349, 1.464547, 1.683242, 1.952393, 2.342707 },
      { 0.659465, 0.269150, 0.000000, 0.000000, 0.000000, 0.192198, 0.369579, 0.539274, 0.706577,
          0.876273, 1.053653, 1.245851, 1.464547, 1.733697, 2.124012 },
      { 0.878160, 0.487846, 0.218696, 0.000000, 0.000000, 0.000000, 0.177380, 0.347076, 0.514379,
          0.684074, 0.861455, 1.053653, 1.272349, 1.541499, 1.931813 },
      { 1.070359, 0.680044, 0.410894, 0.192198, 0.000000, 0.000000, 0.000000, 0.169695, 0.336999,
          0.506694, 0.684074, 0.876273, 1.094968, 1.364119, 1.754433 },
      { 1.247739, 0.857425, 0.588274, 0.369579, 0.177380, 0.000000, 0.000000, 0.000000, 0.167303,
          0.336999, 0.514379, 0.706577, 0.925273, 1.194423, 1.584738 },
      { 1.417434, 1.027120, 0.757969, 0.539274, 0.347076, 0.169695, 0.000000, 0.000000, 0.000000,
          0.169695, 0.347076, 0.539274, 0.757969, 1.027120, 1.417434 },
      { 1.584738, 1.194423, 0.925273, 0.706577, 0.514379, 0.336999, 0.167303, 0.000000, 0.000000,
          0.000000, 0.177380, 0.369579, 0.588274, 0.857425, 1.247739 },
      { 1.754433, 1.364119, 1.094968, 0.876273, 0.684074, 0.506694, 0.336999, 0.169695, 0.000000,
          0.000000, 0.000000, 0.192198, 0.410894, 0.680044, 1.070359 },
      { 1.931813, 1.541499, 1.272349, 1.053653, 0.861455, 0.684074, 0.514379, 0.347076, 0.177380,
          0.000000, 0.000000, 0.000000, 0.218696, 0.487846, 0.878160 },
      { 2.124012, 1.733697, 1.464547, 1.245851, 1.053653, 0.876273, 0.706577, 0.539274, 0.369579,
          0.192198, 0.000000, 0.000000, 0.000000, 0.269150, 0.659465 },
      { 2.342707, 1.952393, 1.683242, 1.464547, 1.272349, 1.094968, 0.925273, 0.757969, 0.588274,
          0.410894, 0.218696, 0.000000, 0.000000, 0.000000, 0.390314 },
      { 2.611858, 2.221543, 1.952393, 1.733697, 1.541499, 1.364119, 1.194423, 1.027120, 0.857425,
          0.680044, 0.487846, 0.269150, 0.000000, 0.000000, 0.000000 },
      { 3.002172, 2.611858, 2.342707, 2.124012, 1.931813, 1.754433, 1.584738, 1.417434, 1.247739,
          1.070359, 0.878160, 0.659465, 0.390314, 0.000000, 0.000000 } };

  private static final double[][] distance_case16 = {
      { 0.000000, 0.000000, 0.383771, 0.646974, 0.859631, 1.045344, 1.215481, 1.376810, 1.534121,
          1.691431, 1.852760, 2.022897, 2.208610, 2.421267, 2.684470, 3.068241 },
      { 0.000000, 0.000000, 0.000000, 0.263203, 0.475860, 0.661573, 0.831710, 0.993039, 1.150349,
          1.307660, 1.468989, 1.639126, 1.824839, 2.037496, 2.300699, 2.684470 },
      { 0.383771, 0.000000, 0.000000, 0.000000, 0.212657, 0.398370, 0.568507, 0.729836, 0.887147,
          1.044457, 1.205786, 1.375923, 1.561636, 1.774293, 2.037496, 2.421267 },
      { 0.646974, 0.263203, 0.000000, 0.000000, 0.000000, 0.185713, 0.355850, 0.517179, 0.674490,
          0.831800, 0.993129, 1.163266, 1.348980, 1.561636, 1.824839, 2.208610 },
      { 0.859631, 0.475860, 0.212657, 0.000000, 0.000000, 0.000000, 0.170137, 0.331466, 0.488776,
          0.646087, 0.807416, 0.977553, 1.163266, 1.375923, 1.639126, 2.022897 },
      { 1.045344, 0.661573, 0.398370, 0.185713, 0.000000, 0.000000, 0.000000, 0.161329, 0.318639,
          0.475950, 0.637279, 0.807416, 0.993129, 1.205786, 1.468989, 1.852760 },
      { 1.215481, 0.831710, 0.568507, 0.355850, 0.170137, 0.000000, 0.000000, 0.000000, 0.157311,
          0.314621, 0.475950, 0.646087, 0.831800, 1.044457, 1.307660, 1.691431 },
      { 1.376810, 0.993039, 0.729836, 0.517179, 0.331466, 0.161329, 0.000000, 0.000000, 0.000000,
          0.157311, 0.318639, 0.488776, 0.674490, 0.887147, 1.150349, 1.534121 },
      { 1.534121, 1.150349, 0.887147, 0.674490, 0.488776, 0.318639, 0.157311, 0.000000, 0.000000,
          0.000000, 0.161329, 0.331466, 0.517179, 0.729836, 0.993039, 1.376810 },
      { 1.691431, 1.307660, 1.044457, 0.831800, 0.646087, 0.475950, 0.314621, 0.157311, 0.000000,
          0.000000, 0.000000, 0.170137, 0.355850, 0.568507, 0.831710, 1.215481 },
      { 1.852760, 1.468989, 1.205786, 0.993129, 0.807416, 0.637279, 0.475950, 0.318639, 0.161329,
          0.000000, 0.000000, 0.000000, 0.185713, 0.398370, 0.661573, 1.045344 },
      { 2.022897, 1.639126, 1.375923, 1.163266, 0.977553, 0.807416, 0.646087, 0.488776, 0.331466,
          0.170137, 0.000000, 0.000000, 0.000000, 0.212657, 0.475860, 0.859631 },
      { 2.208610, 1.824839, 1.561636, 1.348980, 1.163266, 0.993129, 0.831800, 0.674490, 0.517179,
          0.355850, 0.185713, 0.000000, 0.000000, 0.000000, 0.263203, 0.646974 },
      { 2.421267, 2.037496, 1.774293, 1.561636, 1.375923, 1.205786, 1.044457, 0.887147, 0.729836,
          0.568507, 0.398370, 0.212657, 0.000000, 0.000000, 0.000000, 0.383771 },
      { 2.684470, 2.300699, 2.037496, 1.824839, 1.639126, 1.468989, 1.307660, 1.150349, 0.993039,
          0.831710, 0.661573, 0.475860, 0.263203, 0.000000, 0.000000, 0.000000 },
      { 3.068241, 2.684470, 2.421267, 2.208610, 2.022897, 1.852760, 1.691431, 1.534121, 1.376810,
          1.215481, 1.045344, 0.859631, 0.646974, 0.383771, 0.000000, 0.000000 } };

  private static final double[][] distance_case17 = {
      { 0.000000, 0.000000, 0.377895, 0.635827, 0.843204, 1.023331, 1.187335, 1.341719, 1.490935,
          1.638518, 1.787734, 1.942118, 2.106122, 2.286249, 2.493626, 2.751558, 3.129453 },
      { 0.000000, 0.000000, 0.000000, 0.257932, 0.465309, 0.645436, 0.809439, 0.963824, 1.113040,
          1.260623, 1.409839, 1.564223, 1.728227, 1.908354, 2.115731, 2.373663, 2.751558 },
      { 0.377895, 0.000000, 0.000000, 0.000000, 0.207377, 0.387504, 0.551508, 0.705892, 0.855108,
          1.002691, 1.151907, 1.306291, 1.470295, 1.650422, 1.857799, 2.115731, 2.493626 },
      { 0.635827, 0.257932, 0.000000, 0.000000, 0.000000, 0.180127, 0.344130, 0.498514, 0.647731,
          0.795314, 0.944530, 1.098914, 1.262917, 1.443045, 1.650422, 1.908354, 2.286249 },
      { 0.843204, 0.465309, 0.207377, 0.000000, 0.000000, 0.000000, 0.164003, 0.318387, 0.467604,
          0.615186, 0.764403, 0.918787, 1.082790, 1.262917, 1.470295, 1.728227, 2.106122 },
      { 1.023331, 0.645436, 0.387504, 0.180127, 0.000000, 0.000000, 0.000000, 0.154384, 0.303601,
          0.451183, 0.600400, 0.754784, 0.918787, 1.098914, 1.306291, 1.564223, 1.942118 },
      { 1.187335, 0.809439, 0.551508, 0.344130, 0.164003, 0.000000, 0.000000, 0.000000, 0.149217,
          0.296799, 0.446016, 0.600400, 0.764403, 0.944530, 1.151907, 1.409839, 1.787734 },
      { 1.341719, 0.963824, 0.705892, 0.498514, 0.318387, 0.154384, 0.000000, 0.000000, 0.000000,
          0.147583, 0.296799, 0.451183, 0.615186, 0.795314, 1.002691, 1.260623, 1.638518 },
      { 1.490935, 1.113040, 0.855108, 0.647731, 0.467604, 0.303601, 0.149217, 0.000000, 0.000000,
          0.000000, 0.149217, 0.303601, 0.467604, 0.647731, 0.855108, 1.113040, 1.490935 },
      { 1.638518, 1.260623, 1.002691, 0.795314, 0.615186, 0.451183, 0.296799, 0.147583, 0.000000,
          0.000000, 0.000000, 0.154384, 0.318387, 0.498514, 0.705892, 0.963824, 1.341719 },
      { 1.787734, 1.409839, 1.151907, 0.944530, 0.764403, 0.600400, 0.446016, 0.296799, 0.149217,
          0.000000, 0.000000, 0.000000, 0.164003, 0.344130, 0.551508, 0.809439, 1.187335 },
      { 1.942118, 1.564223, 1.306291, 1.098914, 0.918787, 0.754784, 0.600400, 0.451183, 0.303601,
          0.154384, 0.000000, 0.000000, 0.000000, 0.180127, 0.387504, 0.645436, 1.023331 },
      { 2.106122, 1.728227, 1.470295, 1.262917, 1.082790, 0.918787, 0.764403, 0.615186, 0.467604,
          0.318387, 0.164003, 0.000000, 0.000000, 0.000000, 0.207377, 0.465309, 0.843204 },
      { 2.286249, 1.908354, 1.650422, 1.443045, 1.262917, 1.098914, 0.944530, 0.795314, 0.647731,
          0.498514, 0.344130, 0.180127, 0.000000, 0.000000, 0.000000, 0.257932, 0.635827 },
      { 2.493626, 2.115731, 1.857799, 1.650422, 1.470295, 1.306291, 1.151907, 1.002691, 0.855108,
          0.705892, 0.551508, 0.387504, 0.207377, 0.000000, 0.000000, 0.000000, 0.377895 },
      { 2.751558, 2.373663, 2.115731, 1.908354, 1.728227, 1.564223, 1.409839, 1.260623, 1.113040,
          0.963824, 0.809439, 0.645436, 0.465309, 0.257932, 0.000000, 0.000000, 0.000000 },
      { 3.129453, 2.751558, 2.493626, 2.286249, 2.106122, 1.942118, 1.787734, 1.638518, 1.490935,
          1.341719, 1.187335, 1.023331, 0.843204, 0.635827, 0.377895, 0.000000, 0.000000 } };

  private static final double[][] distance_case18 = {
      { 0.000000, 0.000000, 0.372578, 0.625797, 0.828509, 1.003763, 1.162492, 1.311003, 1.453509,
          1.593219, 1.732929, 1.875435, 2.023946, 2.182675, 2.357928, 2.560640, 2.813859, 3.186438 },
      { 0.000000, 0.000000, 0.000000, 0.253219, 0.455931, 0.631185, 0.789913, 0.938424, 1.080930,
          1.220640, 1.360351, 1.502856, 1.651368, 1.810096, 1.985350, 2.188062, 2.441281, 2.813859 },
      { 0.372578, 0.000000, 0.000000, 0.000000, 0.202712, 0.377966, 0.536694, 0.685205, 0.827711,
          0.967422, 1.107132, 1.249638, 1.398149, 1.556877, 1.732131, 1.934843, 2.188062, 2.560640 },
      { 0.625797, 0.253219, 0.000000, 0.000000, 0.000000, 0.175254, 0.333982, 0.482494, 0.624999,
          0.764710, 0.904420, 1.046926, 1.195437, 1.354165, 1.529419, 1.732131, 1.985350, 2.357928 },
      { 0.828509, 0.455931, 0.202712, 0.000000, 0.000000, 0.000000, 0.158728, 0.307240, 0.449745,
          0.589456, 0.729166, 0.871672, 1.020183, 1.178912, 1.354165, 1.556877, 1.810096, 2.182675 },
      { 1.003763, 0.631185, 0.377966, 0.175254, 0.000000, 0.000000, 0.000000, 0.148511, 0.291017,
          0.430727, 0.570438, 0.712943, 0.861455, 1.020183, 1.195437, 1.398149, 1.651368, 2.023946 },
      { 1.162492, 0.789913, 0.536694, 0.333982, 0.158728, 0.000000, 0.000000, 0.000000, 0.142506,
          0.282216, 0.421926, 0.564432, 0.712943, 0.871672, 1.046926, 1.249638, 1.502856, 1.875435 },
      { 1.311003, 0.938424, 0.685205, 0.482494, 0.307240, 0.148511, 0.000000, 0.000000, 0.000000,
          0.139710, 0.279421, 0.421926, 0.570438, 0.729166, 0.904420, 1.107132, 1.360351, 1.732929 },
      { 1.453509, 1.080930, 0.827711, 0.624999, 0.449745, 0.291017, 0.142506, 0.000000, 0.000000,
          0.000000, 0.139710, 0.282216, 0.430727, 0.589456, 0.764710, 0.967422, 1.220640, 1.593219 },
      { 1.593219, 1.220640, 0.967422, 0.764710, 0.589456, 0.430727, 0.282216, 0.139710, 0.000000,
          0.000000, 0.000000, 0.142506, 0.291017, 0.449745, 0.624999, 0.827711, 1.080930, 1.453509 },
      { 1.732929, 1.360351, 1.107132, 0.904420, 0.729166, 0.570438, 0.421926, 0.279421, 0.139710,
          0.000000, 0.000000, 0.000000, 0.148511, 0.307240, 0.482494, 0.685205, 0.938424, 1.311003 },
      { 1.875435, 1.502856, 1.249638, 1.046926, 0.871672, 0.712943, 0.564432, 0.421926, 0.282216,
          0.142506, 0.000000, 0.000000, 0.000000, 0.158728, 0.333982, 0.536694, 0.789913, 1.162492 },
      { 2.023946, 1.651368, 1.398149, 1.195437, 1.020183, 0.861455, 0.712943, 0.570438, 0.430727,
          0.291017, 0.148511, 0.000000, 0.000000, 0.000000, 0.175254, 0.377966, 0.631185, 1.003763 },
      { 2.182675, 1.810096, 1.556877, 1.354165, 1.178912, 1.020183, 0.871672, 0.729166, 0.589456,
          0.449745, 0.307240, 0.158728, 0.000000, 0.000000, 0.000000, 0.202712, 0.455931, 0.828509 },
      { 2.357928, 1.985350, 1.732131, 1.529419, 1.354165, 1.195437, 1.046926, 0.904420, 0.764710,
          0.624999, 0.482494, 0.333982, 0.175254, 0.000000, 0.000000, 0.000000, 0.253219, 0.625797 },
      { 2.560640, 2.188062, 1.934843, 1.732131, 1.556877, 1.398149, 1.249638, 1.107132, 0.967422,
          0.827711, 0.685205, 0.536694, 0.377966, 0.202712, 0.000000, 0.000000, 0.000000, 0.372578 },
      { 2.813859, 2.441281, 2.188062, 1.985350, 1.810096, 1.651368, 1.502856, 1.360351, 1.220640,
          1.080930, 0.938424, 0.789913, 0.631185, 0.455931, 0.253219, 0.000000, 0.000000, 0.000000 },
      { 3.186438, 2.813859, 2.560640, 2.357928, 2.182675, 2.023946, 1.875435, 1.732929, 1.593219,
          1.453509, 1.311003, 1.162492, 1.003763, 0.828509, 0.625797, 0.372578, 0.000000, 0.000000 } };

  private static final double[][] distance_case19 = {
      { 0.000000, 0.000000, 0.367737, 0.616708, 0.815260, 0.986216, 1.140351, 1.283818, 1.420655,
          1.553844, 1.685868, 1.819058, 1.955894, 2.099362, 2.253496, 2.424453, 2.623004, 2.871976,
          3.239713 },
      { 0.000000, 0.000000, 0.000000, 0.248972, 0.447523, 0.618480, 0.772614, 0.916081, 1.052918,
          1.186108, 1.318131, 1.451321, 1.588158, 1.731625, 1.885760, 2.056716, 2.255267, 2.504239,
          2.871976 },
      { 0.367737, 0.000000, 0.000000, 0.000000, 0.198552, 0.369508, 0.523642, 0.667110, 0.803947,
          0.937136, 1.069160, 1.202349, 1.339186, 1.482654, 1.636788, 1.807744, 2.006296, 2.255267,
          2.623004 },
      { 0.616708, 0.248972, 0.000000, 0.000000, 0.000000, 0.170956, 0.325091, 0.468558, 0.605395,
          0.738585, 0.870608, 1.003798, 1.140635, 1.284102, 1.438236, 1.609193, 1.807744, 2.056716,
          2.424453 },
      { 0.815260, 0.447523, 0.198552, 0.000000, 0.000000, 0.000000, 0.154134, 0.297602, 0.434439,
          0.567628, 0.699652, 0.832841, 0.969678, 1.113146, 1.267280, 1.438236, 1.636788, 1.885760,
          2.253496 },
      { 0.986216, 0.618480, 0.369508, 0.170956, 0.000000, 0.000000, 0.000000, 0.143468, 0.280304,
          0.413494, 0.545517, 0.678707, 0.815544, 0.959011, 1.113146, 1.284102, 1.482654, 1.731625,
          2.099362 },
      { 1.140351, 0.772614, 0.523642, 0.325091, 0.154134, 0.000000, 0.000000, 0.000000, 0.136837,
          0.270026, 0.402050, 0.535239, 0.672076, 0.815544, 0.969678, 1.140635, 1.339186, 1.588158,
          1.955894 },
      { 1.283818, 0.916081, 0.667110, 0.468558, 0.297602, 0.143468, 0.000000, 0.000000, 0.000000,
          0.133190, 0.265213, 0.398403, 0.535239, 0.678707, 0.832841, 1.003798, 1.202349, 1.451321,
          1.819058 },
      { 1.420655, 1.052918, 0.803947, 0.605395, 0.434439, 0.280304, 0.136837, 0.000000, 0.000000,
          0.000000, 0.132024, 0.265213, 0.402050, 0.545517, 0.699652, 0.870608, 1.069160, 1.318131,
          1.685868 },
      { 1.553844, 1.186108, 0.937136, 0.738585, 0.567628, 0.413494, 0.270026, 0.133190, 0.000000,
          0.000000, 0.000000, 0.133190, 0.270026, 0.413494, 0.567628, 0.738585, 0.937136, 1.186108,
          1.553844 },
      { 1.685868, 1.318131, 1.069160, 0.870608, 0.699652, 0.545517, 0.402050, 0.265213, 0.132024,
          0.000000, 0.000000, 0.000000, 0.136837, 0.280304, 0.434439, 0.605395, 0.803947, 1.052918,
          1.420655 },
      { 1.819058, 1.451321, 1.202349, 1.003798, 0.832841, 0.678707, 0.535239, 0.398403, 0.265213,
          0.133190, 0.000000, 0.000000, 0.000000, 0.143468, 0.297602, 0.468558, 0.667110, 0.916081,
          1.283818 },
      { 1.955894, 1.588158, 1.339186, 1.140635, 0.969678, 0.815544, 0.672076, 0.535239, 0.402050,
          0.270026, 0.136837, 0.000000, 0.000000, 0.000000, 0.154134, 0.325091, 0.523642, 0.772614,
          1.140351 },
      { 2.099362, 1.731625, 1.482654, 1.284102, 1.113146, 0.959011, 0.815544, 0.678707, 0.545517,
          0.413494, 0.280304, 0.143468, 0.000000, 0.000000, 0.000000, 0.170956, 0.369508, 0.618480,
          0.986216 },
      { 2.253496, 1.885760, 1.636788, 1.438236, 1.267280, 1.113146, 0.969678, 0.832841, 0.699652,
          0.567628, 0.434439, 0.297602, 0.154134, 0.000000, 0.000000, 0.000000, 0.198552, 0.447523,
          0.815260 },
      { 2.424453, 2.056716, 1.807744, 1.609193, 1.438236, 1.284102, 1.140635, 1.003798, 0.870608,
          0.738585, 0.605395, 0.468558, 0.325091, 0.170956, 0.000000, 0.000000, 0.000000, 0.248972,
          0.616708 },
      { 2.623004, 2.255267, 2.006296, 1.807744, 1.636788, 1.482654, 1.339186, 1.202349, 1.069160,
          0.937136, 0.803947, 0.667110, 0.523642, 0.369508, 0.198552, 0.000000, 0.000000, 0.000000,
          0.367737 },
      { 2.871976, 2.504239, 2.255267, 2.056716, 1.885760, 1.731625, 1.588158, 1.451321, 1.318131,
          1.186108, 1.052918, 0.916081, 0.772614, 0.618480, 0.447523, 0.248972, 0.000000, 0.000000,
          0.000000 },
      { 3.239713, 2.871976, 2.623004, 2.424453, 2.253496, 2.099362, 1.955894, 1.819058, 1.685868,
          1.553844, 1.420655, 1.283818, 1.140351, 0.986216, 0.815260, 0.616708, 0.367737, 0.000000,
          0.000000 } };

  private static final double[][] distance_case20 = {
      { 0.000000, 0.000000, 0.363302, 0.608420, 0.803232, 0.970364, 1.120453, 1.259533, 1.391507,
          1.519192, 1.644854, 1.770515, 1.898201, 2.030174, 2.169254, 2.319343, 2.486475, 2.681287,
          2.926405, 3.289707 },
      { 0.000000, 0.000000, 0.000000, 0.245118, 0.439930, 0.607062, 0.757151, 0.896231, 1.028204,
          1.155890, 1.281552, 1.407213, 1.534899, 1.666872, 1.805952, 1.956041, 2.123173, 2.317985,
          2.563103, 2.926405 },
      { 0.363302, 0.000000, 0.000000, 0.000000, 0.194812, 0.361944, 0.512033, 0.651113, 0.783086,
          0.910772, 1.036433, 1.162095, 1.289780, 1.421754, 1.560834, 1.710923, 1.878055, 2.072867,
          2.317985, 2.681287 },
      { 0.608420, 0.245118, 0.000000, 0.000000, 0.000000, 0.167131, 0.317221, 0.456301, 0.588274,
          0.715960, 0.841621, 0.967283, 1.094968, 1.226942, 1.366022, 1.516111, 1.683242, 1.878055,
          2.123173, 2.486475 },
      { 0.803232, 0.439930, 0.194812, 0.000000, 0.000000, 0.000000, 0.150089, 0.289169, 0.421143,
          0.548828, 0.674490, 0.800151, 0.927837, 1.059810, 1.198890, 1.348980, 1.516111, 1.710923,
          1.956041, 2.319343 },
      { 0.970364, 0.607062, 0.361944, 0.167131, 0.000000, 0.000000, 0.000000, 0.139080, 0.271053,
          0.398739, 0.524401, 0.650062, 0.777748, 0.909721, 1.048801, 1.198890, 1.366022, 1.560834,
          1.805952, 2.169254 },
      { 1.120453, 0.757151, 0.512033, 0.317221, 0.150089, 0.000000, 0.000000, 0.000000, 0.131973,
          0.259659, 0.385320, 0.510982, 0.638668, 0.770641, 0.909721, 1.059810, 1.226942, 1.421754,
          1.666872, 2.030174 },
      { 1.259533, 0.896231, 0.651113, 0.456301, 0.289169, 0.139080, 0.000000, 0.000000, 0.000000,
          0.127686, 0.253347, 0.379008, 0.506694, 0.638668, 0.777748, 0.927837, 1.094968, 1.289780,
          1.534899, 1.898201 },
      { 1.391507, 1.028204, 0.783086, 0.588274, 0.421143, 0.271053, 0.131973, 0.000000, 0.000000,
          0.000000, 0.125661, 0.251323, 0.379008, 0.510982, 0.650062, 0.800151, 0.967283, 1.162095,
          1.407213, 1.770515 },
      { 1.519192, 1.155890, 0.910772, 0.715960, 0.548828, 0.398739, 0.259659, 0.127686, 0.000000,
          0.000000, 0.000000, 0.125661, 0.253347, 0.385320, 0.524401, 0.674490, 0.841621, 1.036433,
          1.281552, 1.644854 },
      { 1.644854, 1.281552, 1.036433, 0.841621, 0.674490, 0.524401, 0.385320, 0.253347, 0.125661,
          0.000000, 0.000000, 0.000000, 0.127686, 0.259659, 0.398739, 0.548828, 0.715960, 0.910772,
          1.155890, 1.519192 },
      { 1.770515, 1.407213, 1.162095, 0.967283, 0.800151, 0.650062, 0.510982, 0.379008, 0.251323,
          0.125661, 0.000000, 0.000000, 0.000000, 0.131973, 0.271053, 0.421143, 0.588274, 0.783086,
          1.028204, 1.391507 },
      { 1.898201, 1.534899, 1.289780, 1.094968, 0.927837, 0.777748, 0.638668, 0.506694, 0.379008,
          0.253347, 0.127686, 0.000000, 0.000000, 0.000000, 0.139080, 0.289169, 0.456301, 0.651113,
          0.896231, 1.259533 },
      { 2.030174, 1.666872, 1.421754, 1.226942, 1.059810, 0.909721, 0.770641, 0.638668, 0.510982,
          0.385320, 0.259659, 0.131973, 0.000000, 0.000000, 0.000000, 0.150089, 0.317221, 0.512033,
          0.757151, 1.120453 },
      { 2.169254, 1.805952, 1.560834, 1.366022, 1.198890, 1.048801, 0.909721, 0.777748, 0.650062,
          0.524401, 0.398739, 0.271053, 0.139080, 0.000000, 0.000000, 0.000000, 0.167131, 0.361944,
          0.607062, 0.970364 },
      { 2.319343, 1.956041, 1.710923, 1.516111, 1.348980, 1.198890, 1.059810, 0.927837, 0.800151,
          0.674490, 0.548828, 0.421143, 0.289169, 0.150089, 0.000000, 0.000000, 0.000000, 0.194812,
          0.439930, 0.803232 },
      { 2.486475, 2.123173, 1.878055, 1.683242, 1.516111, 1.366022, 1.226942, 1.094968, 0.967283,
          0.841621, 0.715960, 0.588274, 0.456301, 0.317221, 0.167131, 0.000000, 0.000000, 0.000000,
          0.245118, 0.608420 },
      { 2.681287, 2.317985, 2.072867, 1.878055, 1.710923, 1.560834, 1.421754, 1.289780, 1.162095,
          1.036433, 0.910772, 0.783086, 0.651113, 0.512033, 0.361944, 0.194812, 0.000000, 0.000000,
          0.000000, 0.363302 },
      { 2.926405, 2.563103, 2.317985, 2.123173, 1.956041, 1.805952, 1.666872, 1.534899, 1.407213,
          1.281552, 1.155890, 1.028204, 0.896231, 0.757151, 0.607062, 0.439930, 0.245118, 0.000000,
          0.000000, 0.000000 },
      { 3.289707, 2.926405, 2.681287, 2.486475, 2.319343, 2.169254, 2.030174, 1.898201, 1.770515,
          1.644854, 1.519192, 1.391507, 1.259533, 1.120453, 0.970364, 0.803232, 0.608420, 0.363302,
          0.000000, 0.000000 } };

  /**
   * Constructor.
   */
  public NormalAlphabet() {
    super();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public double[] getCuts(Integer size) throws SAXException {
    switch (size) {
    case 2:
      return case2;
    case 3:
      return case3;
    case 4:
      return case4;
    case 5:
      return case5;
    case 6:
      return case6;
    case 7:
      return case7;
    case 8:
      return case8;
    case 9:
      return case9;
    case 10:
      return case10;
    case 11:
      return case11;
    case 12:
      return case12;
    case 13:
      return case13;
    case 14:
      return case14;
    case 15:
      return case15;
    case 16:
      return case16;
    case 17:
      return case17;
    case 18:
      return case18;
    case 19:
      return case19;
    case 20:
      return case20;
    default:
      throw new SAXException("Invalid alphabet size.");
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Integer getMaxSize() {
    return MAX_SIZE;
  }

  @Override
  public double[][] getDistanceMatrix(Integer size) throws SAXException {
    switch (size) {
    case 2:
      return distance_case2;
    case 3:
      return distance_case3;
    case 4:
      return distance_case4;
    case 5:
      return distance_case5;
    case 6:
      return distance_case6;
    case 7:
      return distance_case7;
    case 8:
      return distance_case8;
    case 9:
      return distance_case9;
    case 10:
      return distance_case10;
    case 11:
      return distance_case11;
    case 12:
      return distance_case12;
    case 13:
      return distance_case13;
    case 14:
      return distance_case14;
    case 15:
      return distance_case15;
    case 16:
      return distance_case16;
    case 17:
      return distance_case17;
    case 18:
      return distance_case18;
    case 19:
      return distance_case19;
    case 20:
      return distance_case20;
    default:
      throw new SAXException("Invalid alphabet size.");
    }
  }

}
