/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.sequitur;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import net.seninp.gi.GrammarRuleRecord;
import net.seninp.gi.GrammarRules;
import net.seninp.gi.RuleInterval;
import net.seninp.gi.sequitur.SAXRule;
import net.seninp.gi.sequitur.SAXSymbol;
import net.seninp.gi.sequitur.SAXTerminal;
import net.seninp.gi.util.GIHelper;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.datastructures.SAXRecords;
import org.slf4j.LoggerFactory;

public final class SequiturFactory {
    protected static final String USE_SLIDING_WINDOW_ACTION_KEY = "sliding_window_key";
    private static final double NORMALIZATION_THRESHOLD = 0.5;
    private static final NormalAlphabet normalA = new NormalAlphabet();
    private static TSProcessor tp = new TSProcessor();
    private static SAXProcessor sp = new SAXProcessor();
    private static Logger consoleLogger;
    private static Level LOGGING_LEVEL;

    private SequiturFactory() {
    }

    public static SAXRule runSequitur(String inputString) throws Exception {
        consoleLogger.trace("digesting the string " + inputString);
        SAXRule.numRules = new AtomicInteger(0);
        SAXRule.theRules.clear();
        SAXSymbol.theDigrams.clear();
        SAXSymbol.theSubstituteTable.clear();
        SAXRule resRule = new SAXRule();
        StringTokenizer st = new StringTokenizer(inputString, " ");
        int currentPosition = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            SAXTerminal symbol = new SAXTerminal(token, currentPosition);
            resRule.last().insertAfter(symbol);
            resRule.last().p.check();
            ++currentPosition;
        }
        return resRule;
    }

    public static SAXRule runSequiturWithEditDistanceThreshold(String string, Integer alphabetSize, Integer threshold) throws Exception {
        consoleLogger.trace("digesting the string " + string);
        SAXRule.numRules = new AtomicInteger(0);
        SAXRule.theRules.clear();
        SAXSymbol.theDigrams.clear();
        SAXSymbol.theSubstituteTable.clear();
        SAXRule resRule = new SAXRule();
        StringTokenizer st = new StringTokenizer(string, " ");
        int currentPosition = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (null != alphabetSize && null != threshold) {
                boolean merged = false;
                for (String str : SAXSymbol.theSubstituteTable.keySet()) {
                    double dist = sp.saxMinDist(str.toCharArray(), token.toCharArray(), normalA.getDistanceMatrix(alphabetSize));
                    if (!(dist < (double)threshold.intValue())) continue;
                    merged = true;
                    SAXSymbol.theSubstituteTable.get(str).put(token.substring(0), currentPosition);
                    token = str;
                }
                if (!merged) {
                    SAXSymbol.theSubstituteTable.put(token, new Hashtable());
                }
            }
            SAXTerminal symbol = new SAXTerminal(token, currentPosition);
            resRule.last().insertAfter(symbol);
            resRule.last().p.check();
            ++currentPosition;
            consoleLogger.trace("Current grammar:\n" + SAXRule.printRules());
        }
        return resRule;
    }

    public static ArrayList<RuleInterval> getRulePositionsByRuleNum(int ruleIdx, SAXRule grammar, SAXRecords saxFrequencyData, double[] originalTimeSeries, int saxWindowSize) {
        ArrayList<RuleInterval> resultIntervals = new ArrayList<RuleInterval>();
        GrammarRuleRecord ruleContainer = grammar.getRuleRecords().get(ruleIdx);
        ArrayList saxWordsIndexes = new ArrayList(saxFrequencyData.getAllIndices());
        consoleLogger.trace("Expanded rule: \"" + ruleContainer.getExpandedRuleString() + '\"');
        consoleLogger.trace("Indexes: " + ruleContainer.getOccurrences());
        String[] expandedRuleSplit = ruleContainer.getExpandedRuleString().trim().split(" ");
        for (Integer currentIndex : ruleContainer.getOccurrences()) {
            String extractedStr = "";
            int[] extractedPositions = new int[expandedRuleSplit.length];
            for (int i = 0; i < expandedRuleSplit.length; ++i) {
                consoleLogger.trace("currentIndex " + currentIndex + ", i: " + i);
                extractedStr = extractedStr.concat(" ").concat(String.valueOf(saxFrequencyData.getByIndex(((Integer)saxWordsIndexes.get(currentIndex + i)).intValue()).getPayload()));
                extractedPositions[i] = (Integer)saxWordsIndexes.get(currentIndex + i);
            }
            int start = (Integer)saxWordsIndexes.get(currentIndex);
            int end = -1;
            end = currentIndex + expandedRuleSplit.length >= saxWordsIndexes.size() ? originalTimeSeries.length - 1 : (Integer)saxWordsIndexes.get(currentIndex + expandedRuleSplit.length) - 1 + saxWindowSize;
            resultIntervals.add(new RuleInterval(start, end));
        }
        return resultIntervals;
    }

    public static int[] series2RulesDensity(double[] originalTimeSeries, int saxWindowSize, int saxPaaSize, int saxAlphabetSize) throws Exception, IOException {
        SAXRecords saxFrequencyData = new SAXRecords();
        SAXRule.numRules = new AtomicInteger(0);
        SAXRule.theRules.clear();
        SAXSymbol.theDigrams.clear();
        SAXSymbol.theSubstituteTable.clear();
        SAXRule.arrRuleRecords = new ArrayList();
        SAXRule grammar = new SAXRule();
        String previousString = "";
        int stringPosCounter = 0;
        for (int i = 0; i < originalTimeSeries.length - (saxWindowSize - 1); ++i) {
            double[] subSection = Arrays.copyOfRange(originalTimeSeries, i, i + saxWindowSize);
            subSection = tp.znorm(subSection, 0.5);
            double[] paa = tp.paa(subSection, saxPaaSize);
            char[] currentString = tp.ts2String(paa, normalA.getCuts(Integer.valueOf(saxAlphabetSize)));
            if (!previousString.isEmpty() && previousString.equalsIgnoreCase(String.valueOf(currentString))) continue;
            previousString = String.valueOf(currentString);
            grammar.last().insertAfter(new SAXTerminal(String.valueOf(currentString), stringPosCounter));
            grammar.last().p.check();
            saxFrequencyData.add(currentString, i);
            ++stringPosCounter;
        }
        saxFrequencyData.buildIndex();
        GrammarRules rules = grammar.toGrammarRulesData();
        SequiturFactory.updateRuleIntervals(rules, saxFrequencyData, true, originalTimeSeries, saxWindowSize, saxPaaSize);
        int[] coverageArray = new int[originalTimeSeries.length];
        for (GrammarRuleRecord r : rules) {
            if (0 == r.ruleNumber()) continue;
            ArrayList<RuleInterval> arrPos = r.getRuleIntervals();
            for (RuleInterval saxPos : arrPos) {
                int startPos = saxPos.getStartPos();
                int endPos = saxPos.getEndPos();
                for (int j = startPos; j < endPos; ++j) {
                    coverageArray[j] = coverageArray[j] + 1;
                }
            }
        }
        return coverageArray;
    }

    public static GrammarRules series2SequiturRules(double[] timeseries, int saxWindowSize, int saxPAASize, int saxAlphabetSize, NumerosityReductionStrategy numerosityReductionStrategy, double normalizationThreshold) throws Exception, IOException {
        consoleLogger.debug("Discretizing time series...");
        SAXRecords saxFrequencyData = SequiturFactory.discretize(timeseries, saxWindowSize, saxPAASize, saxAlphabetSize, normalizationThreshold, numerosityReductionStrategy);
        consoleLogger.debug("Inferring the grammar...");
        String saxDisplayString = saxFrequencyData.getSAXString(" ");
        SAXRule.numRules = new AtomicInteger(0);
        SAXRule.theRules.clear();
        SAXSymbol.theDigrams.clear();
        SAXRule grammar = new SAXRule();
        SAXRule.arrRuleRecords = new ArrayList();
        StringTokenizer st = new StringTokenizer(saxDisplayString, " ");
        int currentPosition = 0;
        while (st.hasMoreTokens()) {
            grammar.last().insertAfter(new SAXTerminal(st.nextToken(), currentPosition));
            grammar.last().p.check();
            ++currentPosition;
        }
        consoleLogger.debug("Collecting the grammar rules statistics and expanding the rules...");
        GrammarRules rules = grammar.toGrammarRulesData();
        consoleLogger.debug("Mapping expanded rules to time-series intervals...");
        SequiturFactory.updateRuleIntervals(rules, saxFrequencyData, true, timeseries, saxWindowSize, saxPAASize);
        return rules;
    }

    public static GrammarRules series2RulesWithLog(double[] timeseries, int saxWindowSize, int saxPAASize, int saxAlphabetSize, double normalizationThreshold, String prefix) throws Exception, IOException {
        consoleLogger.debug("Discretizing time series...");
        SAXRecords saxFrequencyData = SequiturFactory.discretize(timeseries, saxWindowSize, saxPAASize, saxAlphabetSize, normalizationThreshold, NumerosityReductionStrategy.EXACT);
        consoleLogger.debug("Inferring the grammar...");
        String saxDisplayString = saxFrequencyData.getSAXString(" ");
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(prefix + "_rules_stat.txt")));
        SAXRule.numRules = new AtomicInteger(0);
        SAXRule.theRules.clear();
        SAXSymbol.theDigrams.clear();
        SAXRule grammar = new SAXRule();
        SAXRule.arrRuleRecords = new ArrayList();
        StringTokenizer st = new StringTokenizer(saxDisplayString, " ");
        int currentPosition = 0;
        while (st.hasMoreTokens()) {
            grammar.last().insertAfter(new SAXTerminal(st.nextToken(), currentPosition));
            grammar.last().p.check();
            bw.write(currentPosition + "," + SAXSymbol.theDigrams.size() + "," + SAXRule.theRules.size() + "\n");
            ++currentPosition;
        }
        bw.close();
        consoleLogger.debug("Collecting the grammar rules statistics and expanding the rules...");
        GrammarRules rules = grammar.toGrammarRulesData();
        consoleLogger.debug("Mapping expanded rules to time-series intervals...");
        SequiturFactory.updateRuleIntervals(rules, saxFrequencyData, true, timeseries, saxWindowSize, saxPAASize);
        return rules;
    }

    public static SAXRecords discretize(double[] timeseries, int saxWindowSize, int saxPAASize, int saxAlphabetSize, double normalizationThreshold, NumerosityReductionStrategy numerosityReductionStrategy) throws Exception {
        SAXRecords saxFrequencyData = new SAXRecords();
        char[] previousString = null;
        for (int i = 0; i < timeseries.length - (saxWindowSize - 1); ++i) {
            double dist;
            double[] subSection = Arrays.copyOfRange(timeseries, i, i + saxWindowSize);
            subSection = tp.znorm(subSection, normalizationThreshold);
            double[] paa = tp.paa(subSection, saxPAASize);
            char[] currentString = tp.ts2String(paa, normalA.getCuts(Integer.valueOf(saxAlphabetSize)));
            if (NumerosityReductionStrategy.EXACT.equals((Object)numerosityReductionStrategy) && Arrays.equals(previousString, currentString) || null != previousString && NumerosityReductionStrategy.MINDIST.equals((Object)numerosityReductionStrategy) && 0.0 == (dist = sp.saxMinDist(previousString, currentString, normalA.getDistanceMatrix(Integer.valueOf(saxAlphabetSize))))) continue;
            previousString = currentString;
            saxFrequencyData.add(currentString, i);
        }
        return saxFrequencyData;
    }

    public static SAXRecords discretizeNoSlidingWindow(double[] timeseries, int saxPAASize, int saxAlphabetSize, double normalizationThreshold) throws Exception {
        SAXRecords saxFrequencyData = new SAXRecords();
        double[] normalizedTS = tp.znorm(timeseries, normalizationThreshold);
        double[] paa = tp.paa(normalizedTS, saxPAASize);
        char[] currentString = tp.ts2String(paa, normalA.getCuts(Integer.valueOf(saxAlphabetSize)));
        for (int i = 0; i < currentString.length; ++i) {
            char c = currentString[i];
            saxFrequencyData.add(String.valueOf(c).toCharArray(), i);
        }
        return saxFrequencyData;
    }

    public static void updateRuleIntervals(GrammarRules rules, SAXRecords saxFrequencyData, boolean slidingWindowOn, double[] originalTimeSeries, int saxWindowSize, int saxPAASize) {
        ArrayList saxWordsIndexes = new ArrayList(saxFrequencyData.getAllIndices());
        for (GrammarRuleRecord ruleContainer : rules) {
            ArrayList<RuleInterval> resultIntervals = new ArrayList<RuleInterval>();
            int expandedRuleLength = SequiturFactory.countSpaces(ruleContainer.getExpandedRuleString());
            int[] lengths = new int[ruleContainer.getOccurrences().size()];
            int lengthCounter = 0;
            for (Integer currentIndex : ruleContainer.getOccurrences()) {
                int startPos = (Integer)saxWordsIndexes.get(currentIndex);
                int endPos = -1;
                if (currentIndex + expandedRuleLength >= saxWordsIndexes.size()) {
                    endPos = originalTimeSeries.length - 1;
                } else if (slidingWindowOn) {
                    endPos = (Integer)saxWordsIndexes.get(currentIndex + expandedRuleLength) + saxWindowSize - 1;
                } else {
                    double step = (double)originalTimeSeries.length / (double)saxPAASize;
                    endPos = Long.valueOf(Math.round((double)startPos + (double)expandedRuleLength * step)).intValue();
                }
                resultIntervals.add(new RuleInterval(startPos, endPos));
                lengths[lengthCounter] = endPos - startPos;
                ++lengthCounter;
            }
            if (0 == ruleContainer.getRuleNumber()) {
                resultIntervals.add(new RuleInterval(0, originalTimeSeries.length - 1));
                lengths = new int[]{originalTimeSeries.length};
            }
            ruleContainer.setRuleIntervals(resultIntervals);
            ruleContainer.setMeanLength((int)GIHelper.mean(lengths));
            ruleContainer.setMinMaxLength(lengths);
        }
    }

    private static int countSpaces(String str) {
        int counter = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            ++counter;
        }
        return counter;
    }

    static {
        LOGGING_LEVEL = Level.INFO;
        consoleLogger = (Logger)LoggerFactory.getLogger(SequiturFactory.class);
        consoleLogger.setLevel(LOGGING_LEVEL);
    }
}

