/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.sequitur;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import net.seninp.gi.GrammarRuleRecord;
import net.seninp.gi.GrammarRules;
import net.seninp.gi.sequitur.SAXGuard;
import net.seninp.gi.sequitur.SAXNonTerminal;
import net.seninp.gi.sequitur.SAXSymbol;

public class SAXRule {
    protected static AtomicInteger numRules = new AtomicInteger(0);
    protected static final ArrayList<SAXRule> theRules = new ArrayList();
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    private static final String CR = "\n";
    protected static ArrayList<GrammarRuleRecord> arrRuleRecords = new ArrayList();
    protected SAXGuard theGuard;
    protected int count;
    protected int ruleIndex;
    protected int index;
    protected int level;
    protected Set<Integer> indexes = new TreeSet<Integer>();

    public SAXRule() {
        this.ruleIndex = numRules.intValue();
        numRules.incrementAndGet();
        this.theGuard = new SAXGuard(this);
        this.count = 0;
        this.index = 0;
        this.level = 0;
        theRules.add(this);
    }

    public SAXSymbol first() {
        return this.theGuard.n;
    }

    public SAXSymbol last() {
        return this.theGuard.p;
    }

    protected void assignLevel() {
        int lvl = Integer.MAX_VALUE;
        SAXSymbol sym = this.first();
        while (!sym.isGuard()) {
            if (!sym.isNonTerminal()) {
                this.level = 1;
                return;
            }
            SAXRule referedTo = ((SAXNonTerminal)sym).r;
            lvl = Math.min(referedTo.level + 1, lvl);
            sym = sym.n;
        }
        this.level = lvl;
    }

    public int getLevel() {
        return this.level;
    }

    private static void expandRules() {
        GrammarRuleRecord ruleRecord2;
        for (GrammarRuleRecord ruleRecord2 : arrRuleRecords) {
            String[] split;
            if (ruleRecord2.getRuleNumber() == 0) continue;
            String curString = ruleRecord2.getRuleString();
            StringBuilder resultString = new StringBuilder(8192);
            for (String s : split = curString.split(SPACE)) {
                if (s.startsWith("R")) {
                    resultString.append(SPACE).append(SAXRule.expandRule(Integer.valueOf(s.substring(1, s.length()))));
                    continue;
                }
                resultString.append(SPACE).append(s);
            }
            String rr = resultString.delete(0, 1).append(SPACE).toString();
            ruleRecord2.setExpandedRuleString(rr);
            ruleRecord2.setRuleYield(SAXRule.countSpaces(rr));
        }
        StringBuilder resultString = new StringBuilder(8192);
        ruleRecord2 = arrRuleRecords.get(0);
        resultString.append(ruleRecord2.getRuleString());
        int currentSearchStart = resultString.indexOf("R");
        while (currentSearchStart >= 0) {
            int spaceIdx = resultString.indexOf(SPACE, currentSearchStart);
            String ruleName = resultString.substring(currentSearchStart, spaceIdx + 1);
            Integer ruleId = Integer.valueOf(ruleName.substring(1, ruleName.length() - 1));
            resultString.replace(spaceIdx - ruleName.length() + 1, spaceIdx + 1, arrRuleRecords.get(ruleId).getExpandedRuleString());
            currentSearchStart = resultString.indexOf("R");
        }
        ruleRecord2.setExpandedRuleString(resultString.toString().trim());
    }

    private static String expandRule(Integer ruleNum) {
        String[] split;
        GrammarRuleRecord rr = arrRuleRecords.get(ruleNum);
        String curString = rr.getRuleString();
        StringBuilder resultString = new StringBuilder();
        for (String s : split = curString.split(SPACE)) {
            if (s.startsWith("R")) {
                resultString.append(SPACE).append(SAXRule.expandRule(Integer.valueOf(s.substring(1, s.length()))));
                continue;
            }
            resultString.append(SPACE).append(s);
        }
        String res = resultString.delete(0, 1).append(SPACE).toString();
        rr.setExpandedRuleString(res);
        return resultString.delete(resultString.length() - 1, resultString.length()).toString();
    }

    private static int countSpaces(String str) {
        int counter = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            ++counter;
        }
        return counter;
    }

    public ArrayList<GrammarRuleRecord> getRuleRecords() {
        return arrRuleRecords;
    }

    public void addIndex(int position) {
        this.indexes.add(position);
    }

    private int[] getIndexes() {
        int[] res = new int[this.indexes.size()];
        int i = 0;
        for (Integer idx : this.indexes) {
            res[i] = idx;
            ++i;
        }
        return res;
    }

    protected void getSAXRules() {
        arrRuleRecords = new ArrayList();
        Vector<SAXRule> rules = new Vector<SAXRule>(numRules.intValue());
        rules.addElement(this);
        StringBuilder sbCurrentRule = new StringBuilder();
        for (int processedRules = 0; processedRules < rules.size(); ++processedRules) {
            SAXRule currentRule = (SAXRule)rules.elementAt(processedRules);
            SAXSymbol sym = currentRule.first();
            while (!sym.isGuard()) {
                if (sym.isNonTerminal()) {
                    SAXRule referedTo = ((SAXNonTerminal)sym).r;
                    if (rules.size() > referedTo.index && rules.elementAt(referedTo.index) == referedTo) {
                        this.index = referedTo.index;
                    } else {
                        referedTo.index = this.index = rules.size();
                        rules.addElement(referedTo);
                    }
                    sbCurrentRule.append('R');
                    sbCurrentRule.append(this.index);
                } else {
                    sbCurrentRule.append(sym.value);
                }
                sbCurrentRule.append(' ');
                sym = sym.n;
            }
            GrammarRuleRecord ruleConteiner = new GrammarRuleRecord();
            ruleConteiner.setRuleNumber(processedRules);
            ruleConteiner.setRuleString(sbCurrentRule.toString());
            ruleConteiner.setRuleLevel(currentRule.getLevel());
            ruleConteiner.setRuleUseFrequency(currentRule.count);
            ruleConteiner.setOccurrences(currentRule.getIndexes());
            arrRuleRecords.add(ruleConteiner);
            sbCurrentRule = new StringBuilder();
        }
    }

    public GrammarRules toGrammarRulesData() {
        this.getSAXRules();
        SAXRule.expandRules();
        GrammarRules res = new GrammarRules();
        for (GrammarRuleRecord arrRule : arrRuleRecords) {
            res.addRule(arrRule);
        }
        return res;
    }

    public static String printRules() {
        theRules.get(0).getSAXRules();
        SAXRule.expandRules();
        Vector<SAXRule> rules = new Vector<SAXRule>(numRules.intValue());
        StringBuilder text = new StringBuilder();
        text.append("Number\tName\tLevel\tOccurr.\tUsage\tYield\tRule str\tExpaneded\tIndexes\n");
        rules.addElement(theRules.get(0));
        StringBuilder currentRuleString = new StringBuilder();
        for (int processedRules = 0; processedRules < rules.size(); ++processedRules) {
            SAXRule currentRule = (SAXRule)rules.elementAt(processedRules);
            text.append(SPACE);
            text.append(arrRuleRecords.get(processedRules).getRuleNumber()).append(TAB);
            text.append(arrRuleRecords.get(processedRules).getRuleName()).append(TAB);
            text.append(arrRuleRecords.get(processedRules).getRuleLevel()).append(TAB);
            text.append(arrRuleRecords.get(processedRules).getOccurrences().size()).append(TAB);
            text.append(arrRuleRecords.get(processedRules).getRuleUseFrequency()).append(TAB);
            text.append(arrRuleRecords.get(processedRules).getRuleYield()).append(TAB);
            SAXSymbol sym = currentRule.first();
            while (!sym.isGuard()) {
                if (sym.isNonTerminal()) {
                    int index;
                    SAXRule referedTo = ((SAXNonTerminal)sym).r;
                    if (rules.size() > referedTo.index && rules.elementAt(referedTo.index) == referedTo) {
                        index = referedTo.index;
                    } else {
                        referedTo.index = index = rules.size();
                        rules.addElement(referedTo);
                    }
                    text.append('R');
                    text.append(index);
                    currentRuleString.append('R');
                    currentRuleString.append(index);
                } else if (sym.value.equals(SPACE)) {
                    text.append('_');
                    currentRuleString.append('_');
                } else if (sym.value.equals(CR)) {
                    text.append("\\n");
                    currentRuleString.append("\\n");
                } else {
                    text.append(sym.value);
                    currentRuleString.append(sym.value);
                }
                text.append(' ');
                currentRuleString.append(' ');
                sym = sym.n;
            }
            text.append(TAB).append(arrRuleRecords.get(processedRules).getExpandedRuleString()).append(TAB);
            text.append(Arrays.toString(currentRule.getIndexes())).append(CR);
            currentRuleString = new StringBuilder();
        }
        return text.toString();
    }

    public static void reset() {
        numRules = new AtomicInteger(0);
        SAXSymbol.theDigrams.clear();
        SAXSymbol.theSubstituteTable.clear();
        arrRuleRecords = new ArrayList();
    }
}

