/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.rulepruner;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.beust.jcommander.JCommander;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import net.seninp.gi.rulepruner.ReductionSorter;
import net.seninp.gi.rulepruner.RulePruner;
import net.seninp.gi.rulepruner.RulePrunerParameters;
import net.seninp.gi.rulepruner.SampledPoint;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.util.StackTrace;
import org.slf4j.LoggerFactory;

public class RulePrunerPrinter {
    private static final String CR = "\n";
    private static final DecimalFormat dfPercent = new DecimalFormat("0.00");
    private static final DecimalFormat dfSize = new DecimalFormat("#.0000");
    private static Logger consoleLogger;
    private static Level LOGGING_LEVEL;

    public static void main(String[] args) throws Exception {
        try {
            RulePrunerParameters params = new RulePrunerParameters();
            JCommander jct = new JCommander((Object)params, args);
            if (0 == args.length) {
                jct.usage();
            } else {
                StringBuffer sb = new StringBuffer(1024);
                sb.append("Rule pruner CLI v.1").append(CR);
                sb.append("parameters:").append(CR);
                sb.append("  input file:           ").append(RulePrunerParameters.IN_FILE).append(CR);
                sb.append("  output file:          ").append(RulePrunerParameters.OUT_FILE).append(CR);
                sb.append("  SAX num. reduction:   ").append(RulePrunerParameters.SAX_NR_STRATEGY).append(CR);
                sb.append("  SAX norm. threshold:  ").append(RulePrunerParameters.SAX_NORM_THRESHOLD).append(CR);
                sb.append("  GI Algorithm:         ").append((Object)RulePrunerParameters.GI_ALGORITHM_IMPLEMENTATION).append(CR);
                sb.append("  Grid boundaries:      ").append(RulePrunerParameters.GRID_BOUNDARIES).append(CR);
                if (!Double.isNaN(RulePrunerParameters.SUBSAMPLING_FRACTION)) {
                    sb.append("  Subsampling fraction: ").append(RulePrunerParameters.SUBSAMPLING_FRACTION).append(CR);
                }
                System.err.print(sb.toString());
                String dataFName = RulePrunerParameters.IN_FILE;
                double[] ts = TSProcessor.readFileColumn((String)dataFName, (int)0, (int)0);
                if (!Double.isNaN(RulePrunerParameters.SUBSAMPLING_FRACTION)) {
                    ts = Arrays.copyOfRange(ts, 0, (int)Math.round((double)ts.length * RulePrunerParameters.SUBSAMPLING_FRACTION));
                }
                System.err.println("  working with series of " + ts.length + " points ... " + CR);
                int[] boundaries = RulePrunerPrinter.toBoundaries(RulePrunerParameters.GRID_BOUNDARIES);
                ArrayList<SampledPoint> res = new ArrayList<SampledPoint>();
                RulePruner rp = new RulePruner(ts);
                for (int WINDOW_SIZE = boundaries[0]; WINDOW_SIZE < boundaries[1]; WINDOW_SIZE += boundaries[2]) {
                    for (int PAA_SIZE = boundaries[3]; PAA_SIZE < boundaries[4]; PAA_SIZE += boundaries[5]) {
                        if (PAA_SIZE > WINDOW_SIZE) continue;
                        for (int ALPHABET_SIZE = boundaries[6]; ALPHABET_SIZE < boundaries[7]; ALPHABET_SIZE += boundaries[8]) {
                            SampledPoint p = rp.sample(WINDOW_SIZE, PAA_SIZE, ALPHABET_SIZE, RulePrunerParameters.SAX_NR_STRATEGY, RulePrunerParameters.SAX_NORM_THRESHOLD);
                            if (Thread.currentThread().isInterrupted() && null == p) {
                                System.err.println("Seen null sampled point, I guess we were interrupted!");
                                Collections.sort(res, new ReductionSorter());
                                System.out.println("\nApparently, the best parameters so far are " + ((SampledPoint)res.get(0)).toString());
                                return;
                            }
                            res.add(p);
                        }
                    }
                }
                Collections.sort(res, new ReductionSorter());
                System.out.println("\nApparently, the best parameters are " + ((SampledPoint)res.get(0)).toString());
            }
        }
        catch (Exception e) {
            System.err.println("error occured while parsing parameters " + Arrays.toString(args) + CR + StackTrace.toString((Throwable)e));
            System.exit(-1);
        }
    }

    private static int[] toBoundaries(String str) {
        int[] res = new int[9];
        String[] split = str.split("\\s+");
        for (int i = 0; i < 9; ++i) {
            res[i] = Integer.valueOf(split[i]);
        }
        return res;
    }

    static {
        LOGGING_LEVEL = Level.INFO;
        consoleLogger = (Logger)LoggerFactory.getLogger(RulePrunerPrinter.class);
        consoleLogger.setLevel(LOGGING_LEVEL);
        dfPercent.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        dfSize.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
    }
}

