/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.rulepruner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import net.seninp.gi.GrammarRuleRecord;
import net.seninp.gi.GrammarRules;
import net.seninp.gi.RuleInterval;
import net.seninp.jmotif.sax.datastructures.SAXRecords;

public class RulePrunerFactory {
    public static GrammarRules performPruning(double[] ts, GrammarRules grammarRules) {
        boolean[] range = new boolean[ts.length];
        HashSet<Integer> usedRules = new HashSet<Integer>();
        usedRules.add(0);
        HashSet<Integer> removedRules = new HashSet<Integer>();
        while (RulePrunerFactory.hasEmptyRanges(range)) {
            GrammarRuleRecord bestRule = null;
            double bestDelta = -2.147483648E9;
            for (GrammarRuleRecord rule : grammarRules) {
                double delta;
                int id = rule.getRuleNumber();
                if (usedRules.contains(id) || removedRules.contains(id) || !((delta = RulePrunerFactory.getCoverDelta(range, rule)) > bestDelta)) continue;
                bestDelta = delta;
                bestRule = rule;
            }
            if (null == bestRule || 0.0 == bestDelta) break;
            usedRules.add(bestRule.getRuleNumber());
            boolean continueSearch = true;
            block2: while (continueSearch) {
                continueSearch = false;
                Iterator iterator = usedRules.iterator();
                while (iterator.hasNext()) {
                    int rid = (Integer)iterator.next();
                    if (0 == rid) continue;
                    ArrayList<RuleInterval> intervalsA = grammarRules.get(rid).getRuleIntervals();
                    ArrayList<RuleInterval> intervalsB = new ArrayList<RuleInterval>();
                    Iterator iterator2 = usedRules.iterator();
                    while (iterator2.hasNext()) {
                        int ridB = (Integer)iterator2.next();
                        if (0 == ridB || rid == ridB) continue;
                        intervalsB.addAll(grammarRules.get(ridB).getRuleIntervals());
                    }
                    if (intervalsB.isEmpty()) continue block2;
                    if (!RulePrunerFactory.isCompletlyCovered(intervalsB, intervalsA)) continue;
                    usedRules.remove(rid);
                    removedRules.add(rid);
                    continueSearch = true;
                    continue block2;
                }
            }
            range = RulePrunerFactory.updateRanges(range, bestRule.getRuleIntervals());
        }
        GrammarRules prunedRules = new GrammarRules();
        prunedRules.addRule(grammarRules.get(0));
        for (Integer rId : usedRules) {
            prunedRules.addRule(grammarRules.get(rId));
        }
        return prunedRules;
    }

    public static Integer computePrunedGrammarSize(double[] ts, GrammarRules rules, SAXRecords saxData, Integer paaSize) {
        int res = 0;
        for (Object r : rules) {
            if (0 == ((GrammarRuleRecord)r).getRuleNumber()) continue;
            res = res + ((GrammarRuleRecord)r).getExpandedRuleString().replaceAll("\\s", "").length() + ((GrammarRuleRecord)r).getOccurrences().size() * 2;
        }
        boolean[] range = new boolean[ts.length];
        for (GrammarRuleRecord r : rules) {
            if (0 == r.getRuleNumber()) continue;
            range = RulePrunerFactory.updateRanges(range, r.getRuleIntervals());
        }
        if (!RulePrunerFactory.isCovered(range)) {
            for (int i = 0; i < range.length; ++i) {
                if (range[i] || null == saxData.getByIndex(i)) continue;
                res = res + paaSize + 2;
            }
        }
        return res;
    }

    public static Integer computeValidGrammarSize(double[] ts, GrammarRules rules, SAXRecords saxData, Integer paaSize) {
        int res = 0;
        for (Object r : rules) {
            String[] tokens;
            if (0 == ((GrammarRuleRecord)r).getRuleNumber()) continue;
            int ruleSize = 0;
            String ruleStr = ((GrammarRuleRecord)r).getRuleString();
            for (String t : tokens = ruleStr.split("\\s+")) {
                if (t.startsWith("R")) {
                    ruleSize += 2;
                    continue;
                }
                ruleSize += paaSize.intValue();
            }
            res += ruleSize + ((GrammarRuleRecord)r).getOccurrences().size() * 2;
        }
        boolean[] range = new boolean[ts.length];
        for (GrammarRuleRecord r : rules) {
            if (0 == r.getRuleNumber()) continue;
            range = RulePrunerFactory.updateRanges(range, r.getRuleIntervals());
        }
        if (!RulePrunerFactory.isCovered(range)) {
            for (int i = 0; i < range.length; ++i) {
                if (range[i] || null == saxData.getByIndex(i)) continue;
                res = res + paaSize + 2;
            }
        }
        return res;
    }

    public static boolean isCompletlyCovered(ArrayList<RuleInterval> cover, ArrayList<RuleInterval> intervals) {
        int j;
        int min = intervals.get(0).getStartPos();
        int max = intervals.get(0).getEndPos();
        for (RuleInterval i : intervals) {
            if (i.getStartPos() < min) {
                min = i.getStartPos();
            }
            if (i.getEndPos() <= max) continue;
            max = i.getEndPos();
        }
        boolean[] intervalsRange = new boolean[max - min];
        for (RuleInterval i : intervals) {
            for (j = i.getStartPos(); j < i.getEndPos(); ++j) {
                intervalsRange[j - min] = true;
            }
        }
        for (RuleInterval i : cover) {
            for (j = i.getStartPos(); j < i.getEndPos(); ++j) {
                if (j < min || j >= max) continue;
                intervalsRange[j - min] = false;
            }
        }
        for (Object b : (Object)intervalsRange) {
            if (true != b) continue;
            return false;
        }
        return true;
    }

    public static boolean[] updateRanges(boolean[] range, ArrayList<RuleInterval> ruleIntervals) {
        boolean[] res = Arrays.copyOf(range, range.length);
        for (RuleInterval i : ruleIntervals) {
            int start = i.getStartPos();
            int end = i.getEndPos();
            for (int j = start; j <= end; ++j) {
                res[j] = true;
            }
        }
        return res;
    }

    public static boolean[] updateRanges(boolean[] range, GrammarRules grammar) {
        boolean[] res = Arrays.copyOf(range, range.length);
        for (GrammarRuleRecord r : grammar) {
            if (0 == r.getRuleNumber()) continue;
            res = RulePrunerFactory.updateRanges(res, r.getRuleIntervals());
        }
        return res;
    }

    public static double getCoverDelta(boolean[] range, GrammarRuleRecord rule) {
        int new_cover = 0;
        int overlapping_cover = 0;
        for (RuleInterval i : rule.getRuleIntervals()) {
            int start = i.getStartPos();
            int end = i.getEndPos();
            for (int j = start; j <= end; ++j) {
                if (range[j]) {
                    ++overlapping_cover;
                    continue;
                }
                ++new_cover;
            }
        }
        if (0 == new_cover) {
            return 0.0;
        }
        if (0 == overlapping_cover) {
            return (double)new_cover / (double)(rule.getExpandedRuleString().length() + rule.getRuleIntervals().size());
        }
        return (double)new_cover / (double)(new_cover + overlapping_cover) / (double)(rule.getExpandedRuleString().length() + rule.getRuleIntervals().size());
    }

    public static double computeCover(boolean[] cover) {
        int covered = 0;
        for (boolean i : cover) {
            if (!i) continue;
            ++covered;
        }
        return (double)covered / (double)cover.length;
    }

    public static boolean isCovered(boolean[] range) {
        for (boolean i : range) {
            if (i) continue;
            return false;
        }
        return true;
    }

    public static boolean hasEmptyRanges(boolean[] range) {
        for (boolean p : range) {
            if (p) continue;
            return true;
        }
        return false;
    }
}

