/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.rulepruner;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.seninp.gi.GIAlgorithm;
import net.seninp.gi.GrammarRuleRecord;
import net.seninp.gi.GrammarRules;
import net.seninp.gi.repair.RePairFactory;
import net.seninp.gi.repair.RePairGrammar;
import net.seninp.gi.rulepruner.RulePrunerFactory;
import net.seninp.gi.rulepruner.RulePrunerParameters;
import net.seninp.gi.rulepruner.SampledPoint;
import net.seninp.gi.sequitur.SAXRule;
import net.seninp.gi.sequitur.SequiturFactory;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.datastructures.SAXRecords;
import net.seninp.jmotif.sax.parallel.ParallelSAXImplementation;
import org.slf4j.LoggerFactory;

public class RulePruner {
    private static final String COMMA = ",";
    private static final String CR = "\n";
    private static final DecimalFormat dfPercent = new DecimalFormat("0.00");
    private static final DecimalFormat dfSize = new DecimalFormat("#.0000");
    private double[] ts;
    private SAXProcessor sp;
    private static Logger consoleLogger;
    private static Level LOGGING_LEVEL;

    public RulePruner(double[] ts) {
        this.ts = ts;
        this.sp = new SAXProcessor();
    }

    public SampledPoint sample(int windowSize, int paaSize, int alphabetSize, NumerosityReductionStrategy nrStrategy, double nThreshold) throws Exception {
        SampledPoint res = new SampledPoint();
        StringBuffer logStr = new StringBuffer();
        logStr.append(windowSize).append(COMMA).append(paaSize).append(COMMA).append(alphabetSize).append(COMMA);
        res.setWindow(windowSize);
        res.setPAA(paaSize);
        res.setAlphabet(alphabetSize);
        ParallelSAXImplementation ps = new ParallelSAXImplementation();
        SAXRecords saxData = ps.process(this.ts, 2, windowSize, paaSize, alphabetSize, RulePrunerParameters.SAX_NR_STRATEGY, RulePrunerParameters.SAX_NORM_THRESHOLD);
        if (Thread.currentThread().isInterrupted() && null == saxData) {
            System.err.println("Sampler being interrupted, returning NULL!");
            return null;
        }
        saxData.buildIndex();
        double approximationDistance = this.sp.approximationDistance(this.ts, windowSize, paaSize, alphabetSize, RulePrunerParameters.SAX_NR_STRATEGY, RulePrunerParameters.SAX_NORM_THRESHOLD);
        logStr.append(dfSize.format(approximationDistance)).append(COMMA);
        res.setApproxDist(approximationDistance);
        GrammarRules rules = null;
        if (GIAlgorithm.SEQUITUR.equals((Object)RulePrunerParameters.GI_ALGORITHM_IMPLEMENTATION)) {
            SAXRule r = SequiturFactory.runSequitur(saxData.getSAXString(" "));
            rules = r.toGrammarRulesData();
            SequiturFactory.updateRuleIntervals(rules, saxData, true, this.ts, windowSize, paaSize);
        } else if (GIAlgorithm.REPAIR.equals((Object)RulePrunerParameters.GI_ALGORITHM_IMPLEMENTATION)) {
            RePairGrammar grammar = RePairFactory.buildGrammar(saxData.getSAXString(" "));
            rules = grammar.toGrammarRulesData();
        }
        Integer grammarSize = RulePrunerFactory.computeValidGrammarSize(this.ts, rules, saxData, paaSize);
        logStr.append(grammarSize).append(COMMA);
        logStr.append(rules.size()).append(COMMA);
        res.setGrammarSize(grammarSize);
        res.setGrammarRules(rules.size());
        GrammarRules prunedRulesSet = RulePrunerFactory.performPruning(this.ts, rules);
        Integer compressedSize = RulePrunerFactory.computePrunedGrammarSize(this.ts, prunedRulesSet, saxData, paaSize);
        logStr.append(compressedSize).append(COMMA);
        logStr.append(prunedRulesSet.size()).append(COMMA);
        res.setCompressedGrammarSize(compressedSize);
        res.setPrunedRules(prunedRulesSet.size());
        boolean[] compressedCover = new boolean[this.ts.length];
        compressedCover = RulePrunerFactory.updateRanges(compressedCover, prunedRulesSet);
        if (RulePrunerFactory.hasEmptyRanges(compressedCover)) {
            logStr.append("0").append(COMMA);
            res.setCovered(false);
        } else {
            logStr.append("1").append(COMMA);
            res.setCovered(true);
        }
        double coverage = RulePrunerFactory.computeCover(compressedCover);
        logStr.append(dfPercent.format(coverage));
        res.setCoverage(coverage);
        res.setReduction((double)compressedSize.intValue() / (double)grammarSize.intValue());
        int maxFreq = Integer.MIN_VALUE;
        for (GrammarRuleRecord r : prunedRulesSet) {
            if (r.getOccurrences().size() <= maxFreq) continue;
            maxFreq = r.getOccurrences().size();
        }
        res.setMaxFrequency(maxFreq);
        logStr.append(CR);
        consoleLogger.info(logStr.toString().replace(CR, ""));
        return res;
    }

    static {
        LOGGING_LEVEL = Level.INFO;
        consoleLogger = (Logger)LoggerFactory.getLogger(RulePruner.class);
        consoleLogger.setLevel(LOGGING_LEVEL);
        dfPercent.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        dfSize.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
    }
}

