/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import java.util.ArrayList;
import net.seninp.gi.RuleInterval;
import net.seninp.gi.repair.RePairGrammar;
import net.seninp.gi.repair.RePairSymbol;

public class RePairRule {
    private static final char SPACE = ' ';
    protected int ruleNumber;
    protected String expandedRuleString;
    protected RePairSymbol first;
    protected RePairSymbol second;
    protected int level;
    protected ArrayList<Integer> occurrences;
    protected ArrayList<RuleInterval> ruleIntervals;
    private RePairGrammar grammar;

    public RePairRule(RePairGrammar rg) {
        this.grammar = rg;
        this.ruleNumber = rg.numRules.intValue();
        rg.numRules.incrementAndGet();
        rg.theRules.put(this.ruleNumber, this);
        this.occurrences = new ArrayList();
        this.ruleIntervals = new ArrayList();
    }

    public void setFirst(RePairSymbol symbol) {
        this.first = symbol;
    }

    public void setSecond(RePairSymbol symbol) {
        this.second = symbol;
    }

    public int getId() {
        return this.ruleNumber;
    }

    public String toRuleString() {
        if (0 == this.ruleNumber) {
            return this.grammar.r0String;
        }
        return this.first.toString() + ' ' + this.second.toString() + ' ';
    }

    protected void setExpandedRule(String str) {
        this.expandedRuleString = str;
    }

    public String toExpandedRuleString() {
        return this.expandedRuleString;
    }

    public void addOccurrence(int value) {
        if (!this.occurrences.contains(value)) {
            this.occurrences.add(value);
        }
    }

    public int[] getOccurrences() {
        int[] res = new int[this.occurrences.size()];
        for (int i = 0; i < this.occurrences.size(); ++i) {
            res[i] = this.occurrences.get(i);
        }
        return res;
    }

    public String toString() {
        return "R" + this.ruleNumber;
    }

    public void assignLevel() {
        int lvl = Integer.MAX_VALUE;
        lvl = Math.min(this.first.getLevel() + 1, lvl);
        this.level = lvl = Math.min(this.second.getLevel() + 1, lvl);
    }

    public int getLevel() {
        return this.level;
    }

    public ArrayList<RuleInterval> getRuleIntervals() {
        return this.ruleIntervals;
    }

    public int[] getLengths() {
        if (this.ruleIntervals.isEmpty()) {
            return new int[1];
        }
        int[] res = new int[this.ruleIntervals.size()];
        int count = 0;
        for (RuleInterval ri : this.ruleIntervals) {
            res[count] = ri.getEndPos() - ri.getStartPos();
            ++count;
        }
        return res;
    }
}

