/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.seninp.gi.repair.DigramFrequencies;
import net.seninp.gi.repair.DigramFrequencyEntry;
import net.seninp.gi.repair.RePairGrammar;
import net.seninp.gi.repair.RePairGuard;
import net.seninp.gi.repair.RePairRule;
import net.seninp.gi.repair.RePairSymbol;
import net.seninp.jmotif.sax.datastructures.SAXRecord;
import net.seninp.jmotif.sax.datastructures.SAXRecords;
import org.slf4j.LoggerFactory;

public final class RePairFactory {
    private static final char SPACE = ' ';
    private static Logger consoleLogger;
    private static Level LOGGING_LEVEL;

    private RePairFactory() {
    }

    public static RePairGrammar buildGrammar(SAXRecords saxRecords) {
        DigramFrequencyEntry entry;
        consoleLogger.debug("Starting RePair with an input string of " + saxRecords.getIndexes().size() + " words.");
        RePairGrammar rg = new RePairGrammar();
        Set index = saxRecords.getIndexes();
        Object[] sortedIndexes = index.toArray(new Integer[index.size()]);
        Arrays.sort(sortedIndexes);
        ArrayList<RePairSymbol> string = new ArrayList<RePairSymbol>();
        DigramFrequencies digramFrequencies = new DigramFrequencies();
        int stringPositionCounter = 0;
        for (Object saxWordPosition : sortedIndexes) {
            SAXRecord r = saxRecords.getByIndex(((Integer)saxWordPosition).intValue());
            RePairSymbol symbol = new RePairSymbol(r, (Integer)stringPositionCounter);
            string.add(symbol);
            if (stringPositionCounter > 0) {
                StringBuffer digramStr = new StringBuffer();
                digramStr.append(string.get(stringPositionCounter - 1).toString()).append(' ').append(string.get(stringPositionCounter).toString());
                DigramFrequencyEntry entry2 = digramFrequencies.get(digramStr.toString());
                if (null == entry2) {
                    digramFrequencies.put(new DigramFrequencyEntry(digramStr.toString(), 1, stringPositionCounter - 1));
                } else {
                    digramFrequencies.incrementFrequency(entry2, 1);
                }
            }
            ++stringPositionCounter;
        }
        consoleLogger.debug("String length " + string.size() + " unique digrams " + digramFrequencies.size());
        while ((entry = digramFrequencies.getTop()) != null && entry.getFrequency() >= 2) {
            consoleLogger.info("re-pair iteration, digram \"" + entry.getDigram() + "\", frequency: " + entry.getFrequency());
            consoleLogger.debug("Going to substitute the digram " + entry.getDigram() + " first occurring at position " + entry.getFirstOccurrence() + " with frequency " + entry.getFrequency() + ", '" + string.get(entry.getFirstOccurrence()) + ' ' + string.get(entry.getFirstOccurrence() + 1) + "'");
            RePairRule r = new RePairRule(rg);
            r.setFirst(string.get(entry.getFirstOccurrence()));
            r.setSecond(string.get(entry.getFirstOccurrence() + 1));
            r.assignLevel();
            String digramToSubstitute = entry.getDigram();
            for (int currentIndex = entry.getFirstOccurrence(); currentIndex < string.size() - 1; ++currentIndex) {
                StringBuffer currentDigram = new StringBuffer();
                currentDigram.append(string.get(currentIndex).toString()).append(' ').append(string.get(currentIndex + 1).toString());
                if (!digramToSubstitute.equalsIgnoreCase(currentDigram.toString())) continue;
                consoleLogger.debug(" next digram occurrence is at  " + currentIndex + ", '" + string.get(currentIndex) + ' ' + string.get(currentIndex + 1) + "'");
                if (currentIndex > 0) {
                    RePairFactory.removeDigramFrequencyEntry(currentIndex - 1, string, digramFrequencies);
                }
                if (currentIndex < string.size() - 2) {
                    RePairFactory.removeDigramFrequencyEntry(currentIndex + 1, string, digramFrequencies);
                }
                RePairGuard g = new RePairGuard(r);
                g.setStringPosition(string.get(currentIndex).getStringPosition());
                r.addOccurrence(string.get(currentIndex).getStringPosition());
                RePairFactory.substituteDigramAt(rg, currentIndex, g, string, digramFrequencies);
            }
            consoleLogger.debug("*** iteration finished, top count " + digramFrequencies.getTop().getFrequency());
        }
        rg.setR0String(RePairFactory.stringToDisplay(string));
        return rg;
    }

    public static RePairGrammar buildGrammar(String inputString) {
        DigramFrequencyEntry entry;
        RePairGrammar rg = new RePairGrammar();
        ArrayList<RePairSymbol> string = new ArrayList<RePairSymbol>();
        DigramFrequencies digramFrequencies = new DigramFrequencies();
        StringTokenizer st = new StringTokenizer(inputString, " ");
        int stringPositionCounter = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            RePairSymbol symbol = new RePairSymbol(token, stringPositionCounter);
            string.add(symbol);
            if (stringPositionCounter > 0) {
                StringBuffer digramStr = new StringBuffer();
                digramStr.append(string.get(stringPositionCounter - 1).toString()).append(' ').append(string.get(stringPositionCounter).toString());
                DigramFrequencyEntry entry2 = digramFrequencies.get(digramStr.toString());
                if (null == entry2) {
                    digramFrequencies.put(new DigramFrequencyEntry(digramStr.toString(), 1, stringPositionCounter - 1));
                } else {
                    digramFrequencies.incrementFrequency(entry2, 1);
                }
            }
            ++stringPositionCounter;
        }
        consoleLogger.debug("String length " + string.size() + " unique digrams " + digramFrequencies.size());
        while ((entry = digramFrequencies.getTop()) != null && entry.getFrequency() > 1) {
            consoleLogger.info("re-pair iteration, digram \"" + entry.getDigram() + "\", frequency: " + entry.getFrequency());
            consoleLogger.debug("Going to substitute the digram " + entry.getDigram() + " first occurring at position " + entry.getFirstOccurrence() + " with frequency " + entry.getFrequency() + ", '" + string.get(entry.getFirstOccurrence()) + ' ' + string.get(entry.getFirstOccurrence() + 1) + "'");
            RePairRule r = new RePairRule(rg);
            r.setFirst(string.get(entry.getFirstOccurrence()));
            r.setSecond(string.get(entry.getFirstOccurrence() + 1));
            r.assignLevel();
            String digramToSubstitute = entry.getDigram();
            for (int currentIndex = entry.getFirstOccurrence(); currentIndex < string.size() - 1; ++currentIndex) {
                StringBuffer currentDigram = new StringBuffer();
                currentDigram.append(string.get(currentIndex).toString()).append(' ').append(string.get(currentIndex + 1).toString());
                if (!digramToSubstitute.equalsIgnoreCase(currentDigram.toString())) continue;
                consoleLogger.debug(" next digram occurrence is at  " + currentIndex + ", '" + string.get(currentIndex) + ' ' + string.get(currentIndex + 1) + "'");
                if (currentIndex > 0) {
                    RePairFactory.removeDigramFrequencyEntry(currentIndex - 1, string, digramFrequencies);
                }
                if (currentIndex < string.size() - 2) {
                    RePairFactory.removeDigramFrequencyEntry(currentIndex + 1, string, digramFrequencies);
                }
                RePairGuard g = new RePairGuard(r);
                g.setStringPosition(string.get(currentIndex).getStringPosition());
                r.addOccurrence(string.get(currentIndex).getStringPosition());
                RePairFactory.substituteDigramAt(rg, currentIndex, g, string, digramFrequencies);
            }
            consoleLogger.debug("*** iteration finished, top count " + digramFrequencies.getTop().getFrequency());
        }
        rg.setR0String(RePairFactory.stringToDisplay(string));
        rg.expandRules();
        return rg;
    }

    private static void substituteDigramAt(RePairGrammar rg, Integer currentIndex, RePairGuard g, ArrayList<RePairSymbol> string, DigramFrequencies digramFrequencies) {
        DigramFrequencyEntry entry;
        StringBuffer newDigram;
        StringBuffer digram = new StringBuffer();
        digram.append(string.get(currentIndex).toString()).append(' ').append(string.get(currentIndex + 1));
        consoleLogger.debug("  substituting the digram " + digram + " at " + currentIndex + " with " + g.toString());
        if (currentIndex > 0) {
            consoleLogger.debug("   previous " + string.get(currentIndex - 1).toString());
        }
        if (currentIndex < string.size() - 2) {
            consoleLogger.debug("   next " + string.get(currentIndex + 2).toString());
        }
        if (currentIndex > 0) {
            newDigram = new StringBuffer();
            newDigram.append(string.get(currentIndex - 1).toString()).append(' ').append(g.toString());
            consoleLogger.debug("   updating the frequency entry for digram " + newDigram.toString());
            entry = digramFrequencies.get(newDigram.toString());
            if (null == entry) {
                digramFrequencies.put(new DigramFrequencyEntry(newDigram.toString(), 1, currentIndex - 1));
            } else {
                digramFrequencies.incrementFrequency(entry, 1);
                if (currentIndex - 1 < entry.getFirstOccurrence()) {
                    entry.setFirstOccurrence(currentIndex - 1);
                }
            }
        }
        if (currentIndex < string.size() - 2) {
            newDigram = new StringBuffer();
            newDigram.append(g.toString()).append(' ').append(string.get(currentIndex + 2));
            consoleLogger.debug("   updating the frequency entry for digram " + newDigram.toString());
            entry = digramFrequencies.get(newDigram.toString());
            if (null == entry) {
                digramFrequencies.put(new DigramFrequencyEntry(newDigram.toString(), 1, currentIndex));
            } else {
                digramFrequencies.incrementFrequency(entry, 1);
                if (currentIndex + 1 < entry.getFirstOccurrence()) {
                    entry.setFirstOccurrence(currentIndex);
                }
            }
        }
        consoleLogger.debug("   updating the frequency entry for digram " + digram.toString());
        DigramFrequencyEntry entry2 = digramFrequencies.get(digram.toString());
        if (1 == entry2.getFrequency()) {
            consoleLogger.debug("    removing the frequency entry");
            digramFrequencies.remove(digram.toString());
        } else {
            consoleLogger.debug("    setting the frequency entry to " + Integer.valueOf(entry2.getFrequency() - 1));
            digramFrequencies.incrementFrequency(entry2, -1);
            if (currentIndex.intValue() == entry2.getFirstOccurrence()) {
                consoleLogger.debug("    this was an index entry, finding another digram index...");
                for (int i = currentIndex + 1; i < string.size() - 1; ++i) {
                    StringBuffer cDigram = new StringBuffer();
                    cDigram.append(string.get(i).toString()).append(' ').append(string.get(i + 1).toString());
                    if (!digram.toString().equals(cDigram.toString())) continue;
                    consoleLogger.debug("   for digram " + cDigram.toString() + " new index " + i);
                    entry2.setFirstOccurrence(i);
                    break;
                }
            }
        }
        string.set(currentIndex, g);
        consoleLogger.debug("   deleting symbol " + string.get(currentIndex + 1).toString() + " at " + Integer.valueOf(currentIndex + 1));
        string.remove(currentIndex + 1);
        for (Map.Entry<String, DigramFrequencyEntry> e : digramFrequencies.getEntries().entrySet()) {
            int idx = e.getValue().getFirstOccurrence();
            if (idx < currentIndex + 2) continue;
            e.getValue().setFirstOccurrence(idx - 1);
        }
    }

    private static void removeDigramFrequencyEntry(int index, ArrayList<RePairSymbol> string, DigramFrequencies digramFrequencies) {
        StringBuffer digramToRemove = new StringBuffer();
        digramToRemove.append(string.get(index).toString()).append(' ').append(string.get(index + 1).toString());
        DigramFrequencyEntry digramEntry = digramFrequencies.get(digramToRemove.toString());
        if (digramEntry.getFrequency() == 1) {
            digramFrequencies.remove(digramToRemove.toString());
            consoleLogger.debug("  completely removing the frequency entry for digram " + digramToRemove.toString() + " at position " + index);
        } else {
            consoleLogger.debug("  decreasing the frequency entry for digram " + digramToRemove.toString() + " at position " + index + " from " + digramEntry.getFrequency() + " to " + Integer.valueOf(digramEntry.getFrequency() - 1));
            digramFrequencies.incrementFrequency(digramEntry, -1);
            if (index == digramEntry.getFirstOccurrence()) {
                consoleLogger.debug("  this was an index entry, finding another digram index...");
                for (int i = index + 1; i < string.size() - 1; ++i) {
                    StringBuffer cDigram = new StringBuffer();
                    cDigram.append(string.get(i).toString()).append(' ').append(string.get(i + 1).toString());
                    if (!digramToRemove.toString().equals(cDigram.toString())) continue;
                    consoleLogger.debug("   for digram " + cDigram.toString() + " new index " + i);
                    digramEntry.setFirstOccurrence(i);
                    break;
                }
            }
        }
    }

    private static String stringToDisplay(ArrayList<RePairSymbol> string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.size(); ++i) {
            sb.append(string.get(i).toString()).append(' ');
        }
        return sb.toString();
    }

    static {
        LOGGING_LEVEL = Level.WARN;
        consoleLogger = (Logger)LoggerFactory.getLogger(RePairFactory.class);
        consoleLogger.setLevel(LOGGING_LEVEL);
    }
}

