/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import net.seninp.gi.repair.DigramFrequencies;
import net.seninp.gi.repair.DigramFrequencyEntry;
import net.seninp.gi.repair.ParallelGrammarKeeper;
import net.seninp.gi.repair.ParallelRePairGuard;
import net.seninp.gi.repair.ParallelRePairRule;
import net.seninp.gi.repair.RePairSymbol;

public class ParallelRePairWorkerSingleLevel
implements Callable<ParallelGrammarKeeper> {
    private static final char SPACE = ' ';
    private long id;
    private int startIdx;
    private int endIdx;
    private ParallelGrammarKeeper grammar;

    public ParallelRePairWorkerSingleLevel(long id, ParallelGrammarKeeper grammar, int firstWord, int lastWord) {
        this.id = id;
        this.grammar = grammar;
        this.startIdx = firstWord;
        this.endIdx = lastWord;
    }

    @Override
    public ParallelGrammarKeeper call() throws Exception {
        DigramFrequencyEntry entry;
        Object r;
        ParallelGrammarKeeper res = new ParallelGrammarKeeper(this.id);
        res.numRules.set(this.grammar.numRules.intValue());
        ArrayList<RePairSymbol> string = new ArrayList<RePairSymbol>();
        DigramFrequencies digramFrequencies = new DigramFrequencies();
        int stringPositionCounter = 0;
        for (int i = this.startIdx; i < this.endIdx; ++i) {
            r = this.grammar.workString.get(i);
            string.add((RePairSymbol)r);
            if (stringPositionCounter > 0) {
                StringBuffer digramStr = new StringBuffer();
                digramStr.append(string.get(stringPositionCounter - 1).toString()).append(' ').append(string.get(stringPositionCounter).toString());
                DigramFrequencyEntry entry2 = digramFrequencies.get(digramStr.toString());
                if (null == entry2) {
                    digramFrequencies.put(new DigramFrequencyEntry(digramStr.toString(), 1, stringPositionCounter - 1));
                } else {
                    digramFrequencies.incrementFrequency(entry2, 1);
                }
            }
            ++stringPositionCounter;
        }
        while ((entry = digramFrequencies.getTop()) != null && entry.getFrequency() >= 2) {
            r = new ParallelRePairRule(res);
            ((ParallelRePairRule)r).setFirst(string.get(entry.getFirstOccurrence()));
            ((ParallelRePairRule)r).setSecond(string.get(entry.getFirstOccurrence() + 1));
            String digramToSubstitute = entry.getDigram();
            for (int currentIndex = entry.getFirstOccurrence(); currentIndex < string.size() - 1; ++currentIndex) {
                StringBuffer currentDigram = new StringBuffer();
                currentDigram.append(string.get(currentIndex).toString()).append(' ').append(string.get(currentIndex + 1).toString());
                if (!digramToSubstitute.equalsIgnoreCase(currentDigram.toString())) continue;
                if (currentIndex > 0) {
                    ParallelRePairWorkerSingleLevel.removeDigramFrequencyEntry(currentIndex - 1, string, digramFrequencies);
                }
                if (currentIndex < string.size() - 2) {
                    ParallelRePairWorkerSingleLevel.removeDigramFrequencyEntry(currentIndex + 1, string, digramFrequencies);
                }
                ParallelRePairGuard g = new ParallelRePairGuard((ParallelRePairRule)r);
                g.setStringPosition(string.get(currentIndex).getStringPosition());
                ((ParallelRePairRule)r).addPosition(string.get(currentIndex).getStringPosition());
                ParallelRePairWorkerSingleLevel.substituteDigramAt(currentIndex, g, string, digramFrequencies);
            }
        }
        res.workString = string;
        res.setR0String(ParallelRePairWorkerSingleLevel.stringToDisplay(string));
        return res;
    }

    private static void substituteDigramAt(Integer currentIndex, ParallelRePairGuard guard, ArrayList<RePairSymbol> string, DigramFrequencies digramFrequencies) {
        StringBuffer digram = new StringBuffer();
        digram.append(string.get(currentIndex).toString()).append(' ').append(string.get(currentIndex + 1));
        DigramFrequencyEntry entry = digramFrequencies.get(digram.toString());
        if (1 == entry.getFrequency()) {
            digramFrequencies.remove(digram.toString());
        } else {
            digramFrequencies.incrementFrequency(entry, -1);
            if (currentIndex.intValue() == entry.getFirstOccurrence()) {
                for (int i = currentIndex + 1; i < string.size() - 1; ++i) {
                    StringBuffer cDigram = new StringBuffer();
                    cDigram.append(string.get(i).toString()).append(' ').append(string.get(i + 1).toString());
                    if (!digram.toString().equals(cDigram.toString())) continue;
                    entry.setFirstOccurrence(i);
                    break;
                }
            }
        }
        string.set(currentIndex, guard);
        string.remove(currentIndex + 1);
        for (Map.Entry<String, DigramFrequencyEntry> e : digramFrequencies.getEntries().entrySet()) {
            int idx = e.getValue().getFirstOccurrence();
            if (idx < currentIndex + 2) continue;
            e.getValue().setFirstOccurrence(idx - 1);
        }
    }

    private static void removeDigramFrequencyEntry(int index, ArrayList<RePairSymbol> string, DigramFrequencies digramFrequencies) {
        StringBuffer digramToRemove = new StringBuffer();
        digramToRemove.append(string.get(index).toString()).append(' ').append(string.get(index + 1).toString());
        DigramFrequencyEntry digramEntry = digramFrequencies.get(digramToRemove.toString());
        if (null == digramEntry) {
            return;
        }
        if (digramEntry.getFrequency() == 1) {
            digramFrequencies.remove(digramToRemove.toString());
        } else {
            digramFrequencies.incrementFrequency(digramEntry, -1);
            if (index == digramEntry.getFirstOccurrence()) {
                for (int i = index + 1; i < string.size() - 1; ++i) {
                    StringBuffer cDigram = new StringBuffer();
                    cDigram.append(string.get(i).toString()).append(' ').append(string.get(i + 1).toString());
                    if (!digramToRemove.toString().equals(cDigram.toString())) continue;
                    digramEntry.setFirstOccurrence(i);
                    break;
                }
            }
        }
    }

    private static String stringToDisplay(ArrayList<RePairSymbol> string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.size(); ++i) {
            sb.append(string.get(i).toString()).append(' ');
        }
        return sb.toString();
    }
}

