/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import java.util.ArrayList;
import net.seninp.gi.repair.ParallelGrammarKeeper;
import net.seninp.gi.repair.ParallelRePairGuard;
import net.seninp.gi.repair.RePairSymbol;

public class ParallelRePairRule {
    protected ParallelGrammarKeeper grammarHandler;
    protected int ruleNumber;
    protected RePairSymbol first;
    protected RePairSymbol second;
    protected ArrayList<Integer> positions;
    protected String expandedRuleString;
    protected ParallelRePairGuard guard;

    public ParallelRePairRule(ParallelGrammarKeeper grammarHandler) {
        this.grammarHandler = grammarHandler;
        this.ruleNumber = grammarHandler.numRules.intValue();
        this.grammarHandler.numRules.incrementAndGet();
        this.grammarHandler.theRules.put(this.ruleNumber, this);
        this.positions = new ArrayList();
    }

    public void setFirst(RePairSymbol symbol) {
        this.first = symbol;
    }

    public void setSecond(RePairSymbol symbol) {
        this.second = symbol;
    }

    public int getId() {
        return this.ruleNumber;
    }

    public String toString() {
        return "R" + this.ruleNumber;
    }

    public String toRuleString() {
        if (0 == this.ruleNumber) {
            return this.grammarHandler.r0String;
        }
        return this.first.toString() + " " + this.second.toString() + " ";
    }

    public void addPosition(int currentIndex) {
        this.positions.add(currentIndex);
    }

    public int[] getPositions() {
        int[] res = new int[this.positions.size()];
        for (int i = 0; i < this.positions.size(); ++i) {
            res[i] = this.positions.get(i);
        }
        return res;
    }

    public void setExpandedRule(String trim) {
        this.expandedRuleString = trim;
    }

    public String getRuleName() {
        return "R" + this.ruleNumber;
    }

    public String getExpandedRuleString() {
        return this.expandedRuleString;
    }
}

