/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.seninp.gi.repair.DigramFrequencies;
import net.seninp.gi.repair.DigramFrequencyEntry;
import net.seninp.gi.repair.ParallelGrammarKeeper;
import net.seninp.gi.repair.ParallelRePairGuard;
import net.seninp.gi.repair.ParallelRePairRule;
import net.seninp.gi.repair.ParallelRePairWorkerSingleLevel;
import net.seninp.gi.repair.RePairSymbol;
import net.seninp.util.StackTrace;
import org.slf4j.LoggerFactory;

public class ParallelRePairImplementation {
    private static final char SPACE = ' ';
    private static Logger consoleLogger;
    private static Level LOGGING_LEVEL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParallelGrammarKeeper buildGrammar(ParallelGrammarKeeper grammar, int threadsNum) {
        consoleLogger.debug("Starting the parallel RE-Pair");
        int iterationCounter = 0;
        boolean contunue = true;
        while (contunue) {
            int oldStringSize = grammar.workString.size();
            HashMap<String, ParallelRePairRule> extendedStringToRecord = new HashMap<String, ParallelRePairRule>();
            HashMap<Integer, ParallelRePairRule> ruleNumToRecord = new HashMap<Integer, ParallelRePairRule>();
            if (!grammar.theRules.isEmpty()) {
                for (Map.Entry<Integer, ParallelRePairRule> e : grammar.theRules.entrySet()) {
                    ruleNumToRecord.put(e.getKey(), e.getValue());
                }
            }
            HashMap<Integer, String> chunkStrings = new HashMap<Integer, String>();
            HashMap<Integer, ArrayList<RePairSymbol>> chunkWorkStrings = new HashMap<Integer, ArrayList<RePairSymbol>>();
            ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
            ExecutorCompletionService<ParallelGrammarKeeper> completionService = new ExecutorCompletionService<ParallelGrammarKeeper>(executorService);
            consoleLogger.info("Iteration #" + iterationCounter + ", created thread pool of " + threadsNum + " threads");
            int totalTaskCounter = 0;
            long tstamp = System.currentTimeMillis();
            int evenIncrement = grammar.workString.size() / threadsNum;
            int reminder = grammar.workString.size() % threadsNum;
            int firstChunkSize = evenIncrement + reminder;
            consoleLogger.info("data size " + grammar.workString.size() + " tokens, evenIncrement " + evenIncrement + ", reminder " + reminder + ", firstChunkSize " + firstChunkSize);
            boolean firstChunkStart = false;
            int firstChunkEnd = firstChunkSize;
            ParallelRePairWorkerSingleLevel job0 = new ParallelRePairWorkerSingleLevel(tstamp + (long)totalTaskCounter, grammar, 0, firstChunkEnd);
            completionService.submit(job0);
            consoleLogger.debug("submitted first chunk job " + tstamp);
            ++totalTaskCounter;
            while (totalTaskCounter < threadsNum - 1) {
                int intermediateChunkStart = firstChunkSize + (totalTaskCounter - 1) * evenIncrement;
                int intermediateChunkEnd = firstChunkSize + totalTaskCounter * evenIncrement;
                ParallelRePairWorkerSingleLevel job = new ParallelRePairWorkerSingleLevel(tstamp + (long)totalTaskCounter, grammar, intermediateChunkStart, intermediateChunkEnd);
                completionService.submit(job);
                consoleLogger.debug("submitted intermediate chunk job " + Long.valueOf(tstamp + (long)totalTaskCounter));
                ++totalTaskCounter;
            }
            int lastChunkStart = grammar.workString.size() - evenIncrement;
            int lastChunkEnd = grammar.workString.size();
            ParallelRePairWorkerSingleLevel jobN = new ParallelRePairWorkerSingleLevel(tstamp + (long)totalTaskCounter, grammar, lastChunkStart, lastChunkEnd);
            completionService.submit(jobN);
            consoleLogger.debug("submitted last chunk job " + Long.valueOf(tstamp + (long)totalTaskCounter));
            ++totalTaskCounter;
            executorService.shutdown();
            try {
                int i;
                while (totalTaskCounter > 0) {
                    Future finished = completionService.poll(128L, TimeUnit.HOURS);
                    if (null == finished) {
                        System.err.println("Breaking POLL loop after 128 HOURS of waiting...");
                        break;
                    }
                    ParallelGrammarKeeper chunkRes = (ParallelGrammarKeeper)finished.get();
                    int chunkJobIndex = (int)(chunkRes.getId() - tstamp);
                    consoleLogger.debug("job " + chunkRes.getId() + " of chunk " + chunkJobIndex + " has finished");
                    Hashtable<Integer, ParallelRePairRule> chunkGrammarRulesData = chunkRes.theRules;
                    String R0String = chunkRes.r0String;
                    chunkStrings.put(chunkJobIndex, R0String);
                    chunkWorkStrings.put(chunkJobIndex, chunkRes.workString);
                    chunkRes.expandRules();
                    ArrayList<Integer> keys = new ArrayList<Integer>(chunkGrammarRulesData.keySet());
                    Collections.sort(keys);
                    for (int i2 = 0; i2 < keys.size(); ++i2) {
                        ParallelRePairGuard el;
                        int nextSpaceIdx;
                        int ruleNum;
                        int newRuleNum;
                        int num;
                        ParallelRePairRule r = chunkGrammarRulesData.get(keys.get(i2));
                        consoleLogger.trace("processing rule " + r.getRuleName() + " -> " + r.toRuleString() + " : " + r.expandedRuleString);
                        ParallelRePairRule matchingRecord = (ParallelRePairRule)extendedStringToRecord.get(r.expandedRuleString);
                        if (null == matchingRecord) {
                            consoleLogger.trace("there is no matching rule...");
                            num = r.ruleNumber;
                            if (ruleNumToRecord.containsKey(num)) {
                                consoleLogger.trace(" .. but this rule num is taken by " + ruleNumToRecord.get(num));
                                r.ruleNumber = newRuleNum = ruleNumToRecord.size() + 1;
                                R0String = R0String.replaceAll(String.valueOf("R" + num + ' '), String.valueOf("@" + newRuleNum + ' '));
                                consoleLogger.trace(" .. performed rename, R" + num + " -> " + r.getRuleName());
                            }
                            extendedStringToRecord.put(r.expandedRuleString, r);
                            ruleNumToRecord.put(r.ruleNumber, r);
                            continue;
                        }
                        consoleLogger.trace("there is a matching rule: " + matchingRecord.getRuleName() + " -> " + matchingRecord.toRuleString());
                        matchingRecord.positions.addAll(r.positions);
                        num = r.ruleNumber;
                        newRuleNum = matchingRecord.ruleNumber;
                        StringBuilder R0sb = new StringBuilder(R0String);
                        int tokenIdx = 0;
                        int spaceIdx = -1;
                        if (R0String.charAt(0) == 'R' && num == (ruleNum = Integer.parseInt(R0String.substring(1, nextSpaceIdx = R0String.indexOf(32, 1))))) {
                            R0sb.replace(0, nextSpaceIdx, "@" + newRuleNum);
                            el = (ParallelRePairGuard)((ArrayList)chunkWorkStrings.get(chunkJobIndex)).get(0);
                            el.rule = matchingRecord;
                        }
                        while ((spaceIdx = R0sb.indexOf(" ", spaceIdx + 1)) >= 0) {
                            if (spaceIdx < R0sb.length() - 1 && R0sb.charAt(spaceIdx + 1) == 'R' && num == (ruleNum = Integer.parseInt(R0sb.substring(spaceIdx + 2, nextSpaceIdx = R0sb.indexOf(" ", spaceIdx + 1))))) {
                                R0sb.replace(spaceIdx + 1, nextSpaceIdx, "@" + newRuleNum);
                                el = (ParallelRePairGuard)((ArrayList)chunkWorkStrings.get(chunkJobIndex)).get(tokenIdx + 1);
                                el.rule = matchingRecord;
                            }
                            ++tokenIdx;
                        }
                        R0String = R0sb.toString();
                    }
                    chunkStrings.put(chunkJobIndex, R0String.replaceAll("@", "R"));
                    --totalTaskCounter;
                }
                String mergedString = "";
                ArrayList<RePairSymbol> mergedWorkString = new ArrayList<RePairSymbol>();
                for (i = 0; i < chunkStrings.size(); ++i) {
                    mergedString = mergedString.concat((String)chunkStrings.get(i));
                    mergedWorkString.addAll((Collection)chunkWorkStrings.get(i));
                }
                grammar.setR0String(mergedString);
                grammar.setWorkString(mergedWorkString);
                for (i = 1; i < ruleNumToRecord.size() + 1; ++i) {
                    ParallelRePairRule r = (ParallelRePairRule)ruleNumToRecord.get(i);
                    grammar.addExistingRule(r);
                }
            }
            catch (Exception e) {
                System.err.println("Error while waiting results: " + StackTrace.toString((Throwable)e));
            }
            finally {
                try {
                    if (!executorService.awaitTermination(4L, TimeUnit.HOURS)) {
                        executorService.shutdownNow();
                        if (!executorService.awaitTermination(30L, TimeUnit.MINUTES)) {
                            System.err.println("Pool did not terminate... FATAL ERROR");
                        }
                    }
                }
                catch (InterruptedException ie) {
                    System.err.println("Error while waiting interrupting: " + StackTrace.toString((Throwable)ie));
                    executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
            if (grammar.workString.size() == oldStringSize) {
                DigramFrequencyEntry entry;
                Object r;
                consoleLogger.info("finished with iterations... the final repair execution...");
                ArrayList<RePairSymbol> string = new ArrayList<RePairSymbol>();
                DigramFrequencies digramFrequencies = new DigramFrequencies();
                int stringPositionCounter = 0;
                for (int i = 0; i < grammar.workString.size(); ++i) {
                    r = grammar.workString.get(i);
                    string.add((RePairSymbol)r);
                    if (stringPositionCounter > 0) {
                        StringBuffer digramStr = new StringBuffer();
                        digramStr.append(string.get(stringPositionCounter - 1).toString()).append(' ').append(string.get(stringPositionCounter).toString());
                        DigramFrequencyEntry entry2 = digramFrequencies.get(digramStr.toString());
                        if (null == entry2) {
                            digramFrequencies.put(new DigramFrequencyEntry(digramStr.toString(), 1, stringPositionCounter - 1));
                        } else {
                            digramFrequencies.incrementFrequency(entry2, 1);
                        }
                    }
                    ++stringPositionCounter;
                }
                while ((entry = digramFrequencies.getTop()) != null && entry.getFrequency() >= 2) {
                    r = new ParallelRePairRule(grammar);
                    ((ParallelRePairRule)r).setFirst(string.get(entry.getFirstOccurrence()));
                    ((ParallelRePairRule)r).setSecond(string.get(entry.getFirstOccurrence() + 1));
                    String digramToSubstitute = entry.getDigram();
                    for (int currentIndex = entry.getFirstOccurrence(); currentIndex < string.size() - 1; ++currentIndex) {
                        StringBuffer currentDigram = new StringBuffer();
                        currentDigram.append(string.get(currentIndex).toString()).append(' ').append(string.get(currentIndex + 1).toString());
                        if (!digramToSubstitute.equalsIgnoreCase(currentDigram.toString())) continue;
                        if (currentIndex > 0) {
                            ParallelRePairImplementation.removeDigramFrequencyEntry(currentIndex - 1, string, digramFrequencies);
                        }
                        if (currentIndex < string.size() - 2) {
                            ParallelRePairImplementation.removeDigramFrequencyEntry(currentIndex + 1, string, digramFrequencies);
                        }
                        ParallelRePairGuard g = new ParallelRePairGuard((ParallelRePairRule)r);
                        g.setStringPosition(string.get(currentIndex).getStringPosition());
                        ((ParallelRePairRule)r).addPosition(string.get(currentIndex).getStringPosition());
                        ParallelRePairImplementation.substituteDigramAt(currentIndex, g, string, digramFrequencies);
                    }
                }
                grammar.setR0String(ParallelRePairImplementation.stringToDisplay(string));
                grammar.expandRules();
                grammar.workString = string;
                return grammar;
            }
            ++iterationCounter;
        }
        return null;
    }

    private static String stringToDisplay(ArrayList<RePairSymbol> string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.size(); ++i) {
            sb.append(string.get(i).toString()).append(' ');
        }
        return sb.toString();
    }

    private static void substituteDigramAt(Integer currentIndex, ParallelRePairGuard guard, ArrayList<RePairSymbol> string, DigramFrequencies digramFrequencies) {
        StringBuffer digram = new StringBuffer();
        digram.append(string.get(currentIndex).toString()).append(' ').append(string.get(currentIndex + 1));
        DigramFrequencyEntry entry = digramFrequencies.get(digram.toString());
        if (1 == entry.getFrequency()) {
            digramFrequencies.remove(digram.toString());
        } else {
            digramFrequencies.incrementFrequency(entry, -1);
            if (currentIndex.intValue() == entry.getFirstOccurrence()) {
                for (int i = currentIndex + 1; i < string.size() - 1; ++i) {
                    StringBuffer cDigram = new StringBuffer();
                    cDigram.append(string.get(i).toString()).append(' ').append(string.get(i + 1).toString());
                    if (!digram.toString().equals(cDigram.toString())) continue;
                    entry.setFirstOccurrence(i);
                    break;
                }
            }
        }
        string.set(currentIndex, guard);
        string.remove(currentIndex + 1);
        for (Map.Entry<String, DigramFrequencyEntry> e : digramFrequencies.getEntries().entrySet()) {
            int idx = e.getValue().getFirstOccurrence();
            if (idx < currentIndex + 2) continue;
            e.getValue().setFirstOccurrence(idx - 1);
        }
    }

    private static void removeDigramFrequencyEntry(int index, ArrayList<RePairSymbol> string, DigramFrequencies digramFrequencies) {
        StringBuffer digramToRemove = new StringBuffer();
        digramToRemove.append(string.get(index).toString()).append(' ').append(string.get(index + 1).toString());
        DigramFrequencyEntry digramEntry = digramFrequencies.get(digramToRemove.toString());
        if (null == digramEntry) {
            return;
        }
        if (digramEntry.getFrequency() == 1) {
            digramFrequencies.remove(digramToRemove.toString());
        } else {
            digramFrequencies.incrementFrequency(digramEntry, -1);
            if (index == digramEntry.getFirstOccurrence()) {
                for (int i = index + 1; i < string.size() - 1; ++i) {
                    StringBuffer cDigram = new StringBuffer();
                    cDigram.append(string.get(i).toString()).append(' ').append(string.get(i + 1).toString());
                    if (!digramToRemove.toString().equals(cDigram.toString())) continue;
                    digramEntry.setFirstOccurrence(i);
                    break;
                }
            }
        }
    }

    private static int countSpaces(String str) {
        if (null == str) {
            return -1;
        }
        int counter = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            ++counter;
        }
        return counter;
    }

    static {
        LOGGING_LEVEL = Level.WARN;
        consoleLogger = (Logger)LoggerFactory.getLogger(ParallelRePairImplementation.class);
        consoleLogger.setLevel(LOGGING_LEVEL);
    }
}

