/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import net.seninp.gi.repair.ParallelRePairRule;
import net.seninp.gi.repair.RePairSymbol;

public class ParallelGrammarKeeper {
    private static final char SPACE = ' ';
    private static final char THE_R = 'R';
    protected AtomicInteger numRules = new AtomicInteger(1);
    protected Hashtable<Integer, ParallelRePairRule> theRules = new Hashtable();
    private long id;
    protected String r0String;
    protected String r0ExpandedString;
    protected ArrayList<RePairSymbol> workString;

    public ParallelGrammarKeeper(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setWorkString(ArrayList<RePairSymbol> string) {
        this.workString = string;
    }

    public void setR0String(String string) {
        this.r0String = string;
    }

    public String getR0ExpandedString() {
        return this.r0ExpandedString;
    }

    public void addExistingRule(ParallelRePairRule r) {
        r.grammarHandler = this;
        if (this.theRules.containsKey(r.ruleNumber)) {
            this.theRules.put(r.ruleNumber, r);
        } else {
            this.theRules.put(r.ruleNumber, r);
            this.numRules.set(this.theRules.size() + 1);
        }
    }

    public void expandRules() {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.theRules.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            ParallelRePairRule rr = this.theRules.get(key);
            String resultString = rr.toRuleString();
            int currentSearchStart = resultString.indexOf(82);
            while (currentSearchStart >= 0) {
                int spaceIdx = resultString.indexOf(" ", currentSearchStart);
                String ruleName = resultString.substring(currentSearchStart, spaceIdx + 1);
                Integer ruleId = Integer.valueOf(ruleName.substring(1, ruleName.length() - 1));
                ParallelRePairRule rule = this.theRules.get(ruleId);
                if (rule != null) {
                    resultString = rule.expandedRuleString.charAt(rule.expandedRuleString.length() - 1) == ' ' ? resultString.replaceAll(ruleName, rule.expandedRuleString) : resultString.replaceAll(ruleName, rule.expandedRuleString + ' ');
                }
                currentSearchStart = resultString.indexOf(82, spaceIdx);
            }
            rr.setExpandedRule(resultString.trim());
        }
    }

    public void expandR0() {
        String finalString = this.r0String;
        int currentSearchStart = finalString.indexOf(82);
        while (currentSearchStart >= 0) {
            int spaceIdx = finalString.indexOf(" ", currentSearchStart + 1);
            String ruleName = finalString.substring(currentSearchStart, spaceIdx + 1);
            Integer ruleId = Integer.valueOf(ruleName.substring(1, ruleName.length() - 1));
            ParallelRePairRule rr = this.theRules.get(ruleId);
            finalString = null == rr.expandedRuleString ? finalString.replaceAll(ruleName, this.theRules.get(ruleId).toRuleString()) : finalString.replaceAll(ruleName, this.theRules.get((Object)ruleId).expandedRuleString + ' ');
            currentSearchStart = finalString.indexOf(82);
        }
        this.r0ExpandedString = finalString;
    }

    public String toGrammarString() {
        StringBuffer sb = new StringBuffer();
        System.out.println("R0 -> " + this.r0String);
        for (int i = 1; i < this.theRules.size(); ++i) {
            ParallelRePairRule r = this.theRules.get(i);
            sb.append("R").append(r.ruleNumber).append(" -> ").append(r.toRuleString()).append(" : ").append(r.expandedRuleString).append(", ").append(r.positions).append("\n");
        }
        return sb.toString();
    }
}

