/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import net.seninp.gi.repair.DigramFrequencyEntry;

public class DigramFrequencies {
    private HashMap<String, DigramFrequencyEntry> digramsToEntries = new HashMap();
    private SortedMap<Integer, ArrayList<DigramFrequencyEntry>> bucketsToEntries = new TreeMap<Integer, ArrayList<DigramFrequencyEntry>>();

    public void put(DigramFrequencyEntry digramFrequencyEntry) {
        this.digramsToEntries.put(digramFrequencyEntry.getDigram(), digramFrequencyEntry);
        Integer freq = digramFrequencyEntry.getFrequency();
        ArrayList<DigramFrequencyEntry> bucket = (ArrayList<DigramFrequencyEntry>)this.bucketsToEntries.get(freq);
        if (null == bucket) {
            bucket = new ArrayList<DigramFrequencyEntry>();
            this.bucketsToEntries.put(freq, bucket);
        }
        bucket.add(digramFrequencyEntry);
    }

    public DigramFrequencyEntry get(String string) {
        return this.digramsToEntries.get(string);
    }

    public void incrementFrequency(DigramFrequencyEntry entry, int increment) {
        ArrayList oldBucket = (ArrayList)this.bucketsToEntries.get(entry.getFrequency());
        oldBucket.remove(entry);
        if (oldBucket.isEmpty()) {
            this.bucketsToEntries.remove(entry.getFrequency());
        }
        int newFreq = entry.getFrequency() + increment;
        entry.setFrequency(newFreq);
        ArrayList<DigramFrequencyEntry> bucket = (ArrayList<DigramFrequencyEntry>)this.bucketsToEntries.get(newFreq);
        if (null == bucket) {
            bucket = new ArrayList<DigramFrequencyEntry>();
            this.bucketsToEntries.put(newFreq, bucket);
        }
        bucket.add(entry);
    }

    public DigramFrequencyEntry getTop() {
        if (this.bucketsToEntries.keySet().isEmpty()) {
            return null;
        }
        Integer maxBucket = Collections.max(this.bucketsToEntries.keySet());
        return (DigramFrequencyEntry)((ArrayList)this.bucketsToEntries.get(maxBucket)).get(0);
    }

    public void remove(String digramStr) {
        DigramFrequencyEntry entry = this.digramsToEntries.get(digramStr);
        if (null == entry) {
            return;
        }
        int freq = entry.getFrequency();
        ArrayList bucket = (ArrayList)this.bucketsToEntries.get(freq);
        if (!bucket.remove(entry)) {
            throw new RuntimeException("There was an error!");
        }
        if (bucket.isEmpty()) {
            this.bucketsToEntries.remove(freq);
        }
        this.digramsToEntries.remove(digramStr);
        entry = null;
    }

    public int size() {
        return this.digramsToEntries.size();
    }

    public HashMap<String, DigramFrequencyEntry> getEntries() {
        return this.digramsToEntries;
    }
}

