/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi;

public class RuleInterval
implements Comparable<RuleInterval> {
    public int startPos;
    public int endPos;
    public double coverage;
    public int id;

    public RuleInterval() {
        this.startPos = -1;
        this.endPos = -1;
    }

    public RuleInterval(int startPos, int endPos) {
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public RuleInterval(int id, int startPos, int endPos, double coverage) {
        this.id = id;
        this.startPos = startPos;
        this.endPos = endPos;
        this.coverage = coverage;
    }

    public void setStartPos(int startPos) {
        this.startPos = startPos;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setEndPos(int endPos) {
        this.endPos = endPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    public String toString() {
        return "[" + this.startPos + "-" + this.endPos + "]";
    }

    public int getLength() {
        return this.endPos - this.startPos;
    }

    @Override
    public int compareTo(RuleInterval arg0) {
        return Integer.valueOf(this.getLength()).compareTo(arg0.getLength());
    }

    public void setId(int ruleIndex) {
        this.id = ruleIndex;
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.coverage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.endPos;
        result = 31 * result + this.id;
        result = 31 * result + this.startPos;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleInterval other = (RuleInterval)obj;
        if (Double.doubleToLongBits(this.coverage) != Double.doubleToLongBits(other.coverage)) {
            return false;
        }
        if (this.endPos != other.endPos) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return this.startPos == other.startPos;
    }
}

