/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi;

public enum GIAlgorithm {
    SEQUITUR(0),
    REPAIR(1);

    private final int algIndex;

    private GIAlgorithm(int algIdx) {
        this.algIndex = algIdx;
    }

    public int toAlgIndex() {
        return this.algIndex;
    }

    public static GIAlgorithm fromValue(int value) {
        if (0 == value) {
            return SEQUITUR;
        }
        if (1 == value) {
            return REPAIR;
        }
        throw new RuntimeException("Unknown index:" + value);
    }

    public static GIAlgorithm fromValue(String value) {
        if ("sequitur".equalsIgnoreCase(value) || "s".equalsIgnoreCase(value)) {
            return SEQUITUR;
        }
        if ("repair".equalsIgnoreCase(value) || "re-pair".equalsIgnoreCase(value) || "r".equalsIgnoreCase(value)) {
            return REPAIR;
        }
        throw new RuntimeException("Unknown index:" + value);
    }

    public String toString() {
        switch (this.algIndex) {
            case 0: {
                return "Sequitur";
            }
            case 1: {
                return "Re-Pair";
            }
        }
        throw new RuntimeException("Unknown index:" + this.algIndex);
    }
}

