/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.resolver;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Scanner;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.impl.ModuleIdentifier;
import org.vertx.java.platform.impl.resolver.MavenResolution;
import org.vertx.java.platform.impl.resolver.RepoResolver;

public class MavenLocalRepoResolver
implements RepoResolver {
    private static final Logger log = LoggerFactory.getLogger(MavenLocalRepoResolver.class);
    private final String repoID;
    private static final String homeDir = System.getProperty("user.home");

    public MavenLocalRepoResolver(String repoID) {
        this.repoID = MavenLocalRepoResolver.expandHome(repoID);
    }

    private static String expandHome(String repo) {
        return repo.replace("~", homeDir);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private boolean getModuleForMetaData(String filename, ModuleIdentifier id, File metaDataFile, String uriRoot) {
        try {
            Throwable throwable = null;
            try (Scanner scanner = new Scanner(metaDataFile).useDelimiter("\\A");){
                block25: {
                    String data = scanner.next();
                    String fileName = MavenResolution.getResourceName(data, this.repoID, id, uriRoot, true);
                    File file = new File(fileName);
                    if (!file.exists()) {
                        fileName = MavenResolution.getResourceName(data, this.repoID, id, uriRoot, false);
                        file = new File(fileName);
                    }
                    if (!file.exists()) break block25;
                    try {
                        Files.copy(file.toPath(), Paths.get(filename, new String[0]), new CopyOption[0]);
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException e) {
                        boolean x2;
                        block23: {
                            block24: {
                                log.error("Failed to copy file", e);
                                x2 = false;
                                if (scanner == null) break block23;
                                if (throwable == null) break block24;
                                try {
                                    scanner.close();
                                }
                                catch (Throwable x22) {
                                    throwable.addSuppressed(x22);
                                }
                                break block23;
                            }
                            scanner.close();
                        }
                        return x2;
                    }
                }
                boolean bl = false;
                return bl;
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to read file", e);
            return false;
        }
    }

    @Override
    public boolean getModule(String filename, ModuleIdentifier moduleIdentifier) {
        String uriRoot = MavenResolution.getMavenURI(moduleIdentifier);
        File localMetaDataFile = new File(this.repoID + '/' + uriRoot + "maven-metadata-local.xml");
        File remoteMetaDataFile = new File(this.repoID + '/' + uriRoot + "maven-metadata-remote.xml");
        boolean lExists = localMetaDataFile.exists();
        boolean rExists = remoteMetaDataFile.exists();
        if (lExists && !rExists || lExists && rExists && localMetaDataFile.lastModified() >= remoteMetaDataFile.lastModified()) {
            return this.getModuleForMetaData(filename, moduleIdentifier, localMetaDataFile, uriRoot);
        }
        if (rExists) {
            return this.getModuleForMetaData(filename, moduleIdentifier, remoteMetaDataFile, uriRoot);
        }
        String prefix = this.repoID + '/' + uriRoot + moduleIdentifier.getName() + '-' + moduleIdentifier.getVersion();
        File nonSnapshotFile = new File(prefix + "-mod.zip");
        if (!nonSnapshotFile.exists()) {
            nonSnapshotFile = new File(prefix + ".zip");
        }
        if (nonSnapshotFile.exists()) {
            try {
                Files.copy(nonSnapshotFile.toPath(), Paths.get(filename, new String[0]), new CopyOption[0]);
                return true;
            }
            catch (IOException e) {
                log.error("Failed to copy file", e);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isOldStyle() {
        return false;
    }
}

