/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FatJarStarter
implements Runnable {
    private static final String CP_SEPARATOR = System.getProperty("path.separator");
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String CLUSTERMANAGER_FACTORY_PROP_NAME = "vertx.clusterManagerFactory";
    private static final int BUFFER_SIZE = 4096;
    private File vertxHome;
    private URLClassLoader platformLoader;

    public static void main(String[] args) {
        try {
            new FatJarStarter().go(args);
        }
        catch (Exception e) {
            System.err.println("Failed to run fat jar");
            e.printStackTrace();
        }
    }

    private FatJarStarter() {
    }

    private void go(String[] args) throws Exception {
        URLClassLoader urlc = (URLClassLoader)FatJarStarter.class.getClassLoader();
        int totalUrlsCount = urlc.getURLs().length;
        String fileName = urlc.getURLs()[totalUrlsCount - 1].toURI().getPath();
        String classpath = null;
        boolean hasCP = false;
        for (String arg : args) {
            if (hasCP) {
                classpath = arg;
                break;
            }
            if (!"-cp".equals(arg) && !"-classpath".equals(arg)) continue;
            hasCP = true;
        }
        this.vertxHome = this.unzipIntoTmpDir(fileName);
        File modsDir = new File(this.vertxHome, "mods");
        File manifest = new File(new File(this.vertxHome, "META-INF"), "MANIFEST.MF");
        String moduleID = null;
        try (Scanner scanner = new Scanner(manifest);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.startsWith("Vertx-Module-ID")) continue;
                moduleID = line.substring(line.lastIndexOf(58) + 1).trim();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read module id from manifest", e);
        }
        if (moduleID == null) {
            throw new NullPointerException("moduleID");
        }
        File libDir = new File(this.vertxHome, "lib");
        File[] files = libDir.listFiles();
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classpath != null) {
            urls.addAll(this.splitCP(classpath));
        }
        for (File file : files) {
            if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
            urls.add(file.toURI().toURL());
        }
        File platformLibDir = new File(new File(modsDir, moduleID), "platform_lib");
        urls.add(platformLibDir.toURI().toURL());
        if (platformLibDir.exists() && (files = platformLibDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                urls.add(file.toURI().toURL());
            }
        }
        this.platformLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), urlc.getParent());
        Thread.currentThread().setContextClassLoader(this.platformLoader);
        Class<?> starterClass = this.platformLoader.loadClass("org.vertx.java.platform.impl.cli.Starter");
        ArrayList<String> largs = new ArrayList<String>();
        largs.add("runmod");
        largs.add(moduleID);
        boolean ignoring = false;
        for (String arg : args) {
            if (arg.equals("-cp")) {
                ignoring = true;
                continue;
            }
            if (!ignoring) {
                largs.add(arg);
                continue;
            }
            ignoring = false;
        }
        System.setProperty("vertx.home", this.vertxHome.getAbsolutePath());
        System.setProperty("vertx.mods", modsDir.getAbsolutePath());
        if (System.getProperty(CLUSTERMANAGER_FACTORY_PROP_NAME) == null) {
            System.setProperty(CLUSTERMANAGER_FACTORY_PROP_NAME, "org.vertx.java.spi.cluster.impl.hazelcast.HazelcastClusterManagerFactory");
        }
        Method afterShutdownMeth = starterClass.getMethod("addAfterShutdownTask", Runnable.class);
        afterShutdownMeth.invoke(null, this);
        Method meth = starterClass.getMethod("main", String[].class);
        String[] theargs = largs.toArray(new String[largs.size()]);
        meth.invoke(null, new Object[]{theargs});
    }

    private List<URL> splitCP(String cp) {
        String[] parts = cp.contains(CP_SEPARATOR) ? cp.split(CP_SEPARATOR) : new String[]{cp};
        ArrayList<URL> classpath = new ArrayList<URL>();
        for (String part : parts) {
            try {
                URL url = new File(part).toURI().toURL();
                classpath.add(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid path " + part + " in cp " + cp);
            }
        }
        return classpath;
    }

    @Override
    public void run() {
        try {
            this.platformLoader.close();
            this.deleteDir(this.vertxHome);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String generateTmpFileName() {
        return TEMP_DIR + FILE_SEP + "vertx-" + UUID.randomUUID().toString();
    }

    private File unzipIntoTmpDir(String fileName) throws Exception {
        String tdir = this.generateTmpFileName();
        File tdest = new File(tdir);
        if (!tdest.mkdir()) {
            throw new IllegalStateException("Failed to create directory " + tdest);
        }
        this.unzipJar(tdest, fileName);
        return tdest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzipJar(File directory, String jarName) throws Exception {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(jarName));
             ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName.isEmpty()) continue;
                if (entry.isDirectory()) {
                    if (new File(directory, entryName).mkdir()) continue;
                    throw new IllegalStateException("Failed to create directory");
                }
                byte[] buff = new byte[4096];
                FilterOutputStream dest = null;
                try {
                    int count;
                    File fentry = new File(directory, entryName);
                    File dir = fentry.getParentFile();
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(fentry);
                    dest = new BufferedOutputStream(fos, 4096);
                    while ((count = zis.read(buff, 0, 4096)) != -1) {
                        ((BufferedOutputStream)dest).write(buff, 0, count);
                    }
                    ((BufferedOutputStream)dest).flush();
                }
                finally {
                    if (dest == null) continue;
                    dest.close();
                }
            }
            return;
        }
    }

    private void deleteDir(File file) throws Exception {
        Path source = file.toPath();
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw e;
            }
        });
    }
}

