/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.shareddata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.shareddata.ConcurrentSharedMap;
import org.vertx.java.core.shareddata.impl.Checker;

public class SharedMap<K, V>
implements ConcurrentSharedMap<K, V> {
    private static final Logger log = LoggerFactory.getLogger(SharedMap.class);
    private final ConcurrentMap<K, V> map = new ConcurrentHashMap();

    @Override
    public V putIfAbsent(K k, V v) {
        Checker.checkType(k);
        Checker.checkType(v);
        return this.map.putIfAbsent(k, v);
    }

    @Override
    public boolean remove(Object o, Object o1) {
        return this.map.remove(o, o1);
    }

    @Override
    public boolean replace(K k, V v, V v1) {
        Checker.checkType(v1);
        return this.map.replace(k, v, v1);
    }

    @Override
    public V replace(K k, V v) {
        Checker.checkType(v);
        V ret = this.map.replace(k, v);
        return Checker.copyIfRequired(ret);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    @Override
    public V get(Object o) {
        return Checker.copyIfRequired(this.map.get(o));
    }

    @Override
    public V put(K k, V v) {
        Checker.checkType(k);
        Checker.checkType(v);
        return this.map.put(k, v);
    }

    @Override
    public V remove(Object o) {
        return Checker.copyIfRequired(this.map.remove(o));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Checker.checkType(entry.getKey());
            Checker.checkType(entry.getValue());
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        HashSet copied = new HashSet();
        for (Object k : this.map.keySet()) {
            copied.add(Checker.copyIfRequired(k));
        }
        return copied;
    }

    @Override
    public Collection<V> values() {
        ArrayList copied = new ArrayList();
        for (Object v : this.map.values()) {
            copied.add(Checker.copyIfRequired(v));
        }
        return copied;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry entry : this.map.entrySet()) {
            entries.add(new Entry(entry));
        }
        return entries;
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        final Map.Entry<K, V> internalEntry;

        Entry(Map.Entry<K, V> internalEntry) {
            this.internalEntry = internalEntry;
        }

        @Override
        public K getKey() {
            return Checker.copyIfRequired(this.internalEntry.getKey());
        }

        @Override
        public V getValue() {
            return Checker.copyIfRequired(this.internalEntry.getValue());
        }

        @Override
        public V setValue(V value) {
            V old = this.internalEntry.getValue();
            Checker.checkType(value);
            this.internalEntry.setValue(value);
            return old;
        }
    }
}

