/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.json;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.vertx.java.core.VertxException;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public abstract class JsonElement
implements Serializable {
    public boolean isArray() {
        return this instanceof JsonArray;
    }

    public boolean isObject() {
        return this instanceof JsonObject;
    }

    public JsonArray asArray() {
        return (JsonArray)this;
    }

    public JsonObject asObject() {
        return (JsonObject)this;
    }

    protected Map<String, Object> convertMap(Map<String, Object> map) {
        LinkedHashMap<String, Object> converted = new LinkedHashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                Map jm = (Map)obj;
                converted.put(entry.getKey(), this.convertMap(jm));
                continue;
            }
            if (obj instanceof List) {
                List list = (List)obj;
                converted.put(entry.getKey(), this.convertList(list));
                continue;
            }
            if (obj == null || obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
                converted.put(entry.getKey(), obj);
                continue;
            }
            throw new VertxException("Cannot have objects of class " + obj.getClass() + " in JSON");
        }
        return converted;
    }

    protected List<Object> convertList(List<?> list) {
        ArrayList<Object> arr = new ArrayList<Object>(list.size());
        for (Object obj : list) {
            if (obj instanceof Map) {
                arr.add(this.convertMap((Map)obj));
                continue;
            }
            if (obj instanceof List) {
                arr.add(this.convertList((List)obj));
                continue;
            }
            if (obj == null || obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
                arr.add(obj);
                continue;
            }
            throw new VertxException("Cannot have objects of class " + obj.getClass() + " in JSON");
        }
        return arr;
    }
}

