/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.Map;
import org.vertx.java.core.http.WebSocketFrame;
import org.vertx.java.core.http.impl.AssembledLastHttpContent;
import org.vertx.java.core.http.impl.ws.DefaultWebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrameInternal;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.ConnectionBase;
import org.vertx.java.core.net.impl.VertxHandler;

public abstract class VertxHttpHandler<C extends ConnectionBase>
extends VertxHandler<C> {
    private final VertxInternal vertx;

    protected VertxHttpHandler(VertxInternal vertx, Map<Channel, C> connectionMap) {
        super(vertx, connectionMap);
        this.vertx = vertx;
    }

    private static ByteBuf safeBuffer(ByteBufHolder holder, ByteBufAllocator allocator) {
        return VertxHttpHandler.safeBuffer(holder.content(), allocator);
    }

    @Override
    protected void channelRead(C connection, DefaultContext context, ChannelHandlerContext chctx, Object msg) throws Exception {
        DecoderResult result;
        if (msg instanceof HttpObject && (result = ((HttpObject)msg).getDecoderResult()).isFailure()) {
            chctx.pipeline().fireExceptionCaught(result.cause());
            return;
        }
        if (connection != null) {
            Channel ch = chctx.channel();
            if (context.isOnCorrectWorker(ch.eventLoop())) {
                try {
                    this.vertx.setContext(context);
                    this.doMessageReceived(connection, chctx, msg);
                }
                catch (Throwable t) {
                    context.reportException(t);
                }
            } else {
                context.execute(new Runnable((ConnectionBase)connection, chctx, msg, context){
                    final /* synthetic */ ConnectionBase val$connection;
                    final /* synthetic */ ChannelHandlerContext val$chctx;
                    final /* synthetic */ Object val$msg;
                    final /* synthetic */ DefaultContext val$context;
                    {
                        this.val$connection = connectionBase;
                        this.val$chctx = channelHandlerContext;
                        this.val$msg = object;
                        this.val$context = defaultContext;
                    }

                    @Override
                    public void run() {
                        try {
                            VertxHttpHandler.this.doMessageReceived(this.val$connection, this.val$chctx, this.val$msg);
                        }
                        catch (Throwable t) {
                            this.val$context.reportException(t);
                        }
                    }
                });
            }
        } else {
            try {
                this.doMessageReceived(connection, chctx, msg);
            }
            catch (Throwable t) {
                chctx.pipeline().fireExceptionCaught(t);
            }
        }
    }

    @Override
    protected Object safeObject(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            ByteBuf buf = content.content();
            if (buf != Unpooled.EMPTY_BUFFER && buf.isDirect()) {
                ByteBuf newBuf = VertxHttpHandler.safeBuffer(content, allocator);
                if (msg instanceof LastHttpContent) {
                    LastHttpContent last = (LastHttpContent)msg;
                    return new AssembledLastHttpContent(newBuf, last.trailingHeaders(), last.getDecoderResult());
                }
                return new DefaultHttpContent(newBuf);
            }
        } else if (msg instanceof WebSocketFrame) {
            WebSocketFrame.FrameType frameType;
            ByteBuf payload = VertxHttpHandler.safeBuffer((WebSocketFrame)msg, allocator);
            boolean isFinal = ((WebSocketFrame)msg).isFinalFragment();
            if (msg instanceof BinaryWebSocketFrame) {
                frameType = WebSocketFrame.FrameType.BINARY;
            } else if (msg instanceof CloseWebSocketFrame) {
                frameType = WebSocketFrame.FrameType.CLOSE;
            } else if (msg instanceof PingWebSocketFrame) {
                frameType = WebSocketFrame.FrameType.PING;
            } else if (msg instanceof PongWebSocketFrame) {
                frameType = WebSocketFrame.FrameType.PONG;
            } else if (msg instanceof TextWebSocketFrame) {
                frameType = WebSocketFrame.FrameType.TEXT;
            } else if (msg instanceof ContinuationWebSocketFrame) {
                frameType = WebSocketFrame.FrameType.CONTINUATION;
            } else {
                throw new IllegalStateException("Unsupported websocket msg " + msg);
            }
            return new DefaultWebSocketFrame(frameType, payload, isFinal);
        }
        return msg;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof WebSocketFrameInternal) {
            WebSocketFrameInternal frame = (WebSocketFrameInternal)msg;
            ByteBuf buf = frame.getBinaryData();
            if (buf != Unpooled.EMPTY_BUFFER) {
                buf = VertxHttpHandler.safeBuffer(buf, ctx.alloc());
            }
            switch (frame.type()) {
                case BINARY: {
                    msg = new BinaryWebSocketFrame(buf);
                    break;
                }
                case TEXT: {
                    msg = new TextWebSocketFrame(buf);
                    break;
                }
                case CLOSE: {
                    msg = new CloseWebSocketFrame(true, 0, buf);
                    break;
                }
                case CONTINUATION: {
                    msg = new ContinuationWebSocketFrame(buf);
                    break;
                }
                case PONG: {
                    msg = new PongWebSocketFrame(buf);
                    break;
                }
                case PING: {
                    msg = new PingWebSocketFrame(buf);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported websocket msg " + msg);
                }
            }
        }
        ctx.write(msg, promise);
    }

    protected abstract void doMessageReceived(C var1, ChannelHandlerContext var2, Object var3) throws Exception;
}

