/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelGroupFutureListener;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.http.HttpHeaders;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.WebSocketFrame;
import org.vertx.java.core.http.impl.DefaultServerWebSocket;
import org.vertx.java.core.http.impl.HttpChunkContentCompressor;
import org.vertx.java.core.http.impl.HttpHeadersAdapter;
import org.vertx.java.core.http.impl.ServerConnection;
import org.vertx.java.core.http.impl.VertxHttpHandler;
import org.vertx.java.core.http.impl.VertxHttpResponseEncoder;
import org.vertx.java.core.http.impl.cgbystrom.FlashPolicyHandler;
import org.vertx.java.core.http.impl.ws.DefaultWebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrameInternal;
import org.vertx.java.core.impl.Closeable;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.impl.HandlerHolder;
import org.vertx.java.core.net.impl.HandlerManager;
import org.vertx.java.core.net.impl.ServerID;
import org.vertx.java.core.net.impl.TCPSSLHelper;
import org.vertx.java.core.net.impl.VertxEventLoopGroup;

public class DefaultHttpServer
implements HttpServer,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpServer.class);
    final VertxInternal vertx;
    final TCPSSLHelper tcpHelper = new TCPSSLHelper();
    private final DefaultContext actualCtx;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<ServerWebSocket> wsHandler;
    final Map<Channel, ServerConnection> connectionMap = new ConcurrentHashMap<Channel, ServerConnection>();
    private ChannelGroup serverChannelGroup;
    private boolean listening;
    private String serverOrigin;
    private boolean compressionSupported;
    private int maxWebSocketFrameSize = 65536;
    private Set<String> webSocketSubProtocols = Collections.unmodifiableSet(Collections.emptySet());
    private ChannelFuture bindFuture;
    private ServerID id;
    private DefaultHttpServer actualServer;
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private HandlerManager<HttpServerRequest> reqHandlerManager = new HandlerManager(this.availableWorkers);
    private HandlerManager<ServerWebSocket> wsHandlerManager = new HandlerManager(this.availableWorkers);

    public DefaultHttpServer(VertxInternal vertx) {
        this.vertx = vertx;
        this.actualCtx = vertx.getOrCreateContext();
        this.actualCtx.addCloseHook(this);
        this.tcpHelper.setReuseAddress(true);
    }

    @Override
    public HttpServer requestHandler(Handler<HttpServerRequest> requestHandler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.requestHandler = requestHandler;
        return this;
    }

    @Override
    public Handler<HttpServerRequest> requestHandler() {
        return this.requestHandler;
    }

    @Override
    public HttpServer websocketHandler(Handler<ServerWebSocket> wsHandler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.wsHandler = wsHandler;
        return this;
    }

    @Override
    public Handler<ServerWebSocket> websocketHandler() {
        return this.wsHandler;
    }

    @Override
    public HttpServer listen(int port) {
        this.listen(port, "0.0.0.0", null);
        return this;
    }

    @Override
    public HttpServer listen(int port, String host) {
        this.listen(port, host, null);
        return this;
    }

    @Override
    public HttpServer listen(int port, Handler<AsyncResult<HttpServer>> listenHandler) {
        this.listen(port, "0.0.0.0", listenHandler);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServer listen(int port, String host, final Handler<AsyncResult<HttpServer>> listenHandler) {
        if (this.requestHandler == null && this.wsHandler == null) {
            throw new IllegalStateException("Set request or websocket handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listening = true;
        Map<ServerID, DefaultHttpServer> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            this.id = new ServerID(port, host);
            this.serverOrigin = (this.isSSL() ? "https" : "http") + "://" + host + ":" + port;
            DefaultHttpServer shared = this.vertx.sharedHttpServers().get(this.id);
            if (shared == null) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group(this.availableWorkers);
                bootstrap.channel(NioServerSocketChannel.class);
                this.tcpHelper.applyConnectionOptions(bootstrap);
                this.tcpHelper.checkSSL(this.vertx);
                bootstrap.childHandler(new ChannelInitializer<Channel>(){

                    @Override
                    protected void initChannel(Channel ch) throws Exception {
                        ChannelPipeline pipeline = ch.pipeline();
                        if (DefaultHttpServer.this.tcpHelper.isSSL()) {
                            pipeline.addLast("ssl", (ChannelHandler)DefaultHttpServer.this.tcpHelper.createSslHandler(DefaultHttpServer.this.vertx, false));
                        }
                        pipeline.addLast("flashpolicy", (ChannelHandler)new FlashPolicyHandler());
                        pipeline.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, 8192, false));
                        pipeline.addLast("httpEncoder", (ChannelHandler)new VertxHttpResponseEncoder());
                        if (DefaultHttpServer.this.compressionSupported) {
                            pipeline.addLast("deflater", (ChannelHandler)new HttpChunkContentCompressor());
                        }
                        if (DefaultHttpServer.this.tcpHelper.isSSL() || DefaultHttpServer.this.compressionSupported) {
                            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                        }
                        pipeline.addLast("handler", (ChannelHandler)new ServerHandler());
                    }
                });
                this.addHandlers(this);
                try {
                    this.bindFuture = bootstrap.bind(new InetSocketAddress(InetAddress.getByName(host), port));
                    Channel serverChannel = this.bindFuture.channel();
                    this.serverChannelGroup.add(serverChannel);
                    this.bindFuture.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            if (!channelFuture.isSuccess()) {
                                DefaultHttpServer.this.vertx.sharedHttpServers().remove(DefaultHttpServer.this.id);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(new VoidHandler(){

                            @Override
                            protected void handle() {
                                listenHandler.handle(new DefaultFutureResult<Throwable>(t));
                            }
                        });
                    } else {
                        this.actualCtx.reportException(t);
                    }
                    this.listening = false;
                    return this;
                }
                this.vertx.sharedHttpServers().put(this.id, this);
                this.actualServer = this;
            } else {
                this.actualServer = shared;
                this.addHandlers(this.actualServer);
            }
            this.actualServer.bindFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (listenHandler != null) {
                        DefaultFutureResult<Object> res;
                        if (future.isSuccess()) {
                            res = new DefaultFutureResult<DefaultHttpServer>(DefaultHttpServer.this);
                        } else {
                            res = new DefaultFutureResult<Throwable>(future.cause());
                            DefaultHttpServer.this.listening = false;
                        }
                        DefaultHttpServer.this.actualCtx.execute(future.channel().eventLoop(), new Runnable(){

                            @Override
                            public void run() {
                                listenHandler.handle(res);
                            }
                        });
                    } else if (!future.isSuccess()) {
                        DefaultHttpServer.this.listening = false;
                        DefaultHttpServer.this.actualCtx.reportException(future.cause());
                    }
                }
            });
        }
        return this;
    }

    private void addHandlers(DefaultHttpServer server) {
        if (this.requestHandler != null) {
            server.reqHandlerManager.addHandler(this.requestHandler, this.actualCtx);
        }
        if (this.wsHandler != null) {
            server.wsHandlerManager.addHandler(this.wsHandler, this.actualCtx);
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Handler<AsyncResult<Void>> done) {
        if (!this.listening) {
            this.executeCloseDone(this.actualCtx, done, null);
            return;
        }
        this.listening = false;
        Map<ServerID, DefaultHttpServer> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            if (this.actualServer != null) {
                if (this.requestHandler != null) {
                    this.actualServer.reqHandlerManager.removeHandler(this.requestHandler, this.actualCtx);
                }
                if (this.wsHandler != null) {
                    this.actualServer.wsHandlerManager.removeHandler(this.wsHandler, this.actualCtx);
                }
                if (this.actualServer.reqHandlerManager.hasHandlers() || this.actualServer.wsHandlerManager.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(this.actualCtx, done, null);
                    }
                } else {
                    this.actualServer.actualClose(this.actualCtx, done);
                }
            }
        }
        this.requestHandler = null;
        this.wsHandler = null;
        this.actualCtx.removeCloseHook(this);
    }

    @Override
    public HttpServer setSSL(boolean ssl) {
        this.checkListening();
        this.tcpHelper.setSSL(ssl);
        return this;
    }

    @Override
    public HttpServer setSSLContext(SSLContext sslContext) {
        this.checkListening();
        this.tcpHelper.setExternalSSLContext(sslContext);
        return this;
    }

    @Override
    public HttpServer setKeyStorePath(String path) {
        this.checkListening();
        this.tcpHelper.setKeyStorePath(path);
        return this;
    }

    @Override
    public HttpServer setKeyStorePassword(String pwd) {
        this.checkListening();
        this.tcpHelper.setKeyStorePassword(pwd);
        return this;
    }

    @Override
    public HttpServer setTrustStorePath(String path) {
        this.checkListening();
        this.tcpHelper.setTrustStorePath(path);
        return this;
    }

    @Override
    public HttpServer setTrustStorePassword(String pwd) {
        this.checkListening();
        this.tcpHelper.setTrustStorePassword(pwd);
        return this;
    }

    @Override
    public HttpServer setClientAuthRequired(boolean required) {
        this.checkListening();
        this.tcpHelper.setClientAuthRequired(required);
        return this;
    }

    @Override
    public HttpServer setTCPNoDelay(boolean tcpNoDelay) {
        this.checkListening();
        this.tcpHelper.setTCPNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public HttpServer setSendBufferSize(int size) {
        this.checkListening();
        this.tcpHelper.setSendBufferSize(size);
        return this;
    }

    @Override
    public HttpServer setReceiveBufferSize(int size) {
        this.checkListening();
        this.tcpHelper.setReceiveBufferSize(size);
        return this;
    }

    @Override
    public HttpServer setTCPKeepAlive(boolean keepAlive) {
        this.checkListening();
        this.tcpHelper.setTCPKeepAlive(keepAlive);
        return this;
    }

    @Override
    public HttpServer setReuseAddress(boolean reuse) {
        this.checkListening();
        this.tcpHelper.setReuseAddress(reuse);
        return this;
    }

    @Override
    public HttpServer setSoLinger(int linger) {
        this.checkListening();
        this.tcpHelper.setSoLinger(linger);
        return this;
    }

    @Override
    public HttpServer setTrafficClass(int trafficClass) {
        this.checkListening();
        this.tcpHelper.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public HttpServer setAcceptBacklog(int backlog) {
        this.checkListening();
        this.tcpHelper.setAcceptBacklog(backlog);
        return this;
    }

    @Override
    public boolean isTCPNoDelay() {
        return this.tcpHelper.isTCPNoDelay();
    }

    @Override
    public int getSendBufferSize() {
        return this.tcpHelper.getSendBufferSize();
    }

    @Override
    public int getReceiveBufferSize() {
        return this.tcpHelper.getReceiveBufferSize();
    }

    @Override
    public boolean isTCPKeepAlive() {
        return this.tcpHelper.isTCPKeepAlive();
    }

    @Override
    public boolean isReuseAddress() {
        return this.tcpHelper.isReuseAddress();
    }

    @Override
    public int getSoLinger() {
        return this.tcpHelper.getSoLinger();
    }

    @Override
    public int getTrafficClass() {
        return this.tcpHelper.getTrafficClass();
    }

    @Override
    public int getAcceptBacklog() {
        return this.tcpHelper.getAcceptBacklog();
    }

    @Override
    public boolean isSSL() {
        return this.tcpHelper.isSSL();
    }

    @Override
    public String getKeyStorePath() {
        return this.tcpHelper.getKeyStorePath();
    }

    @Override
    public String getKeyStorePassword() {
        return this.tcpHelper.getKeyStorePassword();
    }

    @Override
    public String getTrustStorePath() {
        return this.tcpHelper.getTrustStorePath();
    }

    @Override
    public String getTrustStorePassword() {
        return this.tcpHelper.getTrustStorePassword();
    }

    @Override
    public boolean isClientAuthRequired() {
        return this.tcpHelper.getClientAuth() == TCPSSLHelper.ClientAuth.REQUIRED;
    }

    @Override
    public HttpServer setUsePooledBuffers(boolean pooledBuffers) {
        this.checkListening();
        this.tcpHelper.setUsePooledBuffers(pooledBuffers);
        return this;
    }

    @Override
    public boolean isUsePooledBuffers() {
        return this.tcpHelper.isUsePooledBuffers();
    }

    @Override
    public HttpServer setCompressionSupported(boolean compressionSupported) {
        this.checkListening();
        this.compressionSupported = compressionSupported;
        return this;
    }

    @Override
    public boolean isCompressionSupported() {
        return this.compressionSupported;
    }

    @Override
    public HttpServer setMaxWebSocketFrameSize(int maxSize) {
        this.maxWebSocketFrameSize = maxSize;
        return this;
    }

    @Override
    public int getMaxWebSocketFrameSize() {
        return this.maxWebSocketFrameSize;
    }

    @Override
    public HttpServer setWebSocketSubProtocols(String ... subProtocols) {
        this.webSocketSubProtocols = subProtocols == null || subProtocols.length == 0 ? Collections.unmodifiableSet(Collections.emptySet()) : Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(subProtocols)));
        return this;
    }

    @Override
    public Set<String> getWebSocketSubProtocols() {
        return this.webSocketSubProtocols;
    }

    private void actualClose(DefaultContext closeContext, Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedHttpServers().remove(this.id);
        }
        for (ServerConnection conn : this.connectionMap.values()) {
            conn.close();
        }
        this.vertx.setContext(closeContext);
        final CountDownLatch latch = new CountDownLatch(1);
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener(new ChannelGroupFutureListener(){

            @Override
            public void operationComplete(ChannelGroupFuture channelGroupFuture) throws Exception {
                latch.countDown();
            }
        });
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.executeCloseDone(closeContext, done, fut.cause());
    }

    private void executeCloseDone(DefaultContext closeContext, final Handler<AsyncResult<Void>> done, final Exception e) {
        if (done != null) {
            closeContext.execute(new Runnable(){

                @Override
                public void run() {
                    done.handle(new DefaultFutureResult<Exception>(e));
                }
            });
        }
    }

    private void checkListening() {
        if (this.listening) {
            throw new IllegalStateException("Can't set property when server is listening");
        }
    }

    public class ServerHandler
    extends VertxHttpHandler<ServerConnection> {
        private boolean closeFrameSent;
        FullHttpRequest wsRequest;

        public ServerHandler() {
            super(DefaultHttpServer.this.vertx, DefaultHttpServer.this.connectionMap);
        }

        private void sendError(CharSequence err, HttpResponseStatus status, Channel ch) {
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
            if (status.code() == HttpResponseStatus.METHOD_NOT_ALLOWED.code()) {
                resp.headers().set(HttpHeaders.ALLOW, (Object)HttpHeaders.GET);
            }
            if (err != null) {
                resp.content().writeBytes(err.toString().getBytes(CharsetUtil.UTF_8));
                io.netty.handler.codec.http.HttpHeaders.setContentLength(resp, err.length());
            } else {
                io.netty.handler.codec.http.HttpHeaders.setContentLength(resp, 0L);
            }
            ch.writeAndFlush(resp);
        }

        @Override
        protected void doMessageReceived(ServerConnection conn, ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel ch = ctx.channel();
            if (msg instanceof HttpRequest) {
                HttpRequest request = (HttpRequest)msg;
                if (log.isTraceEnabled()) {
                    log.trace("Server received request: " + request.getUri());
                }
                if (io.netty.handler.codec.http.HttpHeaders.is100ContinueExpected(request)) {
                    ch.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
                }
                if (DefaultHttpServer.this.wsHandlerManager.hasHandlers() && request.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
                    String connectionHeader = request.headers().get(HttpHeaders.CONNECTION);
                    if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
                        this.sendError("\"Connection\" must be \"Upgrade\".", HttpResponseStatus.BAD_REQUEST, ch);
                        return;
                    }
                    if (request.getMethod() != HttpMethod.GET) {
                        this.sendError(null, HttpResponseStatus.METHOD_NOT_ALLOWED, ch);
                        return;
                    }
                    if (this.wsRequest == null) {
                        if (request instanceof FullHttpRequest) {
                            this.handshake((FullHttpRequest)request, ch, ctx);
                        } else {
                            this.wsRequest = new DefaultFullHttpRequest(request.getProtocolVersion(), request.getMethod(), request.getUri());
                            this.wsRequest.headers().set(request.headers());
                        }
                    }
                } else if (conn == null) {
                    HandlerHolder reqHandler = DefaultHttpServer.this.reqHandlerManager.chooseHandler(ch.eventLoop());
                    if (reqHandler != null) {
                        conn = new ServerConnection(DefaultHttpServer.this, ch, reqHandler.context, DefaultHttpServer.this.serverOrigin);
                        conn.requestHandler(reqHandler.handler);
                        this.connectionMap.put(ch, conn);
                        conn.handleMessage(msg);
                    }
                } else {
                    conn.handleMessage(msg);
                }
            } else if (msg instanceof WebSocketFrameInternal) {
                WebSocketFrameInternal wsFrame = (WebSocketFrameInternal)msg;
                switch (wsFrame.type()) {
                    case BINARY: 
                    case CONTINUATION: 
                    case TEXT: {
                        if (conn == null) break;
                        conn.handleMessage(msg);
                        break;
                    }
                    case PING: {
                        ch.writeAndFlush(new DefaultWebSocketFrame(WebSocketFrame.FrameType.PONG, wsFrame.getBinaryData()));
                        break;
                    }
                    case CLOSE: {
                        if (this.closeFrameSent) break;
                        ch.writeAndFlush(wsFrame).addListener(ChannelFutureListener.CLOSE);
                        this.closeFrameSent = true;
                    }
                }
            } else if (msg instanceof HttpContent) {
                if (this.wsRequest != null) {
                    this.wsRequest.content().writeBytes(((HttpContent)msg).content());
                    if (msg instanceof LastHttpContent) {
                        FullHttpRequest req = this.wsRequest;
                        this.wsRequest = null;
                        this.handshake(req, ch, ctx);
                        return;
                    }
                }
                if (conn != null) {
                    conn.handleMessage(msg);
                }
            } else {
                throw new IllegalStateException("Invalid message " + msg);
            }
        }

        private String getWebSocketLocation(ChannelPipeline pipeline, FullHttpRequest req) throws Exception {
            String prefix = pipeline.get(SslHandler.class) == null ? "ws://" : "wss://";
            URI uri = new URI(req.getUri());
            String path = uri.getRawPath();
            String loc = prefix + io.netty.handler.codec.http.HttpHeaders.getHost(req) + path;
            String query = uri.getRawQuery();
            if (query != null) {
                loc = loc + "?" + query;
            }
            return loc;
        }

        private void handshake(final FullHttpRequest request, final Channel ch, ChannelHandlerContext ctx) throws Exception {
            WebSocketServerHandshakerFactory factory;
            WebSocketServerHandshaker shake;
            String subProtocols = null;
            Set webSocketSubProtocols = DefaultHttpServer.this.webSocketSubProtocols;
            if (!webSocketSubProtocols.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                Iterator protocols = webSocketSubProtocols.iterator();
                while (protocols.hasNext()) {
                    sb.append((String)protocols.next());
                    if (!protocols.hasNext()) continue;
                    sb.append(',');
                }
                subProtocols = sb.toString();
            }
            if ((shake = (factory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(ch.pipeline(), request), subProtocols, false, DefaultHttpServer.this.maxWebSocketFrameSize)).newHandshaker(request)) == null) {
                log.error("Unrecognised websockets handshake");
                WebSocketServerHandshakerFactory.sendUnsupportedWebSocketVersionResponse(ch);
                return;
            }
            HandlerHolder firstHandler = null;
            HandlerHolder wsHandler = DefaultHttpServer.this.wsHandlerManager.chooseHandler(ch.eventLoop());
            while (wsHandler != null && firstHandler != wsHandler) {
                URI theURI;
                try {
                    theURI = new URI(request.getUri());
                }
                catch (URISyntaxException e2) {
                    throw new IllegalArgumentException("Invalid uri " + request.getUri());
                }
                final ServerConnection wsConn = new ServerConnection(DefaultHttpServer.this, ch, wsHandler.context, DefaultHttpServer.this.serverOrigin);
                wsConn.wsHandler(wsHandler.handler);
                Runnable connectRunnable = new Runnable(){

                    @Override
                    public void run() {
                        ServerHandler.this.connectionMap.put(ch, wsConn);
                        try {
                            shake.handshake(ch, request);
                        }
                        catch (WebSocketHandshakeException e) {
                            wsConn.handleException(e);
                        }
                        catch (Exception e) {
                            log.error("Failed to generate shake response", e);
                        }
                    }
                };
                DefaultServerWebSocket ws = new DefaultServerWebSocket(DefaultHttpServer.this.vertx, theURI.toString(), theURI.getPath(), theURI.getQuery(), new HttpHeadersAdapter(request.headers()), wsConn, connectRunnable);
                wsConn.handleWebsocketConnect(ws);
                if (ws.isRejected()) {
                    if (firstHandler != null) continue;
                    firstHandler = wsHandler;
                    continue;
                }
                HttpChunkContentCompressor handler = ctx.pipeline().get(HttpChunkContentCompressor.class);
                if (handler != null) {
                    ctx.pipeline().remove(handler);
                }
                ws.connectNow();
                return;
            }
            ch.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_GATEWAY));
        }
    }
}

