/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServerRequest;

public class RouteMatcher
implements Handler<HttpServerRequest> {
    private final List<PatternBinding> getBindings = new ArrayList<PatternBinding>();
    private final List<PatternBinding> putBindings = new ArrayList<PatternBinding>();
    private final List<PatternBinding> postBindings = new ArrayList<PatternBinding>();
    private final List<PatternBinding> deleteBindings = new ArrayList<PatternBinding>();
    private final List<PatternBinding> optionsBindings = new ArrayList<PatternBinding>();
    private final List<PatternBinding> headBindings = new ArrayList<PatternBinding>();
    private final List<PatternBinding> traceBindings = new ArrayList<PatternBinding>();
    private final List<PatternBinding> connectBindings = new ArrayList<PatternBinding>();
    private final List<PatternBinding> patchBindings = new ArrayList<PatternBinding>();
    private Handler<HttpServerRequest> noMatchHandler;

    @Override
    public void handle(HttpServerRequest request) {
        switch (request.method()) {
            case "GET": {
                this.route(request, this.getBindings);
                break;
            }
            case "PUT": {
                this.route(request, this.putBindings);
                break;
            }
            case "POST": {
                this.route(request, this.postBindings);
                break;
            }
            case "DELETE": {
                this.route(request, this.deleteBindings);
                break;
            }
            case "OPTIONS": {
                this.route(request, this.optionsBindings);
                break;
            }
            case "HEAD": {
                this.route(request, this.headBindings);
                break;
            }
            case "TRACE": {
                this.route(request, this.traceBindings);
                break;
            }
            case "PATCH": {
                this.route(request, this.patchBindings);
                break;
            }
            case "CONNECT": {
                this.route(request, this.connectBindings);
                break;
            }
            default: {
                this.notFound(request);
            }
        }
    }

    public RouteMatcher get(String pattern, Handler<HttpServerRequest> handler) {
        RouteMatcher.addPattern(pattern, handler, this.getBindings);
        return this;
    }

    public RouteMatcher put(String pattern, Handler<HttpServerRequest> handler) {
        RouteMatcher.addPattern(pattern, handler, this.putBindings);
        return this;
    }

    public RouteMatcher post(String pattern, Handler<HttpServerRequest> handler) {
        RouteMatcher.addPattern(pattern, handler, this.postBindings);
        return this;
    }

    public RouteMatcher delete(String pattern, Handler<HttpServerRequest> handler) {
        RouteMatcher.addPattern(pattern, handler, this.deleteBindings);
        return this;
    }

    public RouteMatcher options(String pattern, Handler<HttpServerRequest> handler) {
        RouteMatcher.addPattern(pattern, handler, this.optionsBindings);
        return this;
    }

    public RouteMatcher head(String pattern, Handler<HttpServerRequest> handler) {
        RouteMatcher.addPattern(pattern, handler, this.headBindings);
        return this;
    }

    public RouteMatcher trace(String pattern, Handler<HttpServerRequest> handler) {
        RouteMatcher.addPattern(pattern, handler, this.traceBindings);
        return this;
    }

    public RouteMatcher connect(String pattern, Handler<HttpServerRequest> handler) {
        RouteMatcher.addPattern(pattern, handler, this.connectBindings);
        return this;
    }

    public RouteMatcher patch(String pattern, Handler<HttpServerRequest> handler) {
        RouteMatcher.addPattern(pattern, handler, this.patchBindings);
        return this;
    }

    public RouteMatcher all(String pattern, Handler<HttpServerRequest> handler) {
        RouteMatcher.addPattern(pattern, handler, this.getBindings);
        RouteMatcher.addPattern(pattern, handler, this.putBindings);
        RouteMatcher.addPattern(pattern, handler, this.postBindings);
        RouteMatcher.addPattern(pattern, handler, this.deleteBindings);
        RouteMatcher.addPattern(pattern, handler, this.optionsBindings);
        RouteMatcher.addPattern(pattern, handler, this.headBindings);
        RouteMatcher.addPattern(pattern, handler, this.traceBindings);
        RouteMatcher.addPattern(pattern, handler, this.connectBindings);
        RouteMatcher.addPattern(pattern, handler, this.patchBindings);
        return this;
    }

    public RouteMatcher getWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        RouteMatcher.addRegEx(regex, handler, this.getBindings);
        return this;
    }

    public RouteMatcher putWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        RouteMatcher.addRegEx(regex, handler, this.putBindings);
        return this;
    }

    public RouteMatcher postWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        RouteMatcher.addRegEx(regex, handler, this.postBindings);
        return this;
    }

    public RouteMatcher deleteWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        RouteMatcher.addRegEx(regex, handler, this.deleteBindings);
        return this;
    }

    public RouteMatcher optionsWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        RouteMatcher.addRegEx(regex, handler, this.optionsBindings);
        return this;
    }

    public RouteMatcher headWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        RouteMatcher.addRegEx(regex, handler, this.headBindings);
        return this;
    }

    public RouteMatcher traceWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        RouteMatcher.addRegEx(regex, handler, this.traceBindings);
        return this;
    }

    public RouteMatcher connectWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        RouteMatcher.addRegEx(regex, handler, this.connectBindings);
        return this;
    }

    public RouteMatcher patchWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        RouteMatcher.addRegEx(regex, handler, this.patchBindings);
        return this;
    }

    public RouteMatcher allWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        RouteMatcher.addRegEx(regex, handler, this.getBindings);
        RouteMatcher.addRegEx(regex, handler, this.putBindings);
        RouteMatcher.addRegEx(regex, handler, this.postBindings);
        RouteMatcher.addRegEx(regex, handler, this.deleteBindings);
        RouteMatcher.addRegEx(regex, handler, this.optionsBindings);
        RouteMatcher.addRegEx(regex, handler, this.headBindings);
        RouteMatcher.addRegEx(regex, handler, this.traceBindings);
        RouteMatcher.addRegEx(regex, handler, this.connectBindings);
        RouteMatcher.addRegEx(regex, handler, this.patchBindings);
        return this;
    }

    public RouteMatcher noMatch(Handler<HttpServerRequest> handler) {
        this.noMatchHandler = handler;
        return this;
    }

    private static void addPattern(String input, Handler<HttpServerRequest> handler, List<PatternBinding> bindings) {
        Matcher m = Pattern.compile(":([A-Za-z][A-Za-z0-9_]*)").matcher(input);
        StringBuffer sb = new StringBuffer();
        HashSet<String> groups = new HashSet<String>();
        while (m.find()) {
            String group = m.group().substring(1);
            if (groups.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m.appendReplacement(sb, "(?<$1>[^\\/]+)");
            groups.add(group);
        }
        m.appendTail(sb);
        String regex = sb.toString();
        PatternBinding binding = new PatternBinding(Pattern.compile(regex), groups, handler);
        bindings.add(binding);
    }

    private static void addRegEx(String input, Handler<HttpServerRequest> handler, List<PatternBinding> bindings) {
        PatternBinding binding = new PatternBinding(Pattern.compile(input), null, handler);
        bindings.add(binding);
    }

    private void route(HttpServerRequest request, List<PatternBinding> bindings) {
        for (PatternBinding binding : bindings) {
            Matcher m = binding.pattern.matcher(request.path());
            if (!m.matches()) continue;
            HashMap<String, String> params = new HashMap<String, String>(m.groupCount());
            if (binding.paramNames != null) {
                for (String param : binding.paramNames) {
                    params.put(param, m.group(param));
                }
            } else {
                for (int i = 0; i < m.groupCount(); ++i) {
                    params.put("param" + i, m.group(i + 1));
                }
            }
            request.params().add(params);
            binding.handler.handle(request);
            return;
        }
        this.notFound(request);
    }

    private void notFound(HttpServerRequest request) {
        if (this.noMatchHandler != null) {
            this.noMatchHandler.handle(request);
        } else {
            request.response().setStatusCode(404);
            request.response().end();
        }
    }

    private static class PatternBinding {
        final Pattern pattern;
        final Handler<HttpServerRequest> handler;
        final Set<String> paramNames;

        private PatternBinding(Pattern pattern, Set<String> paramNames, Handler<HttpServerRequest> handler) {
            this.pattern = pattern;
            this.paramNames = paramNames;
            this.handler = handler;
        }
    }
}

