/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.dns.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.vertx.java.core.dns.impl.netty.DnsQuery;
import org.vertx.java.core.dns.impl.netty.DnsQueryHeader;
import org.vertx.java.core.dns.impl.netty.DnsQuestion;

public class DnsQueryEncoder
extends MessageToByteEncoder<DnsQuery> {
    private static void encodeHeader(DnsQueryHeader header, ByteBuf buf) {
        buf.writeShort(header.getId());
        int flags = 0;
        flags |= header.getType() << 15;
        flags |= header.getOpcode() << 14;
        buf.writeShort(flags |= header.isRecursionDesired() ? 256 : 0);
        buf.writeShort(header.questionCount());
        buf.writeShort(header.answerCount());
        buf.writeShort(header.authorityResourceCount());
        buf.writeShort(header.additionalResourceCount());
    }

    private static void encodeQuestion(DnsQuestion question, Charset charset, ByteBuf buf) {
        String[] parts = question.name().split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            buf.writeByte(parts[i].length());
            buf.writeBytes(charset.encode(parts[i]));
        }
        buf.writeByte(0);
        buf.writeShort(question.type());
        buf.writeShort(question.dnsClass());
    }

    protected static void encodeQuery(DnsQuery query, ByteBuf buf) {
        DnsQueryEncoder.encodeHeader((DnsQueryHeader)query.getHeader(), buf);
        List<DnsQuestion> questions = query.getQuestions();
        for (DnsQuestion question : questions) {
            DnsQueryEncoder.encodeQuestion(question, CharsetUtil.UTF_8, buf);
        }
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, DnsQuery query, ByteBuf out) throws Exception {
        DnsQueryEncoder.encodeQuery(query, out);
    }
}

