/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.datagram.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.datagram.DatagramPacket;
import org.vertx.java.core.datagram.impl.DefaultDatagramPacket;
import org.vertx.java.core.datagram.impl.DefaultDatagramSocket;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.VertxHandler;

final class DatagramServerHandler
extends VertxHandler<DefaultDatagramSocket> {
    private final DefaultDatagramSocket server;

    DatagramServerHandler(VertxInternal vertx, DefaultDatagramSocket server) {
        super(vertx, new HashMap());
        this.server = server;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.connectionMap.put(ctx.channel(), this.server);
    }

    @Override
    protected void channelRead(final DefaultDatagramSocket server, final DefaultContext context, ChannelHandlerContext chctx, final Object msg) throws Exception {
        if (context.isOnCorrectWorker(chctx.channel().eventLoop())) {
            try {
                this.vertx.setContext(context);
                server.handleMessage((DatagramPacket)msg);
            }
            catch (Throwable t) {
                context.reportException(t);
            }
        } else {
            context.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        server.handleMessage((DatagramPacket)msg);
                    }
                    catch (Throwable t) {
                        context.reportException(t);
                    }
                }
            });
        }
    }

    @Override
    protected Object safeObject(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof io.netty.channel.socket.DatagramPacket) {
            io.netty.channel.socket.DatagramPacket packet = (io.netty.channel.socket.DatagramPacket)msg;
            ByteBuf content = (ByteBuf)packet.content();
            if (content.isDirect()) {
                content = DatagramServerHandler.safeBuffer(content, allocator);
            }
            return new DefaultDatagramPacket((InetSocketAddress)packet.sender(), new Buffer(content));
        }
        return msg;
    }
}

