/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Fun;
import org.mapdb.HTreeMap;
import org.mapdb.Hasher;
import org.mapdb.Pump;
import org.mapdb.Queues;
import org.mapdb.Serializer;
import org.mapdb.StoreHeap;
import org.mapdb.TxEngine;

public class DB {
    protected final boolean strictDBGet;
    protected Engine engine;
    protected Map<String, WeakReference<?>> namesInstanciated = new HashMap();
    protected Map<IdentityWrapper, String> namesLookup = Collections.synchronizedMap(new HashMap());
    protected SortedMap<String, Object> catalog;

    public DB(Engine engine) {
        this(engine, false, false);
    }

    public DB(Engine engine, boolean strictDBGet, boolean disableLocks) {
        if (!(engine instanceof EngineWrapper)) {
            engine = new EngineWrapper(engine);
        }
        this.engine = engine;
        this.strictDBGet = strictDBGet;
        engine.getSerializerPojo().setDb(this);
        this.reinit();
    }

    protected void reinit() {
        this.catalog = BTreeMap.preinitCatalog(this);
    }

    public <A> A catGet(String name, A init) {
        assert (Thread.holdsLock(this));
        Object ret = this.catalog.get(name);
        return (A)(ret != null ? ret : init);
    }

    public <A> A catGet(String name) {
        assert (Thread.holdsLock(this));
        return (A)this.catalog.get(name);
    }

    public <A> A catPut(String name, A value) {
        assert (Thread.holdsLock(this));
        this.catalog.put(name, value);
        return value;
    }

    public <A> A catPut(String name, A value, A retValueIfNull) {
        assert (Thread.holdsLock(this));
        if (value == null) {
            return retValueIfNull;
        }
        this.catalog.put(name, value);
        return value;
    }

    public String getNameForObject(Object obj) {
        return this.namesLookup.get(new IdentityWrapper(obj));
    }

    public synchronized <K, V> HTreeMap<K, V> getHashMap(String name) {
        return this.getHashMap(name, null);
    }

    public synchronized <K, V> HTreeMap<K, V> getHashMap(String name, Fun.Function1<V, K> valueCreator) {
        this.checkNotClosed();
        HTreeMap<K, V> ret = (HTreeMap<K, V>)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getHashMap("a");
                return (HTreeMap)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getHashMap("a"));
            }
            if (valueCreator != null) {
                return this.createHashMap(name).valueCreator(valueCreator).make();
            }
            return this.createHashMap(name).make();
        }
        this.checkType(type, "HashMap");
        ret = new HTreeMap<K, V>(this.engine, (Long)this.catGet(name + ".counterRecid"), (Integer)this.catGet(name + ".hashSalt"), (long[])this.catGet(name + ".segmentRecids"), this.catGet(name + ".keySerializer", this.getDefaultSerializer()), this.catGet(name + ".valueSerializer", this.getDefaultSerializer()), this.catGet(name + ".expireTimeStart", 0L), this.catGet(name + ".expire", 0L), this.catGet(name + ".expireAccess", 0L), this.catGet(name + ".expireMaxSize", 0L), this.catGet(name + ".expireStoreSize", 0L), this.catGet(name + ".expireHeads", null), this.catGet(name + ".expireTails", null), valueCreator, this.catGet(name + ".hasher", Hasher.BASIC), false);
        this.namedPut(name, ret);
        return ret;
    }

    public <V> V namedPut(String name, Object ret) {
        this.namesInstanciated.put(name, new WeakReference<Object>(ret));
        this.namesLookup.put(new IdentityWrapper(ret), name);
        return (V)ret;
    }

    public HTreeMapMaker createHashMap(String name) {
        return new HTreeMapMaker(name);
    }

    protected synchronized <K, V> HTreeMap<K, V> createHashMap(HTreeMapMaker m) {
        String name = m.name;
        this.checkNameNotExists(name);
        long expireTimeStart = 0L;
        long expire = 0L;
        long expireAccess = 0L;
        long expireMaxSize = 0L;
        long expireStoreSize = 0L;
        long[] expireHeads = null;
        long[] expireTails = null;
        if (m.expire != 0L || m.expireAccess != 0L || m.expireMaxSize != 0L || m.expireStoreSize != 0L) {
            expireTimeStart = this.catPut(name + ".expireTimeStart", System.currentTimeMillis());
            expire = this.catPut(name + ".expire", m.expire);
            expireAccess = this.catPut(name + ".expireAccess", m.expireAccess);
            expireMaxSize = this.catPut(name + ".expireMaxSize", m.expireMaxSize);
            expireStoreSize = this.catPut(name + ".expireStoreSize", m.expireStoreSize);
            expireHeads = new long[16];
            expireTails = new long[16];
            for (int i = 0; i < 16; ++i) {
                expireHeads[i] = this.engine.put(0L, Serializer.LONG);
                expireTails[i] = this.engine.put(0L, Serializer.LONG);
            }
            this.catPut(name + ".expireHeads", expireHeads);
            this.catPut(name + ".expireTails", expireTails);
        }
        if (m.hasher != null) {
            this.catPut(name + ".hasher", m.hasher);
        }
        HTreeMap ret = new HTreeMap(this.engine, this.catPut(name + ".counterRecid", !m.counter ? 0L : this.engine.put(0L, Serializer.LONG)), this.catPut(name + ".hashSalt", new Random().nextInt()), this.catPut(name + ".segmentRecids", HTreeMap.preallocateSegments(this.engine)), this.catPut(name + ".keySerializer", m.keySerializer, this.getDefaultSerializer()), this.catPut(name + ".valueSerializer", m.valueSerializer, this.getDefaultSerializer()), expireTimeStart, expire, expireAccess, expireMaxSize, expireStoreSize, expireHeads, expireTails, m.valueCreator, m.hasher, false);
        this.catalog.put(name + ".type", "HashMap");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <K> Set<K> getHashSet(String name) {
        this.checkNotClosed();
        Set ret = (Set)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getHashSet("a");
                return (Set)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getHashSet("a"));
            }
            return this.createHashSet(name).makeOrGet();
        }
        this.checkType(type, "HashSet");
        ret = new HTreeMap(this.engine, (Long)this.catGet(name + ".counterRecid"), (Integer)this.catGet(name + ".hashSalt"), (long[])this.catGet(name + ".segmentRecids"), this.catGet(name + ".serializer", this.getDefaultSerializer()), null, this.catGet(name + ".expireTimeStart", 0L), this.catGet(name + ".expire", 0L), this.catGet(name + ".expireAccess", 0L), this.catGet(name + ".expireMaxSize", 0L), this.catGet(name + ".expireStoreSize", 0L), this.catGet(name + ".expireHeads", null), this.catGet(name + ".expireTails", null), null, this.catGet(name + ".hasher", Hasher.BASIC), false).keySet();
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized HTreeSetMaker createHashSet(String name) {
        return new HTreeSetMaker(name);
    }

    protected synchronized <K> Set<K> createHashSet(HTreeSetMaker m) {
        String name = m.name;
        this.checkNameNotExists(name);
        long expireTimeStart = 0L;
        long expire = 0L;
        long expireAccess = 0L;
        long expireMaxSize = 0L;
        long expireStoreSize = 0L;
        long[] expireHeads = null;
        long[] expireTails = null;
        if (m.expire != 0L || m.expireAccess != 0L || m.expireMaxSize != 0L) {
            expireTimeStart = this.catPut(name + ".expireTimeStart", System.currentTimeMillis());
            expire = this.catPut(name + ".expire", m.expire);
            expireAccess = this.catPut(name + ".expireAccess", m.expireAccess);
            expireMaxSize = this.catPut(name + ".expireMaxSize", m.expireMaxSize);
            expireStoreSize = this.catPut(name + ".expireStoreSize", m.expireStoreSize);
            expireHeads = new long[16];
            expireTails = new long[16];
            for (int i = 0; i < 16; ++i) {
                expireHeads[i] = this.engine.put(0L, Serializer.LONG);
                expireTails[i] = this.engine.put(0L, Serializer.LONG);
            }
            this.catPut(name + ".expireHeads", expireHeads);
            this.catPut(name + ".expireTails", expireTails);
        }
        if (m.hasher != null) {
            this.catPut(name + ".hasher", m.hasher);
        }
        HTreeMap ret = new HTreeMap(this.engine, this.catPut(name + ".counterRecid", !m.counter ? 0L : this.engine.put(0L, Serializer.LONG)), this.catPut(name + ".hashSalt", new Random().nextInt()), this.catPut(name + ".segmentRecids", HTreeMap.preallocateSegments(this.engine)), this.catPut(name + ".serializer", m.serializer, this.getDefaultSerializer()), null, expireTimeStart, expire, expireAccess, expireMaxSize, expireStoreSize, expireHeads, expireTails, null, m.hasher, false);
        Set ret2 = ret.keySet();
        this.catalog.put(name + ".type", "HashSet");
        this.namedPut(name, ret2);
        return ret2;
    }

    public synchronized <K, V> BTreeMap<K, V> getTreeMap(String name) {
        this.checkNotClosed();
        BTreeMap ret = (BTreeMap)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getTreeMap("a");
                return (BTreeMap)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getTreeMap("a"));
            }
            return this.createTreeMap(name).make();
        }
        this.checkType(type, "TreeMap");
        ret = new BTreeMap(this.engine, (Long)this.catGet(name + ".rootRecidRef"), this.catGet(name + ".maxNodeSize", 32), this.catGet(name + ".valuesOutsideNodes", false), this.catGet(name + ".counterRecid", 0L), this.catGet(name + ".keySerializer", new BTreeKeySerializer.BasicKeySerializer(this.getDefaultSerializer())), this.catGet(name + ".valueSerializer", this.getDefaultSerializer()), this.catGet(name + ".comparator", BTreeMap.COMPARABLE_COMPARATOR), this.catGet(name + ".numberOfNodeMetas", 0), false);
        this.namedPut(name, ret);
        return ret;
    }

    public BTreeMapMaker createTreeMap(String name) {
        return new BTreeMapMaker(name);
    }

    protected synchronized <K, V> BTreeMap<K, V> createTreeMap(final BTreeMapMaker m) {
        String name = m.name;
        this.checkNameNotExists(name);
        m.keySerializer = this.fillNulls(m.keySerializer);
        m.keySerializer = this.catPut(name + ".keySerializer", m.keySerializer, new BTreeKeySerializer.BasicKeySerializer(this.getDefaultSerializer()));
        m.valueSerializer = this.catPut(name + ".valueSerializer", m.valueSerializer, this.getDefaultSerializer());
        if (m.comparator == null) {
            m.comparator = m.keySerializer.getComparator();
            if (m.comparator == null) {
                m.comparator = BTreeMap.COMPARABLE_COMPARATOR;
            }
        }
        m.comparator = this.catPut(name + ".comparator", m.comparator);
        if (m.pumpPresortBatchSize != -1 && m.pumpSource != null) {
            Comparator presortComp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return -m.comparator.compare(m.pumpKeyExtractor.run(o1), m.pumpKeyExtractor.run(o2));
                }
            };
            m.pumpSource = Pump.sort(m.pumpSource, m.pumpIgnoreDuplicates, m.pumpPresortBatchSize, presortComp, this.getDefaultSerializer());
        }
        long counterRecid = !m.counter ? 0L : this.engine.put(0L, Serializer.LONG);
        long rootRecidRef = m.pumpSource == null ? BTreeMap.createRootRef(this.engine, m.keySerializer, m.valueSerializer, m.comparator, 0) : Pump.buildTreeMap(m.pumpSource, this.engine, m.pumpKeyExtractor, m.pumpValueExtractor, m.pumpIgnoreDuplicates, m.nodeSize, m.valuesOutsideNodes, counterRecid, m.keySerializer, m.valueSerializer, m.comparator);
        BTreeMap ret = new BTreeMap(this.engine, this.catPut(name + ".rootRecidRef", rootRecidRef), this.catPut(name + ".maxNodeSize", m.nodeSize), this.catPut(name + ".valuesOutsideNodes", m.valuesOutsideNodes), this.catPut(name + ".counterRecid", counterRecid), m.keySerializer, m.valueSerializer, m.comparator, this.catPut(m.name + ".numberOfNodeMetas", 0), false);
        this.catalog.put(name + ".type", "TreeMap");
        this.namedPut(name, ret);
        return ret;
    }

    protected <K> BTreeKeySerializer<K> fillNulls(BTreeKeySerializer<K> keySerializer) {
        if (keySerializer == null) {
            return null;
        }
        if (keySerializer instanceof BTreeKeySerializer.Tuple2KeySerializer) {
            BTreeKeySerializer.Tuple2KeySerializer s = (BTreeKeySerializer.Tuple2KeySerializer)keySerializer;
            return new BTreeKeySerializer.Tuple2KeySerializer(s.aComparator != null ? s.aComparator : BTreeMap.COMPARABLE_COMPARATOR, s.aSerializer != null ? s.aSerializer : this.getDefaultSerializer(), s.bSerializer != null ? s.bSerializer : this.getDefaultSerializer());
        }
        if (keySerializer instanceof BTreeKeySerializer.Tuple3KeySerializer) {
            BTreeKeySerializer.Tuple3KeySerializer s = (BTreeKeySerializer.Tuple3KeySerializer)keySerializer;
            return new BTreeKeySerializer.Tuple3KeySerializer(s.aComparator != null ? s.aComparator : BTreeMap.COMPARABLE_COMPARATOR, s.bComparator != null ? s.bComparator : BTreeMap.COMPARABLE_COMPARATOR, s.aSerializer != null ? s.aSerializer : this.getDefaultSerializer(), s.bSerializer != null ? s.bSerializer : this.getDefaultSerializer(), s.cSerializer != null ? s.cSerializer : this.getDefaultSerializer());
        }
        if (keySerializer instanceof BTreeKeySerializer.Tuple4KeySerializer) {
            BTreeKeySerializer.Tuple4KeySerializer s = (BTreeKeySerializer.Tuple4KeySerializer)keySerializer;
            return new BTreeKeySerializer.Tuple4KeySerializer(s.aComparator != null ? s.aComparator : BTreeMap.COMPARABLE_COMPARATOR, s.bComparator != null ? s.bComparator : BTreeMap.COMPARABLE_COMPARATOR, s.cComparator != null ? s.cComparator : BTreeMap.COMPARABLE_COMPARATOR, s.aSerializer != null ? s.aSerializer : this.getDefaultSerializer(), s.bSerializer != null ? s.bSerializer : this.getDefaultSerializer(), s.cSerializer != null ? s.cSerializer : this.getDefaultSerializer(), s.dSerializer != null ? s.dSerializer : this.getDefaultSerializer());
        }
        if (keySerializer instanceof BTreeKeySerializer.Tuple5KeySerializer) {
            BTreeKeySerializer.Tuple5KeySerializer s = (BTreeKeySerializer.Tuple5KeySerializer)keySerializer;
            return new BTreeKeySerializer.Tuple5KeySerializer(s.aComparator != null ? s.aComparator : BTreeMap.COMPARABLE_COMPARATOR, s.bComparator != null ? s.bComparator : BTreeMap.COMPARABLE_COMPARATOR, s.cComparator != null ? s.cComparator : BTreeMap.COMPARABLE_COMPARATOR, s.dComparator != null ? s.dComparator : BTreeMap.COMPARABLE_COMPARATOR, s.aSerializer != null ? s.aSerializer : this.getDefaultSerializer(), s.bSerializer != null ? s.bSerializer : this.getDefaultSerializer(), s.cSerializer != null ? s.cSerializer : this.getDefaultSerializer(), s.dSerializer != null ? s.dSerializer : this.getDefaultSerializer(), s.eSerializer != null ? s.eSerializer : this.getDefaultSerializer());
        }
        if (keySerializer instanceof BTreeKeySerializer.Tuple6KeySerializer) {
            BTreeKeySerializer.Tuple6KeySerializer s = (BTreeKeySerializer.Tuple6KeySerializer)keySerializer;
            return new BTreeKeySerializer.Tuple6KeySerializer(s.aComparator != null ? s.aComparator : BTreeMap.COMPARABLE_COMPARATOR, s.bComparator != null ? s.bComparator : BTreeMap.COMPARABLE_COMPARATOR, s.cComparator != null ? s.cComparator : BTreeMap.COMPARABLE_COMPARATOR, s.dComparator != null ? s.dComparator : BTreeMap.COMPARABLE_COMPARATOR, s.eComparator != null ? s.eComparator : BTreeMap.COMPARABLE_COMPARATOR, s.aSerializer != null ? s.aSerializer : this.getDefaultSerializer(), s.bSerializer != null ? s.bSerializer : this.getDefaultSerializer(), s.cSerializer != null ? s.cSerializer : this.getDefaultSerializer(), s.dSerializer != null ? s.dSerializer : this.getDefaultSerializer(), s.eSerializer != null ? s.eSerializer : this.getDefaultSerializer(), s.fSerializer != null ? s.fSerializer : this.getDefaultSerializer());
        }
        return keySerializer;
    }

    public SortedMap<String, Object> getCatalog() {
        return this.catalog;
    }

    public synchronized <K> NavigableSet<K> getTreeSet(String name) {
        this.checkNotClosed();
        Set ret = (NavigableSet)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getTreeSet("a");
                return (NavigableSet)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getTreeSet("a"));
            }
            return this.createTreeSet(name).make();
        }
        this.checkType(type, "TreeSet");
        ret = new BTreeMap(this.engine, (Long)this.catGet(name + ".rootRecidRef"), this.catGet(name + ".maxNodeSize", 32), false, this.catGet(name + ".counterRecid", 0L), this.catGet(name + ".keySerializer", new BTreeKeySerializer.BasicKeySerializer(this.getDefaultSerializer())), null, this.catGet(name + ".comparator", BTreeMap.COMPARABLE_COMPARATOR), this.catGet(name + ".numberOfNodeMetas", 0), false).keySet();
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized BTreeSetMaker createTreeSet(String name) {
        return new BTreeSetMaker(name);
    }

    public synchronized <K> NavigableSet<K> createTreeSet(BTreeSetMaker m) {
        this.checkNameNotExists(m.name);
        m.serializer = this.fillNulls(m.serializer);
        m.serializer = this.catPut(m.name + ".keySerializer", m.serializer, new BTreeKeySerializer.BasicKeySerializer(this.getDefaultSerializer()));
        m.comparator = this.catPut(m.name + ".comparator", m.comparator, BTreeMap.COMPARABLE_COMPARATOR);
        if (m.pumpPresortBatchSize != -1) {
            m.pumpSource = Pump.sort(m.pumpSource, m.pumpIgnoreDuplicates, m.pumpPresortBatchSize, Collections.reverseOrder(m.comparator), this.getDefaultSerializer());
        }
        long counterRecid = !m.counter ? 0L : this.engine.put(0L, Serializer.LONG);
        long rootRecidRef = m.pumpSource == null ? BTreeMap.createRootRef(this.engine, m.serializer, null, m.comparator, 0) : Pump.buildTreeMap(m.pumpSource, this.engine, Fun.extractNoTransform(), null, m.pumpIgnoreDuplicates, m.nodeSize, false, counterRecid, m.serializer, null, m.comparator);
        Set ret = new BTreeMap(this.engine, this.catPut(m.name + ".rootRecidRef", rootRecidRef), this.catPut(m.name + ".maxNodeSize", m.nodeSize), false, this.catPut(m.name + ".counterRecid", counterRecid), m.serializer, null, m.comparator, this.catPut(m.name + ".numberOfNodeMetas", 0), false).keySet();
        this.catalog.put(m.name + ".type", "TreeSet");
        this.namedPut(m.name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> getQueue(String name) {
        this.checkNotClosed();
        Queues.Queue ret = (Queues.Queue)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getQueue("a");
                return (BlockingQueue)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getQueue("a"));
            }
            return this.createQueue(name, null, true);
        }
        this.checkType(type, "Queue");
        ret = new Queues.Queue(this.engine, this.catGet(name + ".serializer", this.getDefaultSerializer()), (Long)this.catGet(name + ".headRecid"), (Long)this.catGet(name + ".tailRecid"), (Boolean)this.catGet(name + ".useLocks"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> createQueue(String name, Serializer<E> serializer, boolean useLocks) {
        this.checkNameNotExists(name);
        long node = this.engine.put(Queues.SimpleQueue.Node.EMPTY, new Queues.SimpleQueue.NodeSerializer<E>(serializer));
        long headRecid = this.engine.put(node, Serializer.LONG);
        long tailRecid = this.engine.put(node, Serializer.LONG);
        Queues.Queue ret = new Queues.Queue(this.engine, this.catPut(name + ".serializer", serializer, this.getDefaultSerializer()), this.catPut(name + ".headRecid", headRecid), this.catPut(name + ".tailRecid", tailRecid), this.catPut(name + ".useLocks", useLocks));
        this.catalog.put(name + ".type", "Queue");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> getStack(String name) {
        this.checkNotClosed();
        Queues.Stack ret = (Queues.Stack)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getStack("a");
                return (BlockingQueue)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getStack("a"));
            }
            return this.createStack(name, null, true);
        }
        this.checkType(type, "Stack");
        ret = new Queues.Stack(this.engine, this.catGet(name + ".serializer", this.getDefaultSerializer()), (Long)this.catGet(name + ".headRecid"), (Boolean)this.catGet(name + ".useLocks"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> createStack(String name, Serializer<E> serializer, boolean useLocks) {
        this.checkNameNotExists(name);
        long node = this.engine.put(Queues.SimpleQueue.Node.EMPTY, new Queues.SimpleQueue.NodeSerializer<E>(serializer));
        long headRecid = this.engine.put(node, Serializer.LONG);
        Queues.Stack ret = new Queues.Stack(this.engine, this.catPut(name + ".serializer", serializer, this.getDefaultSerializer()), this.catPut(name + ".headRecid", headRecid), this.catPut(name + ".useLocks", useLocks));
        this.catalog.put(name + ".type", "Stack");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> getCircularQueue(String name) {
        this.checkNotClosed();
        Queues.CircularQueue ret = (Queues.CircularQueue)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getCircularQueue("a");
                return (BlockingQueue)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getCircularQueue("a"));
            }
            return this.createCircularQueue(name, null, 1024L);
        }
        this.checkType(type, "CircularQueue");
        ret = new Queues.CircularQueue(this.engine, this.catGet(name + ".serializer", this.getDefaultSerializer()), (Long)this.catGet(name + ".headRecid"), (Long)this.catGet(name + ".headInsertRecid"), (Long)this.catGet(name + ".size"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> BlockingQueue<E> createCircularQueue(String name, Serializer<E> serializer, long size) {
        this.checkNameNotExists(name);
        if (serializer == null) {
            serializer = this.getDefaultSerializer();
        }
        long prevRecid = 0L;
        long firstRecid = 0L;
        Queues.SimpleQueue.NodeSerializer nodeSer = new Queues.SimpleQueue.NodeSerializer(serializer);
        for (long i = 0L; i < size; ++i) {
            Queues.SimpleQueue.Node<Object> n = new Queues.SimpleQueue.Node<Object>(prevRecid, null);
            prevRecid = this.engine.put(n, nodeSer);
            if (firstRecid != 0L) continue;
            firstRecid = prevRecid;
        }
        this.engine.update(firstRecid, new Queues.SimpleQueue.Node<Object>(prevRecid, null), nodeSer);
        long headRecid = this.engine.put(prevRecid, Serializer.LONG);
        long headInsertRecid = this.engine.put(prevRecid, Serializer.LONG);
        Queues.CircularQueue ret = new Queues.CircularQueue(this.engine, this.catPut(name + ".serializer", serializer), this.catPut(name + ".headRecid", headRecid), this.catPut(name + ".headInsertRecid", headInsertRecid), this.catPut(name + ".size", size));
        this.catalog.put(name + ".type", "CircularQueue");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Long createAtomicLong(String name, long initValue) {
        this.checkNameNotExists(name);
        long recid = this.engine.put(initValue, Serializer.LONG);
        Atomic.Long ret = new Atomic.Long(this.engine, this.catPut(name + ".recid", recid));
        this.catalog.put(name + ".type", "AtomicLong");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Long getAtomicLong(String name) {
        this.checkNotClosed();
        Atomic.Long ret = (Atomic.Long)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getAtomicLong("a");
                return (Atomic.Long)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getAtomicLong("a"));
            }
            return this.createAtomicLong(name, 0L);
        }
        this.checkType(type, "AtomicLong");
        ret = new Atomic.Long(this.engine, (Long)this.catGet(name + ".recid"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Integer createAtomicInteger(String name, int initValue) {
        this.checkNameNotExists(name);
        long recid = this.engine.put(initValue, Serializer.INTEGER);
        Atomic.Integer ret = new Atomic.Integer(this.engine, this.catPut(name + ".recid", recid));
        this.catalog.put(name + ".type", "AtomicInteger");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Integer getAtomicInteger(String name) {
        this.checkNotClosed();
        Atomic.Integer ret = (Atomic.Integer)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getAtomicInteger("a");
                return (Atomic.Integer)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getAtomicInteger("a"));
            }
            return this.createAtomicInteger(name, 0);
        }
        this.checkType(type, "AtomicInteger");
        ret = new Atomic.Integer(this.engine, (Long)this.catGet(name + ".recid"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Boolean createAtomicBoolean(String name, boolean initValue) {
        this.checkNameNotExists(name);
        long recid = this.engine.put(initValue, Serializer.BOOLEAN);
        Atomic.Boolean ret = new Atomic.Boolean(this.engine, this.catPut(name + ".recid", recid));
        this.catalog.put(name + ".type", "AtomicBoolean");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.Boolean getAtomicBoolean(String name) {
        this.checkNotClosed();
        Atomic.Boolean ret = (Atomic.Boolean)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getAtomicBoolean("a");
                return (Atomic.Boolean)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getAtomicBoolean("a"));
            }
            return this.createAtomicBoolean(name, false);
        }
        this.checkType(type, "AtomicBoolean");
        ret = new Atomic.Boolean(this.engine, (Long)this.catGet(name + ".recid"));
        this.namedPut(name, ret);
        return ret;
    }

    public void checkShouldCreate(String name) {
        if (this.strictDBGet) {
            throw new NoSuchElementException("No record with this name was found: " + name);
        }
    }

    public synchronized Atomic.String createAtomicString(String name, String initValue) {
        this.checkNameNotExists(name);
        if (initValue == null) {
            throw new IllegalArgumentException("initValue may not be null");
        }
        long recid = this.engine.put(initValue, Serializer.STRING_NOSIZE);
        Atomic.String ret = new Atomic.String(this.engine, this.catPut(name + ".recid", recid));
        this.catalog.put(name + ".type", "AtomicString");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized Atomic.String getAtomicString(String name) {
        this.checkNotClosed();
        Atomic.String ret = (Atomic.String)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getAtomicString("a");
                return (Atomic.String)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getAtomicString("a"));
            }
            return this.createAtomicString(name, "");
        }
        this.checkType(type, "AtomicString");
        ret = new Atomic.String(this.engine, (Long)this.catGet(name + ".recid"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> Atomic.Var<E> createAtomicVar(String name, E initValue, Serializer<E> serializer) {
        this.checkNameNotExists(name);
        if (serializer == null) {
            serializer = this.getDefaultSerializer();
        }
        long recid = this.engine.put(initValue, serializer);
        Atomic.Var ret = new Atomic.Var(this.engine, this.catPut(name + ".recid", recid), this.catPut(name + ".serializer", serializer));
        this.catalog.put(name + ".type", "AtomicVar");
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> Atomic.Var<E> getAtomicVar(String name) {
        this.checkNotClosed();
        Atomic.Var ret = (Atomic.Var)this.getFromWeakCollection(name);
        if (ret != null) {
            return ret;
        }
        String type = this.catGet(name + ".type", null);
        if (type == null) {
            this.checkShouldCreate(name);
            if (this.engine.isReadOnly()) {
                StoreHeap e = new StoreHeap();
                new DB(e).getAtomicVar("a");
                return (Atomic.Var)this.namedPut(name, new DB(new EngineWrapper.ReadOnlyEngine(e)).getAtomicVar("a"));
            }
            return this.createAtomicVar(name, null, this.getDefaultSerializer());
        }
        this.checkType(type, "AtomicVar");
        ret = new Atomic.Var(this.engine, (Long)this.catGet(name + ".recid"), (Serializer)this.catGet(name + ".serializer"));
        this.namedPut(name, ret);
        return ret;
    }

    public synchronized <E> E get(String name) {
        String type = (String)this.catGet(name + ".type");
        if (type == null) {
            return null;
        }
        if ("HashMap".equals(type)) {
            return (E)this.getHashMap(name);
        }
        if ("HashSet".equals(type)) {
            return (E)this.getHashSet(name);
        }
        if ("TreeMap".equals(type)) {
            return (E)this.getTreeMap(name);
        }
        if ("TreeSet".equals(type)) {
            return (E)this.getTreeSet(name);
        }
        if ("AtomicBoolean".equals(type)) {
            return (E)this.getAtomicBoolean(name);
        }
        if ("AtomicInteger".equals(type)) {
            return (E)this.getAtomicInteger(name);
        }
        if ("AtomicLong".equals(type)) {
            return (E)this.getAtomicLong(name);
        }
        if ("AtomicString".equals(type)) {
            return (E)this.getAtomicString(name);
        }
        if ("AtomicVar".equals(type)) {
            return (E)this.getAtomicVar(name);
        }
        if ("Queue".equals(type)) {
            return (E)this.getQueue(name);
        }
        if ("Stack".equals(type)) {
            return (E)this.getStack(name);
        }
        if ("CircularQueue".equals(type)) {
            return (E)this.getCircularQueue(name);
        }
        throw new AssertionError((Object)("Unknown type: " + name));
    }

    public synchronized boolean exists(String name) {
        return this.catGet(name + ".type") != null;
    }

    public synchronized void delete(String name) {
        AbstractMap m;
        Object r = this.get(name);
        if (r instanceof Atomic.Boolean) {
            this.engine.delete(((Atomic.Boolean)r).recid, Serializer.BOOLEAN);
        } else if (r instanceof Atomic.Integer) {
            this.engine.delete(((Atomic.Integer)r).recid, Serializer.INTEGER);
        } else if (r instanceof Atomic.Long) {
            this.engine.delete(((Atomic.Long)r).recid, Serializer.LONG);
        } else if (r instanceof Atomic.String) {
            this.engine.delete(((Atomic.String)r).recid, Serializer.STRING_NOSIZE);
        } else if (r instanceof Atomic.Var) {
            this.engine.delete(((Atomic.Var)r).recid, ((Atomic.Var)r).serializer);
        } else if (r instanceof Queue) {
            Queue q = (Queue)r;
            while (q.poll() != null) {
            }
        } else if (r instanceof HTreeMap || r instanceof HTreeMap.KeySet) {
            m = r instanceof HTreeMap ? (HTreeMap)r : ((HTreeMap.KeySet)r).parent();
            ((HTreeMap)m).clear();
            for (long segmentRecid : ((HTreeMap)m).segmentRecids) {
                this.engine.delete(segmentRecid, HTreeMap.DIR_SERIALIZER);
            }
        } else if (r instanceof BTreeMap || r instanceof BTreeMap.KeySet) {
            m = r instanceof BTreeMap ? (BTreeMap)r : (BTreeMap)((BTreeMap.KeySet)r).m;
            ((BTreeMap)m).clear();
            if (((BTreeMap)m).counter != null) {
                this.engine.delete(((BTreeMap)m).counter.recid, Serializer.LONG);
            }
        }
        for (String n : this.catalog.keySet()) {
            String suffix;
            if (!n.startsWith(name) || (suffix = n.substring(name.length())).charAt(0) != '.' || suffix.length() <= 1 || suffix.substring(1).contains(".")) continue;
            this.catalog.remove(n);
        }
        this.namesInstanciated.remove(name);
        this.namesLookup.remove(new IdentityWrapper(r));
    }

    public synchronized Map<String, Object> getAll() {
        TreeMap ret = new TreeMap();
        for (String name : this.catalog.keySet()) {
            if (!name.endsWith(".type")) continue;
            name = name.substring(0, name.length() - 5);
            ret.put(name, this.get(name));
        }
        return Collections.unmodifiableMap(ret);
    }

    public synchronized void rename(String oldName, String newName) {
        Object old2;
        String param;
        if (oldName.equals(newName)) {
            return;
        }
        SortedMap<String, Object> sub = this.catalog.tailMap(oldName);
        ArrayList<String> toRemove = new ArrayList<String>();
        Iterator i$ = sub.keySet().iterator();
        while (i$.hasNext() && (param = (String)i$.next()).startsWith(oldName)) {
            String suffix = param.substring(oldName.length());
            this.catalog.put(newName + suffix, this.catalog.get(param));
            toRemove.add(param);
        }
        if (toRemove.isEmpty()) {
            throw new NoSuchElementException("Could not rename, name does not exist: " + oldName);
        }
        WeakReference<?> old = this.namesInstanciated.remove(oldName);
        if (old != null && (old2 = old.get()) != null) {
            this.namesLookup.remove(new IdentityWrapper(old2));
            this.namedPut(newName, old2);
        }
        for (String param2 : toRemove) {
            this.catalog.remove(param2);
        }
    }

    public void checkNameNotExists(String name) {
        if (this.catalog.get(name + ".type") != null) {
            throw new IllegalArgumentException("Name already used: " + name);
        }
    }

    public synchronized void close() {
        if (this.engine == null) {
            return;
        }
        this.engine.close();
        this.engine = EngineWrapper.CLOSED;
        this.namesInstanciated = Collections.unmodifiableMap(new HashMap());
        this.namesLookup = Collections.unmodifiableMap(new HashMap());
    }

    public Object getFromWeakCollection(String name) {
        WeakReference<?> r = this.namesInstanciated.get(name);
        if (r == null) {
            return null;
        }
        Object o = r.get();
        if (o == null) {
            this.namesInstanciated.remove(name);
        }
        return o;
    }

    public void checkNotClosed() {
        if (this.engine == null) {
            throw new IllegalAccessError("DB was already closed");
        }
    }

    public synchronized boolean isClosed() {
        return this.engine == null || this.engine.isClosed();
    }

    public synchronized void commit() {
        this.checkNotClosed();
        this.engine.commit();
    }

    public synchronized void rollback() {
        this.checkNotClosed();
        this.engine.rollback();
    }

    public synchronized void compact() {
        this.engine.compact();
    }

    public synchronized DB snapshot() {
        Engine snapshot = TxEngine.createSnapshotFor(this.engine);
        return new DB(snapshot);
    }

    public Serializer getDefaultSerializer() {
        return this.engine.getSerializerPojo();
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void checkType(String type, String expected) {
        if (!expected.equals(type)) {
            throw new IllegalArgumentException("Wrong type: " + type);
        }
    }

    public class BTreeSetMaker {
        protected final String name;
        protected int nodeSize = 32;
        protected boolean counter = false;
        protected BTreeKeySerializer<?> serializer;
        protected Comparator<?> comparator;
        protected Iterator<?> pumpSource;
        protected int pumpPresortBatchSize = -1;
        protected boolean pumpIgnoreDuplicates = false;

        public BTreeSetMaker(String name) {
            this.name = name;
        }

        public BTreeSetMaker nodeSize(int nodeSize) {
            this.nodeSize = nodeSize;
            return this;
        }

        public BTreeSetMaker counterEnable() {
            this.counter = true;
            return this;
        }

        public BTreeSetMaker serializer(BTreeKeySerializer<?> serializer) {
            this.serializer = serializer;
            return this;
        }

        public BTreeSetMaker comparator(Comparator<?> comparator) {
            this.comparator = comparator;
            return this;
        }

        public BTreeSetMaker pumpSource(Iterator<?> source) {
            this.pumpSource = source;
            return this;
        }

        public <K> BTreeSetMaker pumpIgnoreDuplicates() {
            this.pumpIgnoreDuplicates = true;
            return this;
        }

        public BTreeSetMaker pumpPresort(int batchSize) {
            this.pumpPresortBatchSize = batchSize;
            return this;
        }

        public <K> NavigableSet<K> make() {
            return DB.this.createTreeSet(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <K> NavigableSet<K> makeOrGet() {
            DB dB = DB.this;
            synchronized (dB) {
                return DB.this.catGet(this.name + ".type") == null ? this.make() : DB.this.getTreeSet(this.name);
            }
        }

        public NavigableSet<String> makeStringSet() {
            this.serializer = BTreeKeySerializer.STRING;
            return this.make();
        }

        public NavigableSet<Long> makeLongSet() {
            this.serializer = BTreeKeySerializer.ZERO_OR_POSITIVE_LONG;
            return this.make();
        }
    }

    public class BTreeMapMaker {
        protected final String name;
        protected int nodeSize = 32;
        protected boolean valuesOutsideNodes = false;
        protected boolean counter = false;
        protected BTreeKeySerializer keySerializer;
        protected Serializer valueSerializer;
        protected Comparator comparator;
        protected Iterator pumpSource;
        protected Fun.Function1 pumpKeyExtractor;
        protected Fun.Function1 pumpValueExtractor;
        protected int pumpPresortBatchSize = -1;
        protected boolean pumpIgnoreDuplicates = false;

        public BTreeMapMaker(String name) {
            this.name = name;
        }

        public BTreeMapMaker nodeSize(int nodeSize) {
            this.nodeSize = nodeSize;
            return this;
        }

        public BTreeMapMaker valuesOutsideNodesEnable() {
            this.valuesOutsideNodes = true;
            return this;
        }

        public BTreeMapMaker counterEnable() {
            this.counter = true;
            return this;
        }

        public BTreeMapMaker keySerializer(BTreeKeySerializer<?> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        public BTreeMapMaker keySerializerWrap(Serializer<?> serializer) {
            this.keySerializer = new BTreeKeySerializer.BasicKeySerializer(serializer);
            return this;
        }

        public BTreeMapMaker valueSerializer(Serializer<?> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        public BTreeMapMaker comparator(Comparator<?> comparator) {
            this.comparator = comparator;
            return this;
        }

        public <K, V> BTreeMapMaker pumpSource(Iterator<K> keysSource, Fun.Function1<V, K> valueExtractor) {
            this.pumpSource = keysSource;
            this.pumpKeyExtractor = Fun.extractNoTransform();
            this.pumpValueExtractor = valueExtractor;
            return this;
        }

        public <K, V> BTreeMapMaker pumpSource(Iterator<Fun.Tuple2<K, V>> entriesSource) {
            this.pumpSource = entriesSource;
            this.pumpKeyExtractor = Fun.extractKey();
            this.pumpValueExtractor = Fun.extractValue();
            return this;
        }

        public BTreeMapMaker pumpPresort(int batchSize) {
            this.pumpPresortBatchSize = batchSize;
            return this;
        }

        public <K> BTreeMapMaker pumpIgnoreDuplicates() {
            this.pumpIgnoreDuplicates = true;
            return this;
        }

        public <K, V> BTreeMap<K, V> make() {
            return DB.this.createTreeMap(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <K, V> BTreeMap<K, V> makeOrGet() {
            DB dB = DB.this;
            synchronized (dB) {
                return DB.this.catGet(this.name + ".type") == null ? this.make() : DB.this.getTreeMap(this.name);
            }
        }

        public <V> BTreeMap<String, V> makeStringMap() {
            this.keySerializer = BTreeKeySerializer.STRING;
            return this.make();
        }

        public <V> BTreeMap<Long, V> makeLongMap() {
            this.keySerializer = BTreeKeySerializer.ZERO_OR_POSITIVE_LONG;
            return this.make();
        }
    }

    public class HTreeSetMaker {
        protected final String name;
        protected boolean counter = false;
        protected Serializer<?> serializer = null;
        protected long expireMaxSize = 0L;
        protected long expireStoreSize = 0L;
        protected long expire = 0L;
        protected long expireAccess = 0L;
        protected Hasher<?> hasher = null;

        public HTreeSetMaker(String name) {
            this.name = name;
        }

        public HTreeSetMaker counterEnable() {
            this.counter = true;
            return this;
        }

        public HTreeSetMaker serializer(Serializer<?> serializer) {
            this.serializer = serializer;
            return this;
        }

        public HTreeSetMaker expireMaxSize(long maxSize) {
            this.expireMaxSize = maxSize;
            this.counter = true;
            return this;
        }

        public HTreeSetMaker expireStoreSize(double maxStoreSize) {
            this.expireStoreSize = (long)(maxStoreSize * 1024.0 * 1024.0 * 1024.0);
            return this;
        }

        public HTreeSetMaker expireAfterWrite(long interval, TimeUnit timeUnit) {
            this.expire = timeUnit.toMillis(interval);
            return this;
        }

        public HTreeSetMaker expireAfterWrite(long interval) {
            this.expire = interval;
            return this;
        }

        public HTreeSetMaker expireAfterAccess(long interval, TimeUnit timeUnit) {
            this.expireAccess = timeUnit.toMillis(interval);
            return this;
        }

        public HTreeSetMaker expireAfterAccess(long interval) {
            this.expireAccess = interval;
            return this;
        }

        public HTreeSetMaker hasher(Hasher<?> hasher) {
            this.hasher = hasher;
            return this;
        }

        public <K> Set<K> make() {
            if (this.expireMaxSize != 0L) {
                this.counter = true;
            }
            return DB.this.createHashSet(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <K> Set<K> makeOrGet() {
            DB dB = DB.this;
            synchronized (dB) {
                return DB.this.catGet(this.name + ".type") == null ? this.make() : DB.this.getHashSet(this.name);
            }
        }
    }

    public class HTreeMapMaker {
        protected final String name;
        protected boolean counter = false;
        protected Serializer<?> keySerializer = null;
        protected Serializer<?> valueSerializer = null;
        protected long expireMaxSize = 0L;
        protected long expire = 0L;
        protected long expireAccess = 0L;
        protected long expireStoreSize;
        protected Hasher<?> hasher = null;
        protected Fun.Function1<?, ?> valueCreator = null;

        public HTreeMapMaker(String name) {
            this.name = name;
        }

        public HTreeMapMaker counterEnable() {
            this.counter = true;
            return this;
        }

        public HTreeMapMaker keySerializer(Serializer<?> keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        public HTreeMapMaker valueSerializer(Serializer<?> valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        public HTreeMapMaker expireMaxSize(long maxSize) {
            this.expireMaxSize = maxSize;
            this.counter = true;
            return this;
        }

        public HTreeMapMaker expireAfterWrite(long interval, TimeUnit timeUnit) {
            this.expire = timeUnit.toMillis(interval);
            return this;
        }

        public HTreeMapMaker expireAfterWrite(long interval) {
            this.expire = interval;
            return this;
        }

        public HTreeMapMaker expireAfterAccess(long interval, TimeUnit timeUnit) {
            this.expireAccess = timeUnit.toMillis(interval);
            return this;
        }

        public HTreeMapMaker expireAfterAccess(long interval) {
            this.expireAccess = interval;
            return this;
        }

        public HTreeMapMaker expireStoreSize(double maxStoreSize) {
            this.expireStoreSize = (long)(maxStoreSize * 1024.0 * 1024.0 * 1024.0);
            return this;
        }

        public HTreeMapMaker valueCreator(Fun.Function1<?, ?> valueCreator) {
            this.valueCreator = valueCreator;
            return this;
        }

        public HTreeMapMaker hasher(Hasher<?> hasher) {
            this.hasher = hasher;
            return this;
        }

        public <K, V> HTreeMap<K, V> make() {
            if (this.expireMaxSize != 0L) {
                this.counter = true;
            }
            return DB.this.createHashMap(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <K, V> HTreeMap<K, V> makeOrGet() {
            DB dB = DB.this;
            synchronized (dB) {
                return DB.this.catGet(this.name + ".type") == null ? this.make() : DB.this.getHashMap(this.name);
            }
        }
    }

    protected static class IdentityWrapper {
        final Object o;

        public IdentityWrapper(Object o) {
            this.o = o;
        }

        public int hashCode() {
            return System.identityHashCode(this.o);
        }

        public boolean equals(Object v) {
            return ((IdentityWrapper)v).o == this.o;
        }
    }
}

