/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.util.thread;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class StrictBlockingQueue<T>
extends LinkedBlockingQueue<T>
implements BlockingQueue<T> {
    private static final long serialVersionUID = -8767657443214194248L;
    private List<Class<? extends T>> _allowedClasses = new LinkedList<Class<? extends T>>();

    public StrictBlockingQueue(int capacity) {
        super(capacity);
    }

    public void addAllowedClass(Class<? extends T> c) {
        this._allowedClasses.add(c);
    }

    private boolean allowed(T e) {
        for (Class<T> c : this._allowedClasses) {
            if (!c.isInstance(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(T e) {
        if (this.allowed(e)) {
            return super.add(e);
        }
        throw new IllegalArgumentException("Class type not allowed: " + e.getClass().toString());
    }

    @Override
    public boolean offer(T e) {
        if (this.allowed(e)) {
            return super.offer(e);
        }
        throw new IllegalArgumentException("Class type not allowed: " + e.getClass().toString());
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.allowed(e)) {
            return super.offer(e, timeout, unit);
        }
        throw new IllegalArgumentException("Class type not allowed: " + e.getClass().toString());
    }

    @Override
    public void put(T e) throws InterruptedException {
        if (this.allowed(e)) {
            super.put(e);
        }
        throw new IllegalArgumentException("Class type not allowed: " + e.getClass().toString());
    }
}

