/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.util.thread;

import java.util.function.Consumer;
import net.scattersphere.job.AbstractJob;
import net.scattersphere.util.thread.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerThread
extends Thread {
    private JobExecutionContext jeStatus;
    private Runnable onStart;
    private Runnable onComplete;
    private Consumer<Exception> onException;
    private final Logger LOG = LoggerFactory.getLogger(JobManagerThread.class);

    public JobManagerThread(JobExecutionContext jeStatus) {
        this.jeStatus = jeStatus;
        this.onStart = null;
        this.onComplete = null;
        this.onException = null;
    }

    public JobManagerThread started(Runnable onStart) {
        this.onStart = onStart;
        return this;
    }

    public JobManagerThread completed(Runnable onComplete) {
        this.onComplete = onComplete;
        return this;
    }

    public JobManagerThread exception(Consumer<Exception> onException) {
        this.onException = onException;
        return this;
    }

    @Override
    public void run() {
        boolean exceptionState = false;
        this.LOG.debug("Running job: {}", (Object)this.jeStatus.getJob());
        if (this.onStart != null) {
            this.onStart.run();
        }
        try {
            this.jeStatus.getJob().prepare(this.jeStatus.getArguments());
            this.jeStatus.getJob().run();
            if (this.jeStatus.getJob() instanceof AbstractJob) {
                AbstractJob aJob = (AbstractJob)this.jeStatus.getJob();
                aJob.closeStream();
            }
        }
        catch (Exception ex) {
            this.LOG.info("Exception occurred during prepare/run of job.", ex);
            if (this.onException != null) {
                this.onException.accept(ex);
            }
            exceptionState = true;
        }
        if (this.onComplete != null && !exceptionState) {
            this.onComplete.run();
        }
    }
}

