/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.util.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.scattersphere.util.thread.JobExecutionContext;
import net.scattersphere.util.thread.JobExecutionResult;
import net.scattersphere.util.thread.JobManagerCache;
import net.scattersphere.util.thread.JobManagerThread;
import net.scattersphere.util.thread.StrictBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerQueueExecutor
extends Thread {
    private volatile JobExecutionContext status = null;
    private volatile JobManagerThread jmThread = null;
    private volatile boolean isRunning = false;
    private final StrictBlockingQueue<JobExecutionContext> queuedJobs;
    private final Logger LOG = LoggerFactory.getLogger(JobManagerQueueExecutor.class);

    public JobManagerQueueExecutor(String threadName) {
        super(threadName);
        int threadsAvailable = Runtime.getRuntime().availableProcessors();
        this.queuedJobs = new StrictBlockingQueue(threadsAvailable * 16);
        this.queuedJobs.addAllowedClass(JobExecutionContext.class);
    }

    public void queue(JobExecutionContext job) {
        job.getJobContext().setJobResult(JobExecutionResult.QUEUED);
        this.queuedJobs.add(job);
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                this.status = (JobExecutionContext)this.queuedJobs.take();
                this.jmThread = new JobManagerThread(this.status);
                this.LOG.info("[{}] new job received: thread={}", (Object)this.getName(), (Object)this.jmThread);
                this.jmThread.started(() -> {
                    this.status.getJobContext().setJobResult(JobExecutionResult.RUNNING);
                    this.status.getJobContext().setJobStart();
                    JobManagerCache.instance().addRunningJob(this.status);
                }).completed(() -> {
                    this.status.getJobContext().setJobResult(JobExecutionResult.COMPLETED);
                    this.status.getJobContext().setJobEnd();
                    JobManagerCache.instance().removeRunningJob(this.status);
                    JobManagerCache.instance().addCompletedJob(this.status);
                    this.LOG.info("[{}] complete: elapsed={}ms", (Object)this.getName(), (Object)(this.status.getJobContext().getJobEnd() - this.status.getJobContext().getJobStart()));
                }).exception(ex -> {
                    this.LOG.info("[{}] exception state", (Object)this.getName(), ex);
                    if (ex instanceof RuntimeException) {
                        Exception cause = (Exception)ex.getCause();
                        if (cause instanceof InterruptedException) {
                            this.status.getJobContext().setJobResult(JobExecutionResult.STOPPED, cause);
                        } else {
                            this.status.getJobContext().setJobResult(JobExecutionResult.FAILED, (Exception)ex);
                        }
                    } else {
                        this.status.getJobContext().setJobResult(JobExecutionResult.FAILED, (Exception)ex);
                    }
                    this.status.getJobContext().setJobEnd();
                    JobManagerCache.instance().removeRunningJob(this.status);
                    JobManagerCache.instance().addFailedJob(this.status);
                }).start();
                this.LOG.info("[{}] joining thread, waiting to complete.", (Object)this.getName());
                this.jmThread.join();
                this.LOG.info("[{}] join of thread complete, thread execution done: {}", (Object)this.getName(), (Object)this.status.getJobContext());
                this.status = null;
            }
            catch (InterruptedException e) {
                this.LOG.info("Job Manager Queue Executor thread interrupted.  Exiting.");
                return;
            }
        }
    }

    public boolean stop(String jobId, String reason) {
        if (this.status != null && this.status.getJobContext().getJobId().equals(jobId)) {
            this.status.getJobContext().setJobStopReason(reason);
            this.jmThread.interrupt();
            return true;
        }
        AtomicInteger removedJobsCount = new AtomicInteger(0);
        this.queuedJobs.stream().forEach(job -> {
            if (job.getJobContext().getJobId().equals(jobId)) {
                job.getJobContext().setJobStopReason(reason);
                removedJobsCount.incrementAndGet();
                this.queuedJobs.remove(job);
            }
        });
        return removedJobsCount.get() > 0;
    }

    public boolean isQueued(String jobId) {
        AtomicInteger jobsCount = new AtomicInteger(0);
        this.queuedJobs.stream().forEach(job -> {
            if (job.getJobContext().getJobId().equals(jobId)) {
                jobsCount.incrementAndGet();
            }
        });
        return jobsCount.get() > 0;
    }

    public List<JobExecutionContext> getQueuedJobs() {
        ArrayList<JobExecutionContext> returnList = new ArrayList<JobExecutionContext>();
        returnList.addAll(this.queuedJobs);
        return returnList;
    }
}

