/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.util.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.scattersphere.util.thread.JobExecutionContext;

public class JobManagerCache {
    private static final JobManagerCache instance = new JobManagerCache();
    private final Map<String, JobExecutionContext> runningJobs = new ConcurrentHashMap<String, JobExecutionContext>();
    private final List<JobExecutionContext> completedJobs = new ArrayList<JobExecutionContext>();
    private final List<JobExecutionContext> failedJobs = new ArrayList<JobExecutionContext>();

    private JobManagerCache() {
    }

    public static JobManagerCache instance() {
        return instance;
    }

    public void addRunningJob(JobExecutionContext job) {
        this.runningJobs.put(job.getJobContext().getJobId(), job);
    }

    public void removeRunningJob(JobExecutionContext job) {
        this.runningJobs.remove(job.getJobContext().getJobId());
    }

    public void addCompletedJob(JobExecutionContext job) {
        this.completedJobs.add(job);
    }

    public void addFailedJob(JobExecutionContext job) {
        this.failedJobs.add(job);
    }

    public JobExecutionContext findJobStatus(String jobId) {
        JobExecutionContext foundJob = null;
        foundJob = this.runningJobs.get(jobId);
        if (foundJob != null) {
            return foundJob;
        }
        for (JobExecutionContext completedJob : this.completedJobs) {
            if (!completedJob.getJobContext().getJobId().equals(jobId)) continue;
            return completedJob;
        }
        for (JobExecutionContext failedJob : this.failedJobs) {
            if (!failedJob.getJobContext().getJobId().equals(jobId)) continue;
            return failedJob;
        }
        return null;
    }

    public List<JobExecutionContext> getRunningJobs() {
        return new ArrayList<JobExecutionContext>(this.runningJobs.values());
    }

    public List<JobExecutionContext> getCompletedJobs() {
        return this.completedJobs;
    }

    public List<JobExecutionContext> getFailedJobs() {
        return this.failedJobs;
    }
}

