/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.util.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.scattersphere.job.AbstractJob;
import net.scattersphere.job.Job;
import net.scattersphere.util.thread.JobExecutionContext;
import net.scattersphere.util.thread.JobExecutionResult;
import net.scattersphere.util.thread.JobManagerCache;
import net.scattersphere.util.thread.JobManagerQueueExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager {
    private static final JobManager instance = new JobManager();
    private final List<JobManagerQueueExecutor> knownExecutors;
    private final AtomicInteger currentExecutorPosition;
    private final Logger LOG = LoggerFactory.getLogger(JobManager.class);

    private JobManager() {
        int threadsAvailable = Runtime.getRuntime().availableProcessors();
        this.LOG.info("*** Threads available: {}", (Object)threadsAvailable);
        this.knownExecutors = new ArrayList<JobManagerQueueExecutor>();
        for (int i = 0; i < threadsAvailable; ++i) {
            JobManagerQueueExecutor jmqExecutor = new JobManagerQueueExecutor("Job Manager Executor - Managed Thread Controller #" + (i + 1));
            this.knownExecutors.add(jmqExecutor);
            jmqExecutor.start();
        }
        this.currentExecutorPosition = new AtomicInteger(0);
    }

    public static JobManager instance() {
        return instance;
    }

    public String queue(Job job, String jobName, String[] arguments) {
        int queuePosition = this.currentExecutorPosition.incrementAndGet();
        if (queuePosition >= this.knownExecutors.size()) {
            queuePosition = 0;
            this.currentExecutorPosition.set(0);
        }
        JobManagerQueueExecutor executor = this.knownExecutors.get(queuePosition);
        JobExecutionContext context = new JobExecutionContext(job, jobName, arguments);
        if (job instanceof AbstractJob) {
            AbstractJob aJob = (AbstractJob)job;
            aJob.setJobId(context.getJobContext().getJobId());
        }
        executor.queue(context);
        return context.getJobContext().getJobId();
    }

    public boolean stop(String jobId, String reason) {
        for (JobManagerQueueExecutor exec : this.knownExecutors) {
            if (!exec.stop(jobId, reason)) continue;
            return true;
        }
        return false;
    }

    public String status(String jobId) {
        for (JobManagerQueueExecutor exec : this.knownExecutors) {
            if (!exec.isQueued(jobId)) continue;
            return JobExecutionResult.QUEUED.toString();
        }
        JobExecutionContext context = JobManagerCache.instance().findJobStatus(jobId);
        if (context != null) {
            return context.getJobContext().getJobResult().toString();
        }
        return "NOT FOUND";
    }

    public List<JobExecutionContext> getQueuedJobs() {
        ArrayList<JobExecutionContext> returnList = new ArrayList<JobExecutionContext>();
        for (JobManagerQueueExecutor exec : this.knownExecutors) {
            returnList.addAll(exec.getQueuedJobs());
        }
        return returnList;
    }
}

